/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultFuelDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class DefaultFuelCategory
implements DisplayCategory<DefaultFuelDisplay> {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    @Override
    public CategoryIdentifier<? extends DefaultFuelDisplay> getCategoryIdentifier() {
        return BuiltinPlugin.FUEL;
    }

    @Override
    public Component getTitle() {
        return Component.m_237115_((String)"category.rei.fuel");
    }

    @Override
    public int getDisplayHeight() {
        return 49;
    }

    @Override
    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)Items.f_42413_);
    }

    @Override
    public List<Widget> setupDisplay(DefaultFuelDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.getCenterY() - 17);
        String burnItems = DECIMAL_FORMAT.format((double)display.getFuelTime() / 200.0);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase(bounds));
        widgets.add(Widgets.createLabel(new Point(bounds.x + 26, bounds.getMaxY() - 15), (Component)Component.m_237110_((String)"category.rei.fuel.time.items", (Object[])new Object[]{burnItems})).color(-12566464, -4473925).noShadow().leftAligned());
        widgets.add(Widgets.createBurningFire(new Point(bounds.x + 6, startPoint.y + 1)).animationDurationTicks(display.getFuelTime()));
        widgets.add(Widgets.createSlot(new Point(bounds.x + 6, startPoint.y + 18)).entries(display.getInputEntries().get(0)).markInput());
        return widgets;
    }

    @Override
    public DisplayRenderer getDisplayRenderer(DefaultFuelDisplay display) {
        final Slot slot = Widgets.createSlot(new Point(0, 0)).entries(display.getInputEntries().get(0)).disableBackground().disableHighlight();
        final String burnItems = DECIMAL_FORMAT.format((double)display.getFuelTime() / 200.0);
        return new DisplayRenderer(){
            private Component text;
            {
                this.text = Component.m_237110_((String)"category.rei.fuel.time_short.items", (Object[])new Object[]{burnItems});
            }

            @Override
            public int getHeight() {
                return 22;
            }

            @Override
            @Nullable
            public Tooltip getTooltip(TooltipContext context) {
                if (slot.containsMouse(context.getPoint())) {
                    return slot.getCurrentTooltip(context);
                }
                return null;
            }

            @Override
            public void render(PoseStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                slot.setZ(this.getZ() + 50);
                slot.getBounds().setLocation(bounds.x + 4, bounds.y + 2);
                slot.m_6305_(matrices, mouseX, mouseY, delta);
                Minecraft.m_91087_().f_91062_.m_92744_(matrices, this.text.m_7532_(), (float)(bounds.x + 25), (float)(bounds.y + 8), -1);
            }
        };
    }
}

