/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.tag;

import com.mojang.serialization.DataResult;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.transformers.SplitPacketTransformer;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import me.shedaniel.rei.plugin.common.displays.tag.TagNode;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TagNodes {
    public static final ResourceLocation REQUEST_TAGS_PACKET_C2S = new ResourceLocation("roughlyenoughitems", "request_tags_c2s");
    public static final ResourceLocation REQUEST_TAGS_PACKET_S2C = new ResourceLocation("roughlyenoughitems", "request_tags_s2c");
    public static final Map<String, ResourceKey<? extends Registry<?>>> TAG_DIR_MAP = new HashMap();
    public static final ThreadLocal<String> CURRENT_TAG_DIR = new ThreadLocal();
    public static final Map<String, Map<CollectionWrapper<?>, RawTagData>> RAW_TAG_DATA_MAP = new ConcurrentHashMap();
    public static final Map<ResourceKey<? extends Registry<?>>, Map<ResourceLocation, TagData>> TAG_DATA_MAP = new HashMap();
    public static Map<ResourceKey<? extends Registry<?>>, Consumer<Consumer<DataResult<Map<ResourceLocation, TagData>>>>> requestedTags = new HashMap();

    private static void writeResourceLocation(FriendlyByteBuf buf, ResourceLocation location) {
        if (location.m_135827_().equals("minecraft")) {
            buf.m_130070_(location.m_135815_());
        } else {
            buf.m_130070_(location.toString());
        }
    }

    public static void init() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> Client::init);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)REQUEST_TAGS_PACKET_C2S, Collections.singletonList(new SplitPacketTransformer()), (buf, context) -> {
            UUID uuid = buf.m_130259_();
            ResourceKey resourceKey = ResourceKey.m_135788_((ResourceLocation)buf.m_130281_());
            FriendlyByteBuf newBuf = new FriendlyByteBuf(Unpooled.buffer());
            newBuf.m_130077_(uuid);
            Map dataMap = TAG_DATA_MAP.getOrDefault(resourceKey, Collections.emptyMap());
            newBuf.writeInt(dataMap.size());
            for (Map.Entry entry : dataMap.entrySet()) {
                TagNodes.writeResourceLocation(newBuf, (ResourceLocation)entry.getKey());
                ((TagData)entry.getValue()).toNetwork(newBuf);
            }
            NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)context.getPlayer()), (ResourceLocation)REQUEST_TAGS_PACKET_S2C, (FriendlyByteBuf)newBuf);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void requestTagData(ResourceKey<? extends Registry<?>> resourceKey, Consumer<DataResult<Map<ResourceLocation, TagData>>> callback) {
        if (Minecraft.m_91087_().m_91092_() != null) {
            callback.accept((DataResult<Map<ResourceLocation, TagData>>)DataResult.success(TAG_DATA_MAP.get(resourceKey)));
        } else if (!NetworkManager.canServerReceive((ResourceLocation)REQUEST_TAGS_PACKET_C2S)) {
            callback.accept((DataResult<Map<ResourceLocation, TagData>>)DataResult.error((String)"Cannot request tags from server"));
        } else if (requestedTags.containsKey(resourceKey)) {
            requestedTags.get(resourceKey).accept(callback);
            callback.accept((DataResult<Map<ResourceLocation, TagData>>)DataResult.success(TAG_DATA_MAP.getOrDefault(resourceKey, Collections.emptyMap())));
        } else {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            UUID uuid = UUID.randomUUID();
            buf.m_130077_(uuid);
            buf.m_130085_(resourceKey.m_135782_());
            Client.nextUUID = uuid;
            Client.nextResourceKey = resourceKey;
            CopyOnWriteArrayList<Consumer<DataResult<Map<ResourceLocation, TagData>>>> callbacks = new CopyOnWriteArrayList<Consumer<DataResult<Map<ResourceLocation, TagData>>>>();
            callbacks.add(callback);
            Client.nextCallback = mapDataResult -> {
                requestedTags.put(resourceKey, c -> c.accept(mapDataResult));
                for (Consumer consumer : callbacks) {
                    consumer.accept(mapDataResult);
                }
            };
            requestedTags.put(resourceKey, callbacks::add);
            NetworkManager.sendToServer((ResourceLocation)REQUEST_TAGS_PACKET_C2S, (FriendlyByteBuf)buf);
        }
    }

    public static <T> void create(TagKey<T> tagKey, Consumer<DataResult<TagNode<T>>> callback) {
        Registry registry = (Registry)Registry.f_122897_.m_6246_(tagKey.f_203867_());
        TagNodes.requestTagData(tagKey.f_203867_(), result -> callback.accept(result.flatMap(dataMap -> dataMap != null ? TagNodes.resolveTag(tagKey, registry, dataMap).orElse(DataResult.error((String)"No tag data")) : DataResult.error((String)"No tag data"))));
    }

    private static <T> Optional<DataResult<TagNode<T>>> resolveTag(TagKey<T> tagKey, Registry<T> registry, Map<ResourceLocation, TagData> tagDataMap) {
        TagData tagData = tagDataMap.get(tagKey.f_203868_());
        if (tagData == null) {
            return Optional.empty();
        }
        TagNode<T> self = TagNode.ofReference(tagKey);
        ArrayList<Holder> holders = new ArrayList<Holder>();
        IntListIterator intListIterator = tagData.otherElements().iterator();
        while (intListIterator.hasNext()) {
            int element = (Integer)intListIterator.next();
            Optional holder = registry.m_203300_(element);
            if (!holder.isPresent()) continue;
            holders.add((Holder)holder.get());
        }
        if (!holders.isEmpty()) {
            self.addValuesChild((HolderSet<T>)HolderSet.m_205800_(holders));
        }
        for (ResourceLocation childTagId : tagData.otherTags()) {
            Optional<DataResult<TagNode<T>>> resultOptional;
            TagKey childTagKey = TagKey.m_203882_((ResourceKey)tagKey.f_203867_(), (ResourceLocation)childTagId);
            if (!registry.m_203431_(childTagKey).isPresent() || !(resultOptional = TagNodes.resolveTag(childTagKey, registry, tagDataMap)).isPresent()) continue;
            DataResult<TagNode<T>> result = resultOptional.get();
            if (result.error().isPresent()) {
                return Optional.of(DataResult.error((String)((DataResult.PartialResult)result.error().get()).message()));
            }
            self.addChild((TagNode)result.result().get());
        }
        return Optional.of(DataResult.success(self));
    }

    private static class Client {
        public static UUID nextUUID;
        public static ResourceKey<? extends Registry<?>> nextResourceKey;
        public static Consumer<DataResult<Map<ResourceLocation, TagData>>> nextCallback;

        private Client() {
        }

        private static void init() {
            ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(world -> requestedTags.clear());
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), (ResourceLocation)REQUEST_TAGS_PACKET_S2C, (buf, context) -> {
                UUID uuid = buf.m_130259_();
                if (nextUUID.equals(uuid)) {
                    HashMap<ResourceLocation, TagData> map = new HashMap<ResourceLocation, TagData>();
                    int count = buf.readInt();
                    for (int i = 0; i < count; ++i) {
                        map.put(buf.m_130281_(), TagData.fromNetwork(buf));
                    }
                    TAG_DATA_MAP.put(nextResourceKey, map);
                    nextCallback.accept((DataResult<Map<ResourceLocation, TagData>>)DataResult.success(map));
                    nextUUID = null;
                    nextResourceKey = null;
                    nextCallback = null;
                }
            });
        }
    }

    public record TagData(IntList otherElements, List<ResourceLocation> otherTags) {
        private static TagData fromNetwork(FriendlyByteBuf buf) {
            int count = buf.m_130242_();
            IntArrayList otherElements = new IntArrayList(count + 1);
            for (int i = 0; i < count; ++i) {
                otherElements.add(buf.m_130242_());
            }
            count = buf.m_130242_();
            ArrayList<ResourceLocation> otherTags = new ArrayList<ResourceLocation>(count + 1);
            for (int i = 0; i < count; ++i) {
                otherTags.add(buf.m_130281_());
            }
            return new TagData((IntList)otherElements, otherTags);
        }

        private void toNetwork(FriendlyByteBuf buf) {
            buf.m_130130_(this.otherElements.size());
            IntListIterator intListIterator = this.otherElements.iterator();
            while (intListIterator.hasNext()) {
                int integer = (Integer)intListIterator.next();
                buf.m_130130_(integer);
            }
            buf.m_130130_(this.otherTags.size());
            for (ResourceLocation tag : this.otherTags) {
                TagNodes.writeResourceLocation(buf, tag);
            }
        }
    }

    public record RawTagData(List<ResourceLocation> otherElements, List<ResourceLocation> otherTags) {
    }

    public static class CollectionWrapper<T> {
        private final Collection<T> collection;

        public CollectionWrapper(Collection<T> collection) {
            this.collection = collection;
        }

        public boolean equals(Object obj) {
            return obj instanceof CollectionWrapper && ((CollectionWrapper)obj).collection == this.collection;
        }

        public int hashCode() {
            return System.identityHashCode(this.collection);
        }
    }
}

