/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.config;

import java.util.HashMap;
import me.hypherionmc.shaded.moonconfig.core.file.FileWatcher;
import me.hypherionmc.simplerpclib.RPCConstants;
import me.hypherionmc.simplerpclib.config.BaseRPCConfig;

class ConfigWatcherController {
    private static final HashMap<Object, FileWatcher> monitoredConfigs = new HashMap();

    ConfigWatcherController() {
    }

    static void register_config(BaseRPCConfig config) {
        if (monitoredConfigs.containsKey(config)) {
            RPCConstants.logger.error("Failed to register " + config.getConfigPath().getName() + ". Config already registered");
        } else {
            FileWatcher configWatcher = FileWatcher.defaultInstance();
            try {
                configWatcher.addWatch(config.getConfigPath(), () -> {
                    RPCConstants.logger.info("Sending Reload Event for: " + config.getConfigPath().getName());
                    config.configReloaded();
                });
                monitoredConfigs.put(config, configWatcher);
                RPCConstants.logger.info("Registered " + config.getConfigPath().getName() + " successfully!");
            }
            catch (Exception e) {
                RPCConstants.logger.error("Failed to register " + config.getConfigPath().getName() + " for auto reloading. " + e.getMessage());
            }
        }
    }
}

