/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.TextureCache;
import journeymap.common.Journeymap;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.SkullBlockEntity;

public class IgnSkin {
    private static String ID_LOOKUP_URL = "https://api.mojang.com/users/profiles/minecraft/%s?at=%s";
    private static String PROFILE_URL = "https://sessionserver.mojang.com/session/minecraft/profile/%s";
    private static Map<UUID, NativeImage> faceImageCache = Maps.newHashMap();
    private static final Map<URL, CompletableFuture<NativeImage>> imageRequests = Maps.newConcurrentMap();

    public static NativeImage getFaceImage(UUID playerId, String username) {
        boolean firstPass;
        boolean bl = firstPass = !faceImageCache.containsKey(playerId);
        if (firstPass) {
            faceImageCache.put(playerId, null);
            SkullBlockEntity.m_155738_((GameProfile)new GameProfile(playerId, username), gameProfile -> {
                try {
                    MinecraftSessionService mss = Minecraft.m_91087_().m_91108_();
                    Map map = mss.getTextures(gameProfile, false);
                    if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                        Journeymap.getLogger().debug("Retrieved skin for {} : {}", (Object)playerId, (Object)username);
                        MinecraftProfileTexture mpt = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
                        IgnSkin.getImageFromUrl(new URL(mpt.getUrl()), image -> faceImageCache.put(playerId, IgnSkin.cropToFace(image)));
                    } else {
                        Journeymap.getLogger().debug("Unable to retrieve skin for {} : {}", (Object)playerId, (Object)username);
                        ResourceLocation resourceLocation = DefaultPlayerSkin.m_118627_((UUID)playerId);
                        NativeImage skinImage = TextureCache.getTexture(resourceLocation).getNativeImage();
                        faceImageCache.put(playerId, IgnSkin.cropToFace(skinImage));
                    }
                }
                catch (Throwable e) {
                    Journeymap.getLogger().warn("Error getting face image for " + username + ": " + e.getMessage());
                }
            });
        }
        return faceImageCache.get(playerId);
    }

    private static void getImageFromUrl(URL imageURL, Consumer<NativeImage> imageConsumer) {
        CompletableFuture<NativeImage> future = imageRequests.get(imageURL);
        if (future != null) {
            imageRequests.put(imageURL, (CompletableFuture<NativeImage>)future.whenCompleteAsync((image, throwable) -> imageConsumer.accept((NativeImage)image), (Executor)Util.m_183991_()));
        } else {
            imageRequests.put(imageURL, (CompletableFuture<NativeImage>)CompletableFuture.supplyAsync(() -> IgnSkin.downloadImage(imageURL), Util.m_183991_()).whenCompleteAsync((image, throwable) -> imageConsumer.accept((NativeImage)image), (Executor)Util.m_183991_()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NativeImage downloadImage(URL imageURL) {
        NativeImage img = null;
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)imageURL.openConnection(Minecraft.m_91087_().m_91096_());
            HttpURLConnection.setFollowRedirects(true);
            conn.setInstanceFollowRedirects(true);
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.connect();
            if (conn.getResponseCode() / 100 == 2) {
                img = NativeImage.m_85058_((InputStream)conn.getInputStream());
            } else {
                Journeymap.getLogger().debug("Bad Response getting image: " + imageURL + " : " + conn.getResponseCode());
            }
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Error getting skin image: " + imageURL + " : " + e.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        Journeymap.getLogger().debug("Getting Skin for URL: {}", (Object)imageURL);
        return img;
    }

    private static NativeImage cropToFace(NativeImage playerSkin) {
        if (playerSkin != null) {
            if (playerSkin.m_85102_().m_85171_()) {
                NativeImage hat = ImageUtil.getSubImage(40, 8, 8, 8, playerSkin, false);
                for (int x = 0; x < 8; ++x) {
                    for (int y = 0; y < 8; ++y) {
                        int hatPixel = hat.m_84985_(x, y);
                        playerSkin.m_166411_(x + 8, y + 8, hatPixel);
                    }
                }
                hat.close();
            }
            NativeImage sub = ImageUtil.getSubImage(8, 8, 8, 8, playerSkin, true);
            return ImageUtil.getSizedImage(24, 24, sub, true);
        }
        return new NativeImage(24, 24, false);
    }
}

