/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.ObjIntConsumer;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.FilterButton;
import mekanism.client.gui.element.button.FilterSelectButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MovableFilterButton
extends FilterButton {
    private final FilterSelectButton upButton;
    private final FilterSelectButton downButton;

    public MovableFilterButton(IGuiWrapper gui, int x, int y, int index, IntSupplier filterIndex, FilterManager<?> filterManager, IntConsumer upButtonPress, IntConsumer downButtonPress, ObjIntConsumer<IFilter<?>> onPress, IntConsumer toggleButtonPress, Function<IFilter<?>, List<ItemStack>> renderStackSupplier) {
        this(gui, x, y, 96, 29, index, filterIndex, filterManager, upButtonPress, downButtonPress, onPress, toggleButtonPress, renderStackSupplier);
    }

    public MovableFilterButton(IGuiWrapper gui, int x, int y, int width, int height, int index, IntSupplier filterIndex, FilterManager<?> filterManager, IntConsumer upButtonPress, IntConsumer downButtonPress, ObjIntConsumer<IFilter<?>> onPress, IntConsumer toggleButtonPress, Function<IFilter<?>, List<ItemStack>> renderStackSupplier) {
        super(gui, x, y, width, height, index, filterIndex, filterManager, onPress, toggleButtonPress, renderStackSupplier);
        int arrowX = this.relativeX + width - 12;
        this.upButton = this.addPositionOnlyChild(new FilterSelectButton(gui, arrowX, this.relativeY + 1, false, () -> upButtonPress.accept(this.getActualIndex()), this.getOnHover(MekanismLang.MOVE_UP)));
        this.downButton = this.addPositionOnlyChild(new FilterSelectButton(gui, arrowX, this.relativeY + height - 8, true, () -> downButtonPress.accept(this.getActualIndex()), this.getOnHover(MekanismLang.MOVE_DOWN)));
    }

    @Override
    protected int getToggleXShift() {
        return 13;
    }

    @Override
    protected int getToggleYShift() {
        return 1;
    }

    @Override
    public void m_5716_(double mouseX, double mouseY) {
        if (this.upButton.m_5953_(mouseX, mouseY)) {
            this.upButton.m_5716_(mouseX, mouseY);
        } else if (this.downButton.m_5953_(mouseX, mouseY)) {
            this.downButton.m_5716_(mouseX, mouseY);
        } else {
            super.m_5716_(mouseX, mouseY);
        }
    }

    @Override
    public void renderForeground(PoseStack matrix, int mouseX, int mouseY) {
        int xAxis = mouseX - this.getGuiLeft();
        int yAxis = mouseY - this.getGuiTop();
        if (this.upButton.isMouseOverCheckWindows(mouseX, mouseY)) {
            this.upButton.m_7428_(matrix, xAxis, yAxis);
        } else if (this.downButton.isMouseOverCheckWindows(mouseX, mouseY)) {
            this.downButton.m_7428_(matrix, xAxis, yAxis);
        }
        super.renderForeground(matrix, mouseX, mouseY);
    }

    @Override
    protected void setVisibility(boolean visible) {
        super.setVisibility(visible);
        if (visible) {
            this.updateButtonVisibility();
        } else {
            this.upButton.f_93624_ = false;
            this.downButton.f_93624_ = false;
        }
    }

    private void updateButtonVisibility() {
        int index = this.getActualIndex();
        IFilter<?> filter = this.getFilter();
        this.upButton.f_93624_ = filter != null && index > 0;
        this.downButton.f_93624_ = filter != null && index < this.filterManager.count() - 1;
    }

    @Override
    public void drawBackground(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        IFilter<?> filter = this.getFilter();
        EnumColor color = filter instanceof IItemStackFilter ? EnumColor.INDIGO : (filter instanceof ITagFilter ? EnumColor.BRIGHT_GREEN : (filter instanceof IMaterialFilter ? EnumColor.PINK : (filter instanceof IModIDFilter ? EnumColor.RED : null)));
        if (color != null) {
            GuiUtils.fill(matrix, this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_, MekanismRenderer.getColorARGB(color, 0.5f));
            MekanismRenderer.resetColor();
        }
        this.updateButtonVisibility();
        this.upButton.onDrawBackground(matrix, mouseX, mouseY, partialTicks);
        this.downButton.onDrawBackground(matrix, mouseX, mouseY, partialTicks);
    }

    @Override
    protected int getMaxLength() {
        return super.getMaxLength() - 12;
    }
}

