/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.slot;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.interfaces.IJEIGhostTarget;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.warning.ISupportsWarning;
import mekanism.common.inventory.warning.WarningTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiSlot
extends GuiTexturedElement
implements IJEIGhostTarget,
ISupportsWarning<GuiSlot> {
    private static final int INVALID_SLOT_COLOR = MekanismRenderer.getColorARGB(EnumColor.DARK_RED, 0.8f);
    public static final int DEFAULT_HOVER_COLOR = -2130706433;
    private final SlotType slotType;
    private Supplier<ItemStack> validityCheck;
    private Supplier<ItemStack> storedStackSupplier;
    private Supplier<SlotOverlay> overlaySupplier;
    @Nullable
    private BooleanSupplier warningSupplier;
    @Nullable
    private IntSupplier overlayColorSupplier;
    @Nullable
    private SlotOverlay overlay;
    @Nullable
    private GuiElement.IHoverable onHover;
    @Nullable
    private GuiElement.IClickable onClick;
    private boolean renderHover;
    private boolean renderAboveSlots;
    @Nullable
    private IJEIGhostTarget.IGhostIngredientConsumer ghostHandler;

    public GuiSlot(SlotType type, IGuiWrapper gui, int x, int y) {
        super(type.getTexture(), gui, x, y, type.getWidth(), type.getHeight());
        this.slotType = type;
        this.f_93623_ = false;
    }

    public GuiSlot validity(Supplier<ItemStack> validityCheck) {
        this.validityCheck = validityCheck;
        return this;
    }

    @Override
    public GuiSlot warning(@NotNull WarningTracker.WarningType type, @NotNull BooleanSupplier warningSupplier) {
        this.warningSupplier = ISupportsWarning.compound(this.warningSupplier, this.gui().trackWarning(type, warningSupplier));
        return this;
    }

    public GuiSlot stored(Supplier<ItemStack> storedStackSupplier) {
        this.storedStackSupplier = storedStackSupplier;
        return this;
    }

    public GuiSlot hover(GuiElement.IHoverable onHover) {
        this.onHover = onHover;
        return this;
    }

    public GuiSlot click(GuiElement.IClickable onClick) {
        this.onClick = onClick;
        return this;
    }

    public GuiSlot with(SlotOverlay overlay) {
        this.overlay = overlay;
        return this;
    }

    public GuiSlot overlayColor(IntSupplier colorSupplier) {
        this.overlayColorSupplier = colorSupplier;
        return this;
    }

    public GuiSlot with(Supplier<SlotOverlay> overlaySupplier) {
        this.overlaySupplier = overlaySupplier;
        return this;
    }

    public GuiSlot setRenderHover(boolean renderHover) {
        this.renderHover = renderHover;
        return this;
    }

    public GuiSlot setGhostHandler(@Nullable IJEIGhostTarget.IGhostIngredientConsumer ghostHandler) {
        this.ghostHandler = ghostHandler;
        return this;
    }

    public GuiSlot setRenderAboveSlots() {
        this.renderAboveSlots = true;
        return this;
    }

    @Override
    public void m_6303_(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (!this.renderAboveSlots) {
            this.draw(matrix);
        }
    }

    @Override
    public void drawBackground(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.renderAboveSlots) {
            this.draw(matrix);
        }
    }

    private void draw(@NotNull PoseStack matrix) {
        if (this.warningSupplier != null && this.warningSupplier.getAsBoolean()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.slotType.getWarningTexture());
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getResource());
        }
        GuiSlot.m_93133_((PoseStack)matrix, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)0.0f, (int)this.f_93618_, (int)this.f_93619_, (int)this.f_93618_, (int)this.f_93619_);
        if (this.overlaySupplier != null) {
            this.overlay = this.overlaySupplier.get();
        }
        if (this.overlay != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.overlay.getTexture());
            GuiSlot.m_93133_((PoseStack)matrix, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)0.0f, (int)this.overlay.getWidth(), (int)this.overlay.getHeight(), (int)this.overlay.getWidth(), (int)this.overlay.getHeight());
        }
        this.drawContents(matrix);
    }

    protected void drawContents(@NotNull PoseStack matrix) {
        ItemStack stored;
        if (this.validityCheck != null) {
            ItemStack invalid = this.validityCheck.get();
            if (!invalid.m_41619_()) {
                int xPos = this.f_93620_ + 1;
                int yPos = this.f_93621_ + 1;
                GuiSlot.m_93172_((PoseStack)matrix, (int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)INVALID_SLOT_COLOR);
                MekanismRenderer.resetColor();
                this.gui().renderItem(matrix, invalid, xPos, yPos);
            }
        } else if (this.storedStackSupplier != null && !(stored = this.storedStackSupplier.get()).m_41619_()) {
            this.gui().renderItem(matrix, stored, this.f_93620_ + 1, this.f_93621_ + 1);
        }
    }

    @Override
    public void renderForeground(PoseStack matrix, int mouseX, int mouseY) {
        int yPos;
        int xPos;
        if (this.renderHover && this.m_198029_()) {
            xPos = this.relativeX + 1;
            yPos = this.relativeY + 1;
            GuiSlot.m_93172_((PoseStack)matrix, (int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)-2130706433);
            MekanismRenderer.resetColor();
        }
        if (this.overlayColorSupplier != null) {
            matrix.m_85836_();
            matrix.m_85837_(0.0, 0.0, 10.0);
            xPos = this.relativeX + 1;
            yPos = this.relativeY + 1;
            GuiSlot.m_93172_((PoseStack)matrix, (int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)this.overlayColorSupplier.getAsInt());
            matrix.m_85849_();
            MekanismRenderer.resetColor();
        }
        if (this.m_198029_()) {
            this.m_7428_(matrix, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
        }
    }

    @Override
    public void m_7428_(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        if (this.onHover != null) {
            this.onHover.onHover(this, matrix, mouseX, mouseY);
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.onClick != null && this.m_7972_(button) && mouseX >= (double)(this.f_93620_ + this.borderSize()) && mouseY >= (double)(this.f_93621_ + this.borderSize()) && mouseX < (double)(this.f_93620_ + this.f_93618_ - this.borderSize()) && mouseY < (double)(this.f_93621_ + this.f_93619_ - this.borderSize())) {
            this.onClick.onClick(this, (int)mouseX, (int)mouseY);
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    @Nullable
    public IJEIGhostTarget.IGhostIngredientConsumer getGhostHandler() {
        return this.ghostHandler;
    }

    @Override
    public int borderSize() {
        return 1;
    }
}

