/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.item.ItemCraftingFormula;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.machine.TileEntityFormulaicAssemblicator;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GuiFormulaicAssemblicator
extends GuiConfigurableTile<TileEntityFormulaicAssemblicator, MekanismTileContainer<TileEntityFormulaicAssemblicator>> {
    private MekanismButton encodeFormulaButton;
    private MekanismButton stockControlButton;
    private MekanismButton fillEmptyButton;
    private MekanismButton craftSingleButton;
    private MekanismButton craftAvailableButton;
    private MekanismButton autoModeButton;

    public GuiFormulaicAssemblicator(MekanismTileContainer<TileEntityFormulaicAssemblicator> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.f_97727_ += 64;
        this.f_97731_ = this.f_97727_ - 94;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityFormulaicAssemblicator)this.tile).getEnergyContainer(), 159, 15)).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY, () -> {
            if (((TileEntityFormulaicAssemblicator)this.tile).getAutoMode() && ((TileEntityFormulaicAssemblicator)this.tile).hasRecipe()) {
                MachineEnergyContainer<TileEntityFormulaicAssemblicator> energyContainer = ((TileEntityFormulaicAssemblicator)this.tile).getEnergyContainer();
                return energyContainer.getEnergyPerTick().greaterThan(energyContainer.getEnergy());
            }
            return false;
        });
        this.addRenderableWidget(new GuiSlot(SlotType.OUTPUT_LARGE, this, 115, 16));
        this.addRenderableWidget((GuiProgress)new GuiProgress(() -> (double)((TileEntityFormulaicAssemblicator)this.tile).getOperatingTicks() / (double)((TileEntityFormulaicAssemblicator)this.tile).getTicksRequired(), ProgressType.TALL_RIGHT, (IGuiWrapper)this, 86, 43).jeiCrafting());
        this.addRenderableWidget(new GuiEnergyTab((IGuiWrapper)this, ((TileEntityFormulaicAssemblicator)this.tile).getEnergyContainer(), ((TileEntityFormulaicAssemblicator)this.tile)::usedEnergy));
        this.encodeFormulaButton = this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 7, 45, 14, this.getButtonLocation("encode_formula"), () -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.ENCODE_FORMULA, this.tile)), this.getOnHover(MekanismLang.ENCODE_FORMULA)));
        this.stockControlButton = this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 26, 75, 16, this.getButtonLocation("stock_control"), () -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.STOCK_CONTROL_BUTTON, this.tile)), this.getOnHover(() -> MekanismLang.STOCK_CONTROL.translate(BooleanStateDisplay.OnOff.of(((TileEntityFormulaicAssemblicator)this.tile).getStockControl())))));
        this.fillEmptyButton = this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 44, 75, 16, this.getButtonLocation("fill_empty"), () -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.MOVE_ITEMS, this.tile)), this.getOnHover(MekanismLang.FILL_EMPTY)));
        this.craftSingleButton = this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 71, 75, 16, this.getButtonLocation("craft_single"), () -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CRAFT_SINGLE, this.tile)), this.getOnHover(MekanismLang.CRAFT_SINGLE)));
        this.craftAvailableButton = this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 89, 75, 16, this.getButtonLocation("craft_available"), () -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CRAFT_ALL, this.tile)), this.getOnHover(MekanismLang.CRAFT_AVAILABLE)));
        this.autoModeButton = this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 107, 75, 16, this.getButtonLocation("auto_toggle"), () -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.NEXT_MODE, this.tile)), this.getOnHover(() -> MekanismLang.AUTO_MODE.translate(BooleanStateDisplay.OnOff.of(((TileEntityFormulaicAssemblicator)this.tile).getAutoMode())))));
        this.updateEnabledButtons();
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        this.encodeFormulaButton.f_93623_ = !((TileEntityFormulaicAssemblicator)this.tile).getAutoMode() && ((TileEntityFormulaicAssemblicator)this.tile).hasRecipe() && this.canEncode();
        this.stockControlButton.f_93623_ = ((TileEntityFormulaicAssemblicator)this.tile).formula != null && ((TileEntityFormulaicAssemblicator)this.tile).formula.isValidFormula();
        this.fillEmptyButton.f_93623_ = !((TileEntityFormulaicAssemblicator)this.tile).getAutoMode();
        this.craftSingleButton.f_93623_ = !((TileEntityFormulaicAssemblicator)this.tile).getAutoMode() && ((TileEntityFormulaicAssemblicator)this.tile).hasRecipe();
        this.craftAvailableButton.f_93623_ = !((TileEntityFormulaicAssemblicator)this.tile).getAutoMode() && ((TileEntityFormulaicAssemblicator)this.tile).hasRecipe();
        this.autoModeButton.f_93623_ = ((TileEntityFormulaicAssemblicator)this.tile).formula != null && ((TileEntityFormulaicAssemblicator)this.tile).formula.isValidFormula();
    }

    @Override
    protected void drawForegroundText(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    @Override
    protected ItemStack checkValidity(int slotIndex) {
        Slot slot;
        ItemStack stack;
        int i = slotIndex - 21;
        if (i >= 0 && ((TileEntityFormulaicAssemblicator)this.tile).formula != null && ((TileEntityFormulaicAssemblicator)this.tile).formula.isValidFormula() && !(stack = (ItemStack)((TileEntityFormulaicAssemblicator)this.tile).formula.input.get(i)).m_41619_() && ((slot = (Slot)((MekanismTileContainer)this.f_97732_).f_38839_.get(slotIndex)).m_7993_().m_41619_() || !((TileEntityFormulaicAssemblicator)this.tile).formula.isIngredientInPos(((TileEntityFormulaicAssemblicator)this.tile).m_58904_(), slot.m_7993_(), i))) {
            return stack;
        }
        return ItemStack.f_41583_;
    }

    @Override
    protected void m_7286_(@NotNull PoseStack matrix, float partialTick, int mouseX, int mouseY) {
        super.m_7286_(matrix, partialTick, mouseX, mouseY);
        SlotOverlay overlay = ((TileEntityFormulaicAssemblicator)this.tile).hasRecipe() ? SlotOverlay.CHECK : SlotOverlay.X;
        RenderSystem.m_157456_((int)0, (ResourceLocation)overlay.getTexture());
        GuiFormulaicAssemblicator.m_93133_((PoseStack)matrix, (int)(this.f_97735_ + 88), (int)(this.f_97736_ + 22), (float)0.0f, (float)0.0f, (int)overlay.getWidth(), (int)overlay.getHeight(), (int)overlay.getWidth(), (int)overlay.getHeight());
    }

    private boolean canEncode() {
        ItemCraftingFormula formula;
        if (((TileEntityFormulaicAssemblicator)this.tile).formula != null && ((TileEntityFormulaicAssemblicator)this.tile).formula.isValidFormula() || ((TileEntityFormulaicAssemblicator)this.tile).getFormulaSlot().isEmpty()) {
            return false;
        }
        ItemStack formulaStack = ((TileEntityFormulaicAssemblicator)this.tile).getFormulaSlot().getStack();
        Item item = formulaStack.m_41720_();
        return item instanceof ItemCraftingFormula && (formula = (ItemCraftingFormula)item).getInventory(formulaStack) == null;
    }
}

