/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.laser;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.lasers.ILaserDissipation;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.Mekanism;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.base.MekFakePlayer;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.LaserEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.network.to_client.PacketLaserHitBlock;
import mekanism.common.particle.LaserParticleData;
import mekanism.common.registries.MekanismDamageSource;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public abstract class TileEntityBasicLaser
extends TileEntityMekanism {
    protected LaserEnergyContainer energyContainer;
    @SyntheticComputerMethod(getter="getDiggingPos")
    private BlockPos digging;
    private FloatingLong diggingProgress = FloatingLong.ZERO;
    private FloatingLong lastFired = FloatingLong.ZERO;

    public TileEntityBasicLaser(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.addInitialEnergyContainers(builder, listener);
        return builder.build();
    }

    protected abstract void addInitialEnergyContainers(EnergyContainerHelper var1, IContentsListener var2);

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        FloatingLong firing = this.energyContainer.extract(this.toFire(), Action.SIMULATE, AutomationType.INTERNAL);
        if (!firing.isZero()) {
            if (!firing.equals(this.lastFired) || !this.getActive()) {
                this.setActive(true);
                this.lastFired = firing;
                this.sendUpdatePacket();
            }
            Direction direction = this.getDirection();
            Pos3D from = Pos3D.create(this).centre().translate(direction, 0.501);
            Pos3D to = from.translate(direction, (double)MekanismConfig.general.laserRange.get() - 0.002);
            BlockHitResult result = this.getWorldNN().m_45547_(new ClipContext((Vec3)from, (Vec3)to, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null));
            if (result.m_6662_() != HitResult.Type.MISS) {
                to = new Pos3D(result.m_82450_());
            }
            float laserEnergyScale = this.getEnergyScale(firing);
            FloatingLong remainingEnergy = firing.copy();
            List hitEntities = this.getWorldNN().m_45976_(Entity.class, Pos3D.getAABB(from, to));
            if (hitEntities.isEmpty()) {
                this.setEmittingRedstone(false);
            } else {
                this.setEmittingRedstone(true);
                Pos3D finalFrom = from;
                hitEntities.sort(Comparator.comparing(entity -> entity.m_20238_((Vec3)finalFrom)));
                FloatingLong energyPerDamage = (FloatingLong)MekanismConfig.general.laserEnergyPerDamage.get();
                for (Entity entity2 : hitEntities) {
                    float energyScale;
                    ItemEntity item;
                    if (entity2.m_6673_((DamageSource)MekanismDamageSource.LASER)) {
                        remainingEnergy = FloatingLong.ZERO;
                        to = from.adjustPosition(direction, entity2);
                        break;
                    }
                    if (entity2 instanceof ItemEntity && this.handleHitItem(item = (ItemEntity)entity2)) continue;
                    boolean updateEnergyScale = false;
                    FloatingLong value = remainingEnergy.divide(energyPerDamage);
                    float damage = value.floatValue();
                    float health = 0.0f;
                    if (entity2 instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity2;
                        boolean updateDamage = false;
                        if (livingEntity.m_21254_() && livingEntity.m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
                            float damageBlocked;
                            Vec3 viewVector = livingEntity.m_20252_(1.0f);
                            Vec3 vectorTo = from.m_82505_(livingEntity.m_20182_()).m_82541_();
                            vectorTo = new Vec3(vectorTo.f_82479_, 0.0, vectorTo.f_82481_);
                            if (vectorTo.m_82526_(viewVector) < 0.0 && (damageBlocked = this.damageShield(livingEntity, livingEntity.m_21211_(), damage, 2)) > 0.0f) {
                                if (livingEntity instanceof ServerPlayer) {
                                    ServerPlayer player = (ServerPlayer)livingEntity;
                                    MekanismCriteriaTriggers.BLOCK_LASER.trigger(player);
                                }
                                if ((remainingEnergy = remainingEnergy.minusEqual(energyPerDamage.multiply(damageBlocked))).isZero()) {
                                    to = from.adjustPosition(direction, entity2);
                                    break;
                                }
                                updateDamage = true;
                            }
                        }
                        double dissipationPercent = 0.0;
                        double refractionPercent = 0.0;
                        for (ItemStack armor : livingEntity.m_6168_()) {
                            Optional capability;
                            if (armor.m_41619_() || !(capability = armor.getCapability(Capabilities.LASER_DISSIPATION).resolve()).isPresent()) continue;
                            ILaserDissipation laserDissipation = (ILaserDissipation)capability.get();
                            dissipationPercent += laserDissipation.getDissipationPercent();
                            refractionPercent += laserDissipation.getRefractionPercent();
                            if (!(dissipationPercent >= 1.0)) continue;
                            break;
                        }
                        if (dissipationPercent > 0.0) {
                            if ((remainingEnergy = remainingEnergy.timesEqual(FloatingLong.create(1.0 - (dissipationPercent = Math.min(dissipationPercent, 1.0))))).isZero()) {
                                to = from.adjustPosition(direction, entity2);
                                break;
                            }
                            updateDamage = true;
                        }
                        if (refractionPercent > 0.0) {
                            refractionPercent = Math.min(refractionPercent, 1.0);
                            FloatingLong refractedEnergy = remainingEnergy.multiply(FloatingLong.create(refractionPercent));
                            value = remainingEnergy.subtract(refractedEnergy).divide(energyPerDamage);
                            damage = value.floatValue();
                            updateDamage = false;
                            updateEnergyScale = true;
                        }
                        if (updateDamage) {
                            value = remainingEnergy.divide(energyPerDamage);
                            damage = value.floatValue();
                        }
                        health = livingEntity.m_21223_();
                    }
                    if (damage > 0.0f) {
                        if (!entity2.m_5825_()) {
                            entity2.m_20254_(value.intValue());
                        }
                        int totemTimesUsed = -1;
                        if (entity2 instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)entity2;
                            MinecraftServer server = entity2.m_20194_();
                            if (server != null && server.m_7035_()) {
                                totemTimesUsed = player.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)Items.f_42747_));
                            }
                        }
                        int lastHurtResistTime = entity2.f_19802_;
                        entity2.f_19802_ = 0;
                        boolean damaged = entity2.m_6469_((DamageSource)MekanismDamageSource.LASER, damage);
                        entity2.f_19802_ = lastHurtResistTime;
                        if (damaged) {
                            if (entity2 instanceof LivingEntity) {
                                LivingEntity livingEntity = (LivingEntity)entity2;
                                damage = Math.min(damage, Math.max(0.0f, health - livingEntity.m_21223_()));
                                if (entity2 instanceof ServerPlayer) {
                                    ServerPlayer player = (ServerPlayer)entity2;
                                    boolean hardcoreTotem = totemTimesUsed != -1 && totemTimesUsed < player.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)Items.f_42747_));
                                    MekanismCriteriaTriggers.DAMAGE.trigger(player, MekanismDamageSource.LASER, hardcoreTotem);
                                }
                            }
                            if ((remainingEnergy = remainingEnergy.minusEqual(energyPerDamage.multiply(damage))).isZero()) {
                                to = from.adjustPosition(direction, entity2);
                                break;
                            }
                            updateEnergyScale = true;
                        }
                    }
                    if (!updateEnergyScale || !((double)(laserEnergyScale - (energyScale = this.getEnergyScale(remainingEnergy))) > 0.01)) continue;
                    Pos3D entityPos = from.adjustPosition(direction, entity2);
                    this.sendLaserDataToPlayers(new LaserParticleData(direction, entityPos.distance(from), laserEnergyScale), from);
                    laserEnergyScale = energyScale;
                    from = entityPos;
                }
            }
            this.sendLaserDataToPlayers(new LaserParticleData(direction, to.distance(from), laserEnergyScale), from);
            if (remainingEnergy.isZero() || result.m_6662_() == HitResult.Type.MISS) {
                this.digging = null;
                this.diggingProgress = FloatingLong.ZERO;
            } else {
                Optional capability;
                BlockPos hitPos = result.m_82425_();
                if (!hitPos.equals((Object)this.digging)) {
                    this.digging = result.m_6662_() == HitResult.Type.MISS ? null : hitPos;
                    this.diggingProgress = FloatingLong.ZERO;
                }
                if ((capability = CapabilityUtils.getCapability((ICapabilityProvider)WorldUtils.getTileEntity((BlockGetter)this.f_58857_, hitPos), Capabilities.LASER_RECEPTOR, result.m_82434_()).resolve()).isPresent() && !((ILaserReceptor)capability.get()).canLasersDig()) {
                    ((ILaserReceptor)capability.get()).receiveLaserEnergy(remainingEnergy);
                } else {
                    BlockState hitState = this.f_58857_.m_8055_(hitPos);
                    float hardness = hitState.m_60800_((BlockGetter)this.f_58857_, hitPos);
                    if (hardness >= 0.0f) {
                        this.diggingProgress = this.diggingProgress.plusEqual(remainingEnergy);
                        if (this.diggingProgress.compareTo(((FloatingLong)MekanismConfig.general.laserEnergyNeededPerHardness.get()).multiply(hardness)) >= 0) {
                            if (MekanismConfig.general.aestheticWorldDamage.get()) {
                                MekFakePlayer.withFakePlayer((ServerLevel)this.f_58857_, to.m_7096_(), to.m_7098_(), to.m_7094_(), dummy -> {
                                    dummy.setEmulatingUUID(this.getOwnerUUID());
                                    BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.f_58857_, hitPos, hitState, (Player)dummy);
                                    if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                                        if (hitState.m_60734_() instanceof TntBlock && hitState.isFlammable((BlockGetter)this.f_58857_, hitPos, result.m_82434_())) {
                                            hitState.onCaughtFire(this.f_58857_, hitPos, result.m_82434_(), null);
                                            this.f_58857_.m_7471_(hitPos, false);
                                        } else {
                                            this.handleBreakBlock(hitState, hitPos);
                                            hitState.m_60753_(this.f_58857_, hitPos, Blocks.f_50016_.m_49966_(), false);
                                            this.f_58857_.m_7471_(hitPos, false);
                                            this.f_58857_.m_46796_(2001, hitPos, Block.m_49956_((BlockState)hitState));
                                        }
                                    }
                                    return null;
                                });
                            }
                            this.diggingProgress = FloatingLong.ZERO;
                        } else {
                            Mekanism.packetHandler().sendToAllTracking(new PacketLaserHitBlock(result), this);
                        }
                    }
                }
            }
            this.energyContainer.extract(firing, Action.EXECUTE, AutomationType.INTERNAL);
        } else if (this.getActive()) {
            this.setActive(false);
            if (!this.diggingProgress.isZero()) {
                this.diggingProgress = FloatingLong.ZERO;
            }
            if (!this.lastFired.isZero()) {
                this.lastFired = FloatingLong.ZERO;
                this.sendUpdatePacket();
            }
        }
    }

    private float damageShield(LivingEntity livingEntity, ItemStack activeStack, float damage, int absorptionRatio) {
        float damageBlocked = damage;
        float effectiveDamage = damage / (float)absorptionRatio;
        if (effectiveDamage >= 1.0f) {
            ShieldBlockEvent event = ForgeHooks.onShieldBlock((LivingEntity)livingEntity, (DamageSource)MekanismDamageSource.LASER, (float)effectiveDamage);
            if (event.isCanceled()) {
                return 0.0f;
            }
            if (event.shieldTakesDamage()) {
                int durabilityNeeded = 1 + Mth.m_14143_((float)effectiveDamage);
                int activeDurability = activeStack.m_41776_() - activeStack.m_41773_();
                InteractionHand hand = livingEntity.m_7655_();
                activeStack.m_41622_(durabilityNeeded, livingEntity, entity -> {
                    entity.m_21190_(hand);
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)activeStack, (InteractionHand)hand);
                    }
                });
                if (activeStack.m_41619_()) {
                    if (hand == InteractionHand.MAIN_HAND) {
                        livingEntity.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    } else {
                        livingEntity.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                    }
                    livingEntity.m_5810_();
                    livingEntity.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + 0.4f * this.f_58857_.f_46441_.m_188501_());
                    int unblockedDamage = (durabilityNeeded - activeDurability) * absorptionRatio;
                    damageBlocked = Math.max(0.0f, damage - (float)unblockedDamage);
                }
            }
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (damageBlocked > 0.0f && damageBlocked < 3.4028235E37f) {
                player.m_36222_(Stats.f_12932_, Math.round(damageBlocked * 10.0f));
            }
        }
        return damageBlocked;
    }

    private float getEnergyScale(FloatingLong energy) {
        return Math.min(energy.divide((FloatingLong)MekanismConfig.usage.laser.get()).divide(10L).floatValue(), 0.6f);
    }

    private void sendLaserDataToPlayers(LaserParticleData data, Vec3 from) {
        Object object;
        if (!this.isRemote() && (object = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)object;
            for (ServerPlayer player : serverWorld.m_6907_()) {
                serverWorld.m_8624_(player, (ParticleOptions)data, true, from.f_82479_, from.f_82480_, from.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void setEmittingRedstone(boolean foundEntity) {
    }

    protected boolean handleHitItem(ItemEntity entity) {
        return false;
    }

    protected void handleBreakBlock(BlockState state, BlockPos hitPos) {
        Block.m_49892_((BlockState)state, (LevelAccessor)this.f_58857_, (BlockPos)hitPos, (BlockEntity)WorldUtils.getTileEntity((BlockGetter)this.f_58857_, hitPos));
    }

    protected FloatingLong toFire() {
        return FloatingLong.MAX_VALUE;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        NBTUtils.setFloatingLongIfPresent(nbt, "lastFired", value -> {
            this.lastFired = value;
        });
    }

    @Override
    public void m_183515_(@NotNull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        nbtTags.m_128359_("lastFired", this.lastFired.toString());
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        updateTag.m_128359_("lastFired", this.lastFired.toString());
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setFloatingLongIfPresent(tag, "lastFired", fired -> {
            this.lastFired = fired;
        });
    }

    public LaserEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }
}

