/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.overworld;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.world.feature.config.SimpleBlockProviderConfig;

public class WideLake
extends Feature<SimpleBlockProviderConfig> {
    protected static final Set<Material> unacceptableSolidMaterials = ImmutableSet.of((Object)Material.f_76271_, (Object)Material.f_76270_, (Object)Material.f_76274_, (Object)Material.f_76311_, (Object)Material.f_76277_, (Object)Material.f_76281_, (Object[])new Material[]{Material.f_76285_, Material.f_76287_, Material.f_76286_, Material.f_76282_, Material.f_76287_});
    protected long noiseSeed;
    protected PerlinSimplexNoise noiseGen;

    public void setSeed(long seed) {
        WorldgenRandom sharedseedrandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(seed));
        if (this.noiseSeed != seed || this.noiseGen == null) {
            this.noiseGen = new PerlinSimplexNoise((RandomSource)sharedseedrandom, (List)ImmutableList.of((Object)0));
        }
        this.noiseSeed = seed;
    }

    public WideLake(Codec<SimpleBlockProviderConfig> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<SimpleBlockProviderConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_225041_(), featurePlaceContext.m_159777_(), (SimpleBlockProviderConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator chunkSettings, RandomSource random, BlockPos position, SimpleBlockProviderConfig config) {
        this.setSeed(world.m_7328_());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)position.m_6625_(2));
        for (int x = -2; x < 18; ++x) {
            for (int z = -2; z < 18; ++z) {
                int xTemp = x - 10;
                int zTemp = z - 10;
                if (xTemp * xTemp + zTemp * zTemp >= 64) continue;
                double samplePerlin1 = (this.noiseGen.m_75449_((double)position.m_123341_() + (double)x * 0.05, (double)position.m_123343_() + (double)z * 0.05, true) + 1.0) * 3.0;
                int y = 0;
                while ((double)y > -samplePerlin1) {
                    mutable.m_122190_((Vec3i)position).m_122184_(x, y, z);
                    boolean containedFlag = this.checkIfValidSpot((LevelAccessor)world, mutable, samplePerlin1);
                    if (containedFlag) {
                        BlockState configState = config.getBlockProvider().m_213972_(random, (BlockPos)mutable);
                        world.m_7731_((BlockPos)mutable, configState, 3);
                        if (configState == Blocks.f_49990_.m_49966_()) {
                            world.m_186469_((BlockPos)mutable, (Fluid)Fluids.f_76193_, 0);
                        } else if (configState == Blocks.f_49991_.m_49966_()) {
                            world.m_186469_((BlockPos)mutable, (Fluid)Fluids.f_76195_, 0);
                        }
                        BlockState blockState = world.m_8055_((BlockPos)mutable.m_122173_(Direction.UP));
                        Material material = blockState.m_60767_();
                        if (material == Material.f_76300_ && blockState.m_60734_() != Blocks.f_50196_ && blockState.m_60734_() != BYGBlocks.ENDER_LILY.get() && blockState.m_60734_() != BYGBlocks.TINY_LILYPADS.get()) {
                            world.m_7731_((BlockPos)mutable, Blocks.f_50016_.m_49966_(), 2);
                            while (mutable.m_123342_() < world.m_151558_() && world.m_8055_((BlockPos)mutable.m_122173_(Direction.UP)) == Blocks.f_50130_.m_49966_()) {
                                world.m_7731_((BlockPos)mutable, Blocks.f_50016_.m_49966_(), 2);
                            }
                        }
                        if (material == Material.f_76302_ && blockState.m_60734_() != Blocks.f_50191_) {
                            world.m_7731_((BlockPos)mutable, Blocks.f_50016_.m_49966_(), 2);
                            world.m_7731_(mutable.m_7494_(), Blocks.f_50016_.m_49966_(), 2);
                        }
                    }
                    --y;
                }
            }
        }
        return true;
    }

    private boolean checkIfValidSpot(LevelAccessor world, BlockPos.MutableBlockPos blockpos$Mutable, double noise) {
        BlockPos.MutableBlockPos temp = new BlockPos.MutableBlockPos().m_122190_((Vec3i)blockpos$Mutable);
        BlockState blockState = world.m_8055_(temp.m_7494_());
        while (!blockState.m_60819_().m_76178_() && temp.m_123342_() < world.m_151558_()) {
            temp.m_122173_(Direction.UP);
        }
        if (!blockState.m_60795_() && blockState.m_60819_().m_76178_()) {
            return false;
        }
        blockState = world.m_8055_(blockpos$Mutable.m_7495_());
        Material material = blockState.m_60767_();
        if ((!material.m_76333_() || unacceptableSolidMaterials.contains(material) || blockState.m_204336_(BlockTags.f_13090_)) && blockState.m_60819_().m_76178_() && blockState.m_60819_() != Fluids.f_76193_.m_76068_(false)) {
            return false;
        }
        if (noise < 2.0 && world.m_8055_(blockpos$Mutable.m_7494_()).m_60795_()) {
            int open = 0;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Material material2 = world.m_8055_(blockpos$Mutable.m_121945_(direction)).m_60767_();
                if (unacceptableSolidMaterials.contains(material2)) {
                    return false;
                }
                if (!world.m_8055_(blockpos$Mutable.m_121945_(direction)).m_60795_()) continue;
                ++open;
            }
            if (open == 1) {
                return true;
            }
        }
        for (int x2 = -1; x2 < 2; ++x2) {
            for (int z2 = -1; z2 < 2; ++z2) {
                blockState = world.m_8055_(blockpos$Mutable.m_7918_(x2, 0, z2));
                material = blockState.m_60767_();
                if (material.m_76333_() && !unacceptableSolidMaterials.contains(material) && !blockState.m_204336_(BlockTags.f_13090_) || !blockState.m_60819_().m_76178_() || blockState.m_60819_() == Fluids.f_76193_.m_76068_(false)) continue;
                return false;
            }
        }
        return true;
    }
}

