/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.ChatEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbessentials.command.FTBEssentialsCommands;
import dev.ftb.mods.ftbessentials.command.TPACommands;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import dev.ftb.mods.ftbessentials.util.WarmupCooldownTeleporter;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import java.nio.file.Path;
import java.util.Iterator;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;

public class FTBEEventHandler {
    public static final LevelResource CONFIG_FILE = new LevelResource("serverconfig/ftbessentials.snbt");
    private static final String[] DEFAULT_CONFIG = new String[]{"Default config file that will be copied to world's serverconfig/ftbessentials.snbt location", "Copy values you wish to override in here", "Example:", "", "{", "\tmisc: {", "\t\tenderchest: {", "\t\t\tenabled: false", "\t\t}", "\t}", "}"};

    public static void init() {
        LifecycleEvent.SERVER_BEFORE_START.register(FTBEEventHandler::serverAboutToStart);
        LifecycleEvent.SERVER_STOPPED.register(FTBEEventHandler::serverStopped);
        LifecycleEvent.SERVER_LEVEL_SAVE.register(FTBEEventHandler::levelSave);
        TickEvent.SERVER_POST.register(FTBEEventHandler::serverTickPost);
        TickEvent.PLAYER_POST.register(FTBEEventHandler::playerTickPost);
        CommandRegistrationEvent.EVENT.register(FTBEEventHandler::registerCommands);
        PlayerEvent.PLAYER_JOIN.register(FTBEEventHandler::playerLoggedIn);
        PlayerEvent.PLAYER_QUIT.register(FTBEEventHandler::playerLoggedOut);
        PlayerEvent.PLAYER_CLONE.register(FTBEEventHandler::onPlayerDeath);
        PlayerEvent.CHANGE_DIMENSION.register(FTBEEventHandler::playerChangedDimension);
        EntityEvent.LIVING_HURT.register(FTBEEventHandler::playerHurt);
        ChatEvent.RECEIVED.register(FTBEEventHandler::playerChat);
    }

    private static void serverAboutToStart(MinecraftServer minecraftServer) {
        Path configFilePath = minecraftServer.m_129843_(CONFIG_FILE);
        Path defaultConfigFilePath = Platform.getConfigFolder().resolve("../defaultconfigs/ftbessentials-server.snbt");
        FTBEConfig.CONFIG.load(configFilePath, defaultConfigFilePath, () -> DEFAULT_CONFIG);
        FTBEPlayerData.MAP.clear();
        FTBEWorldData.instance = new FTBEWorldData(minecraftServer);
        FTBEWorldData.instance.load();
    }

    private static void serverStopped(MinecraftServer minecraftServer) {
        FTBEWorldData.instance = null;
        TPACommands.REQUESTS.clear();
    }

    private static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        FTBEssentialsCommands.registerCommands(dispatcher);
    }

    private static void levelSave(ServerLevel serverLevel) {
        if (FTBEWorldData.instance != null) {
            FTBEWorldData.instance.saveNow();
            if (Platform.isFabric()) {
                FTBEPlayerData.MAP.values().forEach(FTBEPlayerData::saveNow);
            }
        }
    }

    private static void playerLoggedIn(ServerPlayer serverPlayer) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)serverPlayer);
        if (data != null) {
            if (Platform.isFabric()) {
                data.load();
            }
            data.lastSeen = new TeleportPos((Entity)serverPlayer);
            data.markDirty();
            for (FTBEPlayerData d : FTBEPlayerData.MAP.values()) {
                d.sendTabName(serverPlayer);
            }
        }
    }

    private static void playerLoggedOut(ServerPlayer serverPlayer) {
        FTBEPlayerData data = FTBEPlayerData.get((Player)serverPlayer);
        if (data != null) {
            data.lastSeen = new TeleportPos((Entity)serverPlayer);
            data.markDirty();
        }
    }

    private static void playerTickPost(Player player) {
        FTBEPlayerData data = FTBEPlayerData.get(player);
        Abilities abilities = player.m_150110_();
        if (data == null) {
            return;
        }
        if (data.god && !abilities.f_35934_) {
            abilities.f_35934_ = true;
            player.m_6885_();
        }
        if (data.fly && !abilities.f_35936_) {
            abilities.f_35936_ = true;
            player.m_6885_();
        }
    }

    private static void serverTickPost(MinecraftServer server) {
        long now = System.currentTimeMillis();
        Iterator<TPACommands.TPARequest> iterator = TPACommands.REQUESTS.values().iterator();
        while (iterator.hasNext()) {
            TPACommands.TPARequest r = iterator.next();
            if (now <= r.created() + 60000L) continue;
            ServerPlayer source = server.m_6846_().m_11259_(r.source().uuid);
            ServerPlayer target = server.m_6846_().m_11259_(r.target().uuid);
            if (source != null) {
                source.m_213846_((Component)Component.m_237113_((String)"TPA request expired!"));
            }
            if (target != null) {
                target.m_213846_((Component)Component.m_237113_((String)"TPA request expired!"));
            }
            iterator.remove();
        }
        if (server.m_129921_() % 20 == 0) {
            WarmupCooldownTeleporter.tickWarmups(server);
            FTBEWorldData.instance.tickMuteTimeouts(server);
        }
    }

    private static EventResult playerChat(@Nullable ServerPlayer serverPlayer, Component component) {
        FTBEPlayerData data;
        if (serverPlayer != null && (data = FTBEPlayerData.get((Player)serverPlayer)) != null && data.muted) {
            serverPlayer.m_5661_((Component)Component.m_237113_((String)"You can't use chat, you've been muted by an admin!").m_130940_(ChatFormatting.RED), false);
            FTBEWorldData.instance.getMuteTimeout(serverPlayer).ifPresent(expiry -> {
                long left = (expiry - System.currentTimeMillis()) / 1000L;
                serverPlayer.m_5661_((Component)Component.m_237113_((String)("Mute expiry in: " + TimeUtils.prettyTimeString((long)left))).m_130940_(ChatFormatting.RED), false);
            });
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static void onPlayerDeath(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean wonGame) {
        if (!wonGame) {
            if (newPlayer.m_6084_()) {
                oldPlayer.m_219759_().ifPresent(loc -> FTBEPlayerData.addTeleportHistory(oldPlayer));
            } else if (oldPlayer.m_6084_()) {
                newPlayer.m_219759_().ifPresent(loc -> FTBEPlayerData.addTeleportHistory(newPlayer));
            }
        }
    }

    private static EventResult playerHurt(LivingEntity livingEntity, DamageSource damageSource, float amount) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)livingEntity;
            if (amount > 0.0f) {
                WarmupCooldownTeleporter.cancelWarmup(sp);
            }
        }
        return EventResult.pass();
    }

    private static void playerChangedDimension(ServerPlayer serverPlayer, ResourceKey<Level> oldDimension, ResourceKey<Level> newDimension) {
        WarmupCooldownTeleporter.cancelWarmup(serverPlayer);
    }
}

