/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.attachment.front;

import io.github.foundationgames.automobility.automobile.attachment.BaseAttachment;
import io.github.foundationgames.automobility.automobile.attachment.FrontAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.rear.RearAttachment;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.util.AUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public abstract class FrontAttachment
extends BaseAttachment<FrontAttachmentType<?>> {
    public FrontAttachment(FrontAttachmentType<?> type, AutomobileEntity automobile) {
        super(type, automobile);
    }

    @Override
    public Vec3 pos() {
        return this.automobile.getHeadPos();
    }

    @Override
    protected void updateTrackedAnimation(float animation) {
        this.automobile.setTrackedFrontAttachmentAnimation(animation);
    }

    public boolean canDrive(Entity entity) {
        return entity instanceof Player;
    }

    @Override
    public void writeNbt(CompoundTag nbt) {
    }

    @Override
    public void readNbt(CompoundTag nbt) {
    }

    public void dropOrTransfer(ItemStack stack, Vec3 dropPos) {
        Container inv;
        RearAttachment rearAtt = this.automobile.getRearAttachment();
        boolean drop = true;
        if (rearAtt instanceof Container && AUtils.transferInto(stack, inv = (Container)rearAtt)) {
            drop = false;
        }
        if (drop) {
            this.world().m_7967_((Entity)new ItemEntity(this.world(), dropPos.f_82479_, dropPos.f_82480_, dropPos.f_82481_, stack));
        }
    }

    public static FrontAttachmentType<?> fromNbt(CompoundTag nbt) {
        return FrontAttachmentType.REGISTRY.get(ResourceLocation.m_135820_((String)nbt.m_128461_("type")));
    }
}

