/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.util.network;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.attachment.front.FrontAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.BannerPostRearAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.ExtendableRearAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.RearAttachment;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.platform.Platform;
import io.netty.buffer.Unpooled;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public final class CommonPackets
extends Enum<CommonPackets> {
    private static final /* synthetic */ CommonPackets[] $VALUES;

    public static CommonPackets[] values() {
        return (CommonPackets[])$VALUES.clone();
    }

    public static CommonPackets valueOf(String name) {
        return Enum.valueOf(CommonPackets.class, name);
    }

    public static void sendSyncAutomobileDataPacket(AutomobileEntity entity, ServerPlayer player) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(entity.m_19879_());
        entity.writeSyncToClientData(buf);
        Platform.get().serverSendPacket(player, Automobility.rl("sync_automobile_data"), buf);
    }

    public static void sendSyncAutomobileComponentsPacket(AutomobileEntity entity, ServerPlayer player) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(entity.m_19879_());
        buf.m_130070_(entity.getFrame().id().toString());
        buf.m_130070_(entity.getWheels().id().toString());
        buf.m_130070_(entity.getEngine().id().toString());
        Platform.get().serverSendPacket(player, Automobility.rl("sync_automobile_components"), buf);
    }

    public static void sendSyncAutomobileAttachmentsPacket(AutomobileEntity entity, ServerPlayer player) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(entity.m_19879_());
        buf.m_130070_(entity.getRearAttachmentType().id().toString());
        buf.m_130070_(entity.getFrontAttachmentType().id().toString());
        Platform.get().serverSendPacket(player, Automobility.rl("sync_automobile_attachments"), buf);
    }

    public static void sendBannerPostAttachmentUpdatePacket(AutomobileEntity entity, CompoundTag banner, ServerPlayer player) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        if (entity.getRearAttachment() instanceof BannerPostRearAttachment) {
            buf.writeInt(entity.m_19879_());
            buf.m_130079_(banner);
            Platform.get().serverSendPacket(player, Automobility.rl("update_banner_post"), buf);
        }
    }

    public static void sendExtendableAttachmentUpdatePacket(AutomobileEntity entity, boolean extended, ServerPlayer player) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        if (entity.getRearAttachment() instanceof ExtendableRearAttachment) {
            buf.writeInt(entity.m_19879_());
            buf.writeBoolean(extended);
            Platform.get().serverSendPacket(player, Automobility.rl("update_extendable_attachment"), buf);
        }
    }

    public static void init() {
        Platform.get().serverReceivePacket(Automobility.rl("sync_automobile_inputs"), (server, player, buf) -> {
            boolean fwd = buf.readBoolean();
            boolean back = buf.readBoolean();
            boolean left = buf.readBoolean();
            boolean right = buf.readBoolean();
            boolean space = buf.readBoolean();
            int entityId = buf.readInt();
            server.execute(() -> {
                Entity patt3424$temp = player.f_19853_.m_6815_(entityId);
                if (patt3424$temp instanceof AutomobileEntity) {
                    AutomobileEntity automobile = (AutomobileEntity)patt3424$temp;
                    automobile.setInputs(fwd, back, left, right, space);
                    automobile.markDirty();
                }
            });
        });
        Platform.get().serverReceivePacket(Automobility.rl("request_sync_automobile_components"), (server, player, buf) -> {
            int entityId = buf.readInt();
            server.execute(() -> {
                Entity patt3893$temp = player.f_19853_.m_6815_(entityId);
                if (patt3893$temp instanceof AutomobileEntity) {
                    RearAttachment rAtt;
                    AutomobileEntity automobile = (AutomobileEntity)patt3893$temp;
                    CommonPackets.sendSyncAutomobileComponentsPacket(automobile, player);
                    CommonPackets.sendSyncAutomobileAttachmentsPacket(automobile, player);
                    FrontAttachment fAtt = automobile.getFrontAttachment();
                    if (fAtt != null) {
                        fAtt.updatePacketRequested((ServerPlayer)player);
                    }
                    if ((rAtt = automobile.getRearAttachment()) != null) {
                        rAtt.updatePacketRequested((ServerPlayer)player);
                    }
                }
            });
        });
    }

    private static /* synthetic */ CommonPackets[] $values() {
        return new CommonPackets[0];
    }

    static {
        $VALUES = CommonPackets.$values();
    }
}

