/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.attributefix.config;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.attributefix.Constants;
import net.darkhax.attributefix.mixin.AccessorRangedAttribute;
import net.darkhax.attributefix.temp.RegistryHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;

public class AttributeConfig {
    @Expose
    private Map<String, Entry> attributes = new HashMap<String, Entry>();

    public void applyChanges(RegistryHelper<Attribute> registry) {
        Constants.LOG.info("Applying changes for {} attributes.", (Object)this.attributes.size());
        for (Map.Entry<String, Entry> configEntry : this.attributes.entrySet()) {
            Attribute attribute;
            ResourceLocation attributeId = ResourceLocation.m_135820_((String)configEntry.getKey());
            if (attributeId == null || !registry.exists(attributeId) || !configEntry.getValue().isEnabled() || !((attribute = registry.get(attributeId)) instanceof RangedAttribute)) continue;
            RangedAttribute ranged = (RangedAttribute)attribute;
            double minValue = configEntry.getValue().min.value;
            double maxValue = configEntry.getValue().max.value;
            if (minValue > maxValue) {
                Constants.LOG.error("Attribute {} was configured to have a minimum value higher than it's maximum. This is not permitted!", (Object)attributeId);
                continue;
            }
            AccessorRangedAttribute accessor = (AccessorRangedAttribute)attribute;
            if (minValue != ranged.m_147361_()) {
                Constants.LOG.debug("Modifying minimum value for {} from {} to {}.", new Object[]{attributeId, Constants.FORMAT.format(ranged.m_147361_()), Constants.FORMAT.format(minValue)});
                accessor.attributefix$setMinValue(minValue);
            }
            if (maxValue == ranged.m_147362_()) continue;
            Constants.LOG.debug("Modifying maximum value for {} from {} to {}.", new Object[]{attributeId, Constants.FORMAT.format(ranged.m_147362_()), Constants.FORMAT.format(maxValue)});
            accessor.attributefix$setMaxValue(maxValue);
        }
    }

    public static AttributeConfig load(File configFile, RegistryHelper<Attribute> registry) {
        AttributeConfig config = new AttributeConfig();
        for (Attribute attribute : registry.getValues()) {
            if (!(attribute instanceof RangedAttribute)) continue;
            RangedAttribute ranged = (RangedAttribute)attribute;
            ResourceLocation id = registry.getId(attribute);
            config.attributes.put(id.toString(), new Entry(id, ranged));
        }
        Constants.LOG.info("Loaded values for {} compatible attributes.", (Object)config.attributes.size());
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                Map<String, Entry> configValues = ((AttributeConfig)Constants.GSON.fromJson((Reader)reader, AttributeConfig.class)).attributes;
                for (Map.Entry<String, Entry> configEntry : configValues.entrySet()) {
                    ResourceLocation attributeId = ResourceLocation.m_135820_((String)configEntry.getKey());
                    if (attributeId == null) {
                        Constants.LOG.error("Attribute ID '{}' is not a valid. This entry will be ignored.", (Object)configEntry.getKey());
                    } else if (!registry.exists(attributeId)) {
                        Constants.LOG.error("Attribute ID '{}' does not belong to a known attribute. This entry will be ignored.", (Object)configEntry.getKey());
                    }
                    if (configEntry.getValue().min.value > configEntry.getValue().max.value) {
                        Constants.LOG.error("Attribute ID '{}' has a max value that is less than its minimum value!", (Object)configEntry.getKey());
                    }
                    config.attributes.put(configEntry.getKey(), configEntry.getValue());
                }
                Constants.LOG.info("Loaded {} values from config.", (Object)configValues.size());
            }
            catch (IOException e) {
                Constants.LOG.error("Could not read config file {}. Defaults will be used.", (Object)configFile.getAbsolutePath());
                Constants.LOG.trace("Failed to read config file.", (Throwable)e);
            }
        } else {
            Constants.LOG.info("Creating a new config file at {}.", (Object)configFile.getAbsolutePath());
            configFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(configFile);){
            Constants.GSON.toJson((Object)config, (Appendable)writer);
            Constants.LOG.info("Saving config file. {} entries.", (Object)config.attributes.size());
        }
        catch (IOException e) {
            Constants.LOG.error("Could not write config file '{}'!", (Object)configFile.getAbsolutePath());
            Constants.LOG.trace("Failed to read config file.", (Throwable)e);
        }
        return config;
    }

    public static class Entry {
        @Expose
        private boolean enabled;
        @Expose
        private DoubleValue min;
        @Expose
        private DoubleValue max;

        public Entry(ResourceLocation id, RangedAttribute attribute) {
            this.enabled = "minecraft".equals(id.m_135827_());
            this.min = new DoubleValue(attribute.m_147361_(), attribute.m_147361_());
            this.max = new DoubleValue(attribute.m_147362_(), 1.0E7);
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class DoubleValue {
        @Expose
        @SerializedName(value="default")
        private double defaultValue;
        @Expose
        private double value;

        public DoubleValue(double defaultValue, double value) {
            this.defaultValue = defaultValue;
            this.value = value;
        }
    }
}

