/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.util;

import com.mojang.math.Vector4f;
import mod.chiselsandbits.api.util.MathUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class VectorUtils {
    public static final double DEG_TO_RAD_FACTOR = Math.PI / 180;
    public static final Vec3 ONE = new Vec3(1.0, 1.0, 1.0);

    private VectorUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: VectorUtils. This is a utility class");
    }

    public static Vec3 rotateMultipleTimes90Degrees(Vec3 vector3d, Direction.Axis axis, int times) {
        return VectorUtils.rotateDegrees(vector3d, axis, times * 90 % 360);
    }

    public static Vec3 rotate90Degrees(Vec3 vector3d, Direction.Axis axis) {
        return VectorUtils.rotateDegrees(vector3d, axis, 90.0);
    }

    public static Vec3 rotateHalfRadian(Vec3 vector3d, Direction.Axis axis) {
        return VectorUtils.rotate(vector3d, axis, 1.5707963267948966);
    }

    public static Vec3 rotateDegrees(Vec3 vector3d, Direction.Axis axis, double angleInDegrees) {
        return VectorUtils.rotate(vector3d, axis, angleInDegrees * (Math.PI / 180));
    }

    public static Vec3 rotate(Vec3 vector3d, Direction.Axis axis, double angleInRadian) {
        switch (axis) {
            case X: {
                return new Vec3(vector3d.m_7096_(), vector3d.m_7098_() * Math.cos((float)angleInRadian) - vector3d.m_7094_() * Math.sin((float)angleInRadian), vector3d.m_7098_() * Math.sin((float)angleInRadian) + vector3d.m_7094_() * Math.cos((float)angleInRadian));
            }
            case Y: {
                return new Vec3(vector3d.m_7096_() * Math.cos((float)angleInRadian) + vector3d.m_7094_() * Math.sin((float)angleInRadian), vector3d.m_7098_(), -vector3d.m_7096_() * Math.sin((float)angleInRadian) + vector3d.m_7094_() * Math.cos((float)angleInRadian));
            }
            case Z: {
                return new Vec3(vector3d.m_7096_() * Math.cos((float)angleInRadian) - vector3d.m_7098_() * Math.sin((float)angleInRadian), vector3d.m_7096_() * Math.sin((float)angleInRadian) + vector3d.m_7098_() * Math.cos((float)angleInRadian), vector3d.m_7094_());
            }
        }
        throw new IllegalArgumentException(String.format("Unknown axis: %s", axis));
    }

    public static Vec3 scaleToOne(Vec3 v) {
        double maxSize = Math.abs(VectorUtils.getMaximalComponent(v));
        if (MathUtil.almostEqual(maxSize, 0)) {
            return Vec3.f_82478_;
        }
        double scale = 1.0 / maxSize;
        return v.m_82490_(scale);
    }

    public static double getMaximalComponent(Vec3 v) {
        double x = Math.abs(v.m_7096_());
        double y = Math.abs(v.m_7098_());
        double z = Math.abs(v.m_7094_());
        if (x >= y && x >= z) {
            return v.m_7096_();
        }
        if (y >= x && y >= z) {
            return v.m_7098_();
        }
        if (z >= x && z >= y) {
            return v.m_7094_();
        }
        return 0.0;
    }

    public static Vec3 invert(Vec3 v) {
        return v.m_82542_(-1.0, -1.0, -1.0);
    }

    public static BlockPos invert(BlockPos v) {
        return new BlockPos(-1 * v.m_123341_(), -1 * v.m_123342_(), -1 * v.m_123343_());
    }

    public static Vec3 minimizeTowardsZero(Vec3 start, Vec3 end) {
        return new Vec3(MathUtil.minimizeTowardsZero(start.m_7096_(), end.m_7096_()), MathUtil.minimizeTowardsZero(start.m_7098_(), end.m_7098_()), MathUtil.minimizeTowardsZero(start.m_7094_(), end.m_7094_()));
    }

    public static Vec3 maximizeAwayFromZero(Vec3 start, Vec3 end) {
        return new Vec3(MathUtil.maximizeAwayFromZero(start.m_7096_(), end.m_7096_()), MathUtil.maximizeAwayFromZero(start.m_7098_(), end.m_7098_()), MathUtil.maximizeAwayFromZero(start.m_7094_(), end.m_7094_()));
    }

    public static Vec3 absolute(Vec3 vector3d) {
        return new Vec3(vector3d.m_7096_() < 0.0 ? -1.0 * vector3d.m_7096_() : vector3d.m_7096_(), vector3d.m_7098_() < 0.0 ? -1.0 * vector3d.m_7098_() : vector3d.m_7098_(), vector3d.m_7094_() < 0.0 ? -1.0 * vector3d.m_7094_() : vector3d.m_7094_());
    }

    public static Vec3 offsetRandomly(Vec3 source, RandomSource random, float radius) {
        return new Vec3(source.f_82479_ + (double)((random.m_188501_() - 0.5f) * 2.0f * radius), source.f_82480_ + (double)((random.m_188501_() - 0.5f) * 2.0f * radius), source.f_82481_ + (double)((random.m_188501_() - 0.5f) * 2.0f * radius));
    }

    public static Vec3 minimize(Vec3 a, Vec3 b) {
        return new Vec3(Math.min(a.m_7096_(), b.m_7096_()), Math.min(a.m_7098_(), b.m_7098_()), Math.min(a.m_7094_(), b.m_7094_()));
    }

    public static Vec3 maximize(Vec3 a, Vec3 b) {
        return new Vec3(Math.max(a.m_7096_(), b.m_7096_()), Math.max(a.m_7098_(), b.m_7098_()), Math.max(a.m_7094_(), b.m_7094_()));
    }

    public static Vec3 makePositive(Vec3 inBlockOffset) {
        return new Vec3(MathUtil.makePositive(inBlockOffset.m_7096_()), MathUtil.makePositive(inBlockOffset.m_7098_()), MathUtil.makePositive(inBlockOffset.m_7094_()));
    }

    public static boolean allValuesBetweenInclusive(Vector4f vector4f, float min, float max) {
        return min <= vector4f.m_123601_() && vector4f.m_123601_() <= max && min <= vector4f.m_123615_() && vector4f.m_123615_() <= max && min <= vector4f.m_123616_() && vector4f.m_123616_() <= max && min <= vector4f.m_123617_() && vector4f.m_123617_() <= max;
    }

    public static Vec3 nullifyNegatives(Vec3 input) {
        return new Vec3(Math.max(0.0, input.m_7096_()), Math.max(0.0, input.m_7098_()), Math.max(0.0, input.m_7094_()));
    }

    public static Vec3 nullifyPositives(Vec3 input) {
        return new Vec3(Math.min(0.0, input.m_7096_()), Math.min(0.0, input.m_7098_()), Math.min(0.0, input.m_7094_()));
    }

    public static Vec3 divide(Vec3 left, Vec3 right) {
        return new Vec3(left.m_7096_() / right.m_7096_(), left.m_7098_() / right.m_7098_(), left.m_7094_() / right.m_7094_());
    }
}

