/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.block.moving_block_shapes;

import com.abdelaziz.canary.common.shapes.OffsetVoxelShapeCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PistonMovingBlockEntity.class})
public abstract class PistonMovingBlockEntityMixin {
    private static final VoxelShape[] PISTON_BASE_WITH_MOVING_HEAD_SHAPES = PistonMovingBlockEntityMixin.precomputePistonBaseWithMovingHeadShapes();
    @Shadow
    private Direction f_60335_;
    @Shadow
    private boolean f_60336_;
    @Shadow
    private boolean f_60337_;
    @Shadow
    private BlockState f_60334_;

    @Inject(method={"getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/Direction;getStepX()I", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void skipVoxelShapeUnion(BlockGetter world, BlockPos pos, CallbackInfoReturnable<VoxelShape> cir, VoxelShape voxelShape, Direction direction, BlockState blockState, float f) {
        if (this.f_60336_ || !this.f_60337_ || !(this.f_60334_.m_60734_() instanceof PistonBaseBlock)) {
            VoxelShape blockShape = blockState.m_60812_(world, pos);
            VoxelShape offsetAndSimplified = PistonMovingBlockEntityMixin.getOffsetAndSimplified(blockShape, Math.abs(f), f < 0.0f ? this.f_60335_.m_122424_() : this.f_60335_);
            cir.setReturnValue((Object)offsetAndSimplified);
        } else {
            int index = PistonMovingBlockEntityMixin.getIndexForMergedShape(f, this.f_60335_);
            cir.setReturnValue((Object)PISTON_BASE_WITH_MOVING_HEAD_SHAPES[index]);
        }
    }

    private static VoxelShape getOffsetAndSimplified(VoxelShape blockShape, float offset, Direction direction) {
        VoxelShape offsetSimplifiedShape = ((OffsetVoxelShapeCache)blockShape).getOffsetSimplifiedShape(offset, direction);
        if (offsetSimplifiedShape == null) {
            offsetSimplifiedShape = blockShape.m_83216_((double)((float)direction.m_122429_() * offset), (double)((float)direction.m_122430_() * offset), (double)((float)direction.m_122431_() * offset)).m_83296_();
            ((OffsetVoxelShapeCache)blockShape).setShape(offset, direction, offsetSimplifiedShape);
        }
        return offsetSimplifiedShape;
    }

    private static VoxelShape[] precomputePistonBaseWithMovingHeadShapes() {
        float[] offsets = new float[]{0.0f, 0.5f, 1.0f};
        Direction[] directions = Direction.values();
        VoxelShape[] mergedShapes = new VoxelShape[offsets.length * directions.length];
        for (Direction direction : directions) {
            VoxelShape baseShape = ((BlockState)((BlockState)Blocks.f_50039_.m_49966_().m_61124_((Property)PistonBaseBlock.f_60153_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)PistonBaseBlock.f_52588_, (Comparable)direction)).m_60812_(null, null);
            for (float offset : offsets) {
                boolean isShort = offset < 0.25f;
                VoxelShape headShape = ((BlockState)((BlockState)Blocks.f_50040_.m_49966_().m_61124_((Property)PistonHeadBlock.f_52588_, (Comparable)direction)).m_61124_((Property)PistonHeadBlock.f_60236_, (Comparable)Boolean.valueOf(isShort))).m_60812_(null, null);
                VoxelShape offsetHead = headShape.m_83216_((double)((float)direction.m_122429_() * offset), (double)((float)direction.m_122430_() * offset), (double)((float)direction.m_122431_() * offset));
                mergedShapes[PistonMovingBlockEntityMixin.getIndexForMergedShape((float)offset, (Direction)direction)] = Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)offsetHead);
            }
        }
        return mergedShapes;
    }

    private static int getIndexForMergedShape(float offset, Direction direction) {
        if (offset != 0.0f && offset != 0.5f && offset != 1.0f) {
            return -1;
        }
        return (int)(2.0f * offset) + 3 * direction.m_122411_();
    }
}

