/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.data;

import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.core.util.Triple;
import com.supermartijn642.rechiseled.api.ConnectingBlockModelProvider;
import com.supermartijn642.rechiseled.api.ConnectingModelBuilder;
import com.supermartijn642.rechiseled.block.BlockSpecification;
import com.supermartijn642.rechiseled.texture.TextureType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class RechiseledConnectingBlockModelProvider
extends ConnectingBlockModelProvider {
    public static final Set<ResourceLocation> TEXTURES = new HashSet<ResourceLocation>();
    private static final List<Triple<Supplier<Block>, BlockSpecification, Pair<TextureType, ResourceLocation>>> BLOCKS = new ArrayList<Triple<Supplier<Block>, BlockSpecification, Pair<TextureType, ResourceLocation>>>();

    public static void addBlock(Supplier<Block> blockSupplier, BlockSpecification specification, TextureType textureType, ResourceLocation texture) {
        BLOCKS.add((Triple<Supplier<Block>, BlockSpecification, Pair<TextureType, ResourceLocation>>)Triple.of(blockSupplier, (Object)((Object)specification), (Object)Pair.of((Object)((Object)textureType), (Object)texture)));
    }

    public RechiseledConnectingBlockModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super("rechiseled", generator, existingFileHelper);
    }

    @Override
    protected void createModels() {
        for (Triple<Supplier<Block>, BlockSpecification, Pair<TextureType, ResourceLocation>> entry : BLOCKS) {
            Block block = (Block)((Supplier)entry.left()).get();
            String namespace = Registries.BLOCKS.getIdentifier((Object)block).m_135827_();
            String identifier = Registries.BLOCKS.getIdentifier((Object)block).m_135815_();
            BlockSpecification specification = (BlockSpecification)((Object)entry.middle());
            TextureType textureType = (TextureType)((Object)((Pair)entry.right()).left());
            ResourceLocation texture = (ResourceLocation)((Pair)entry.right()).right();
            String textureNamespace = texture.m_135827_();
            String texturePath = texture.m_135815_();
            if (specification == BlockSpecification.BASIC) {
                this.cubeAll(namespace, "block/" + identifier, texture, textureType).connectToOtherBlocks(textureType == TextureType.CONNECTING);
            }
            if (specification == BlockSpecification.PILLAR) {
                ConnectingModelBuilder builder = (ConnectingModelBuilder)this.getBuilder(namespace + ":" + identifier);
                builder.parent((ModelFile)this.getExistingFile(new ResourceLocation("minecraft", "block/cube")));
                builder.connectToOtherBlocks(textureType == TextureType.CONNECTING);
                RechiseledConnectingBlockModelProvider.texture(builder, "up", textureNamespace, texturePath + "_top", textureType);
                RechiseledConnectingBlockModelProvider.texture(builder, "down", textureNamespace, texturePath + "_top", textureType);
                RechiseledConnectingBlockModelProvider.texture(builder, "north", texture, textureType);
                RechiseledConnectingBlockModelProvider.texture(builder, "east", texture, textureType);
                RechiseledConnectingBlockModelProvider.texture(builder, "south", texture, textureType);
                RechiseledConnectingBlockModelProvider.texture(builder, "west", texture, textureType);
            }
            this.withExistingParent(namespace + ":item/" + identifier, namespace + ":block/" + identifier);
        }
    }

    public ConnectingModelBuilder cubeAll(String namespace, String location, ResourceLocation texture, TextureType textureType) {
        ConnectingModelBuilder builder = (ConnectingModelBuilder)this.getBuilder(namespace + ":" + location);
        builder.parent((ModelFile)this.getExistingFile(new ResourceLocation("minecraft", "block/cube_all")));
        RechiseledConnectingBlockModelProvider.texture(builder, "all", texture, textureType);
        return builder;
    }

    private static void texture(ConnectingModelBuilder builder, String key, ResourceLocation texture, TextureType textureType) {
        TEXTURES.add(texture);
        if (textureType == TextureType.REGULAR) {
            builder.texture(key, texture);
        } else {
            builder.texture(key, texture, true);
        }
    }

    private static void texture(ConnectingModelBuilder builder, String key, String namespace, String location, TextureType textureType) {
        RechiseledConnectingBlockModelProvider.texture(builder, key, new ResourceLocation(namespace, location), textureType);
    }
}

