/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.bearing;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.bearing.IBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.BackHalfShaftInstance;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BearingInstance<B extends KineticBlockEntity>
extends BackHalfShaftInstance<B>
implements DynamicInstance {
    final OrientedData topInstance;
    final Vector3f rotationAxis;
    final Quaternion blockOrientation;

    public BearingInstance(MaterialManager materialManager, B blockEntity) {
        super(materialManager, blockEntity);
        Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        this.rotationAxis = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.axis).m_122432_();
        this.blockOrientation = BearingInstance.getBlockStateOrientation(facing);
        PartialModel top = ((IBearingBlockEntity)blockEntity).isWoodenTop() ? AllPartialModels.BEARING_TOP_WOODEN : AllPartialModels.BEARING_TOP;
        this.topInstance = (OrientedData)this.getOrientedMaterial().getModel(top, this.blockState).createInstance();
        this.topInstance.setPosition(this.getInstancePosition()).setRotation(this.blockOrientation);
    }

    public void beginFrame() {
        float interpolatedAngle = ((IBearingBlockEntity)((Object)((KineticBlockEntity)this.blockEntity))).getInterpolatedAngle(AnimationTickHolder.getPartialTicks() - 1.0f);
        Quaternion rot = this.rotationAxis.m_122240_(interpolatedAngle);
        rot.m_80148_(this.blockOrientation);
        this.topInstance.setRotation(rot);
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.topInstance});
    }

    @Override
    public void remove() {
        super.remove();
        this.topInstance.delete();
    }

    static Quaternion getBlockStateOrientation(Direction facing) {
        Quaternion orientation = facing.m_122434_().m_122479_() ? Vector3f.f_122225_.m_122240_(AngleHelper.horizontalAngle(facing.m_122424_())) : Quaternion.f_80118_.m_80161_();
        orientation.m_80148_(Vector3f.f_122223_.m_122240_(-90.0f - AngleHelper.verticalAngle(facing)));
        return orientation;
    }
}

