/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.block;

import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.handler.CreativeTabHandler;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;

public class QuarkVineBlock
extends VineBlock
implements IQuarkBlock {
    private final QuarkModule module;
    private BooleanSupplier enabledSupplier = () -> true;

    public QuarkVineBlock(QuarkModule module, String name, boolean creative) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76302_).m_60910_().m_60977_().m_60978_(0.2f).m_60918_(SoundType.f_56740_));
        this.module = module;
        RegistryHelper.registerBlock((Block)this, (String)name);
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
        if (creative) {
            CreativeTabHandler.addTab(this, CreativeModeTab.f_40750_);
        }
    }

    public void m_213898_(@Nonnull BlockState state, @Nonnull ServerLevel worldIn, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        this.m_213897_(state, worldIn, pos, random);
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return true;
    }

    @Override
    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 300;
    }

    public void m_49811_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_49811_(group, items);
        }
    }

    @Override
    @Nullable
    public QuarkModule getModule() {
        return this.module;
    }

    @Override
    public QuarkVineBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }
}

