/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.ClientTicker;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.QuarkGenericTrigger;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.AbstractConfigType;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.content.tools.item.PathfindersQuillItem;
import vazkii.quark.content.tools.loot.InBiomeCondition;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class PathfinderMapsModule
extends QuarkModule {
    public static final String TAG_IS_PATHFINDER = "quark:is_pathfinder";
    private static final String TAG_CHECKED_FOR_PATHFINDER = "quark:checked_pathfinder";
    private static final Object mutex = new Object();
    public static List<TradeInfo> builtinTrades = new LinkedList<TradeInfo>();
    public static List<TradeInfo> customTrades = new LinkedList<TradeInfo>();
    public static List<TradeInfo> tradeList = new LinkedList<TradeInfo>();
    @Config(description="In this section you can add custom Pathfinder Maps. This works for both vanilla and modded biomes.\nEach custom map must be on its own line.\nThe format for a custom map is as follows:\n<id>,<level>,<min_price>,<max_price>,<color>,<name>\n\nWith the following descriptions:\n - <id> being the biome's ID NAME. You can find vanilla names here - https://minecraft.gamepedia.com/Biome#Biome_IDs\n - <level> being the Cartographer villager level required for the map to be unlockable\n - <min_price> being the cheapest (in Emeralds) the map can be\n - <max_price> being the most expensive (in Emeralds) the map can be\n - <color> being a hex color (without the #) for the map to display. You can generate one here - https://htmlcolorcodes.com/\n\nHere's an example of a map to locate Ice Mountains:\nminecraft:ice_mountains,2,8,14,7FE4FF")
    private List<String> customs = new LinkedList<String>();
    public static LootItemFunctionType pathfinderMapType;
    public static LootItemConditionType inBiomeConditionType;
    public static QuarkGenericTrigger pathfinderMapTrigger;
    @Hint
    public static Item pathfinders_quill;
    @Config(description="Set to false to make it so the default quark Pathfinder Map Built-In don't get added, and only the custom ones do")
    public static boolean applyDefaultTrades;
    @Config(description="How many steps in the search should the Pathfinder's Quill do per tick? The higher this value, the faster it'll find a result, but the higher chance it'll lag the game while doing so")
    public static int pathfindersQuillSpeed;
    @Config(description="Experimental. Determines if quills should be multithreaded instead. Will ignore quill speed. This could drastically improve performance as it execute the logic off the main thread ideally causing no lag at all")
    public static boolean multiThreaded;
    @Config
    public static int searchRadius;
    @Config
    public static int xpFromTrade;
    @Config
    public static boolean addToCartographer;
    @Config
    public static boolean addToWanderingTraderForced;
    @Config
    public static boolean addToWanderingTraderGeneric;
    @Config
    public static boolean addToWanderingTraderRare;
    @Config
    public static boolean drawHud;
    @Config
    public static boolean hudOnTop;

    @Override
    public void register() {
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_186761_, true, 4, 8, 14, 8381695);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_186765_, true, 4, 8, 14, 0x8A8A8A);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48151_, true, 4, 8, 14, 22794);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48203_, true, 4, 8, 14, 13416782);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48157_, true, 4, 8, 14, 10200418);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48207_, true, 4, 12, 18, 2242319);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_186763_, true, 4, 12, 18, 5980703);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48179_, true, 5, 12, 18, 13518562);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48222_, true, 5, 16, 22, 2274816);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48197_, true, 5, 16, 22, 4055575);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48159_, true, 5, 16, 22, 13008674);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48215_, true, 5, 20, 26, 5063283);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48182_, true, 5, 20, 26, 2015433);
        inBiomeConditionType = new LootItemConditionType((Serializer)new InBiomeCondition.InBiomeSerializer());
        Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)new ResourceLocation("quark", "in_biome"), (Object)inBiomeConditionType);
        pathfinderMapTrigger = QuarkAdvancementHandler.registerGenericTrigger("pathfinder_map_center");
        pathfinders_quill = new PathfindersQuillItem(this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        this.enqueue(() -> ItemProperties.register((Item)pathfinders_quill, (ResourceLocation)new ResourceLocation("has_biome"), (stack, world, entity, i) -> PathfindersQuillItem.getTargetBiome(stack) != null ? 1.0f : 0.0f));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void drawHUD(RenderGuiOverlayEvent.Post event) {
        if (drawHud && event.getOverlay() == VanillaGuiOverlay.HOTBAR.type()) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91080_ != null) {
                return;
            }
            ItemStack quill = PathfindersQuillItem.getActiveQuill((Player)mc.f_91074_);
            if (quill != null) {
                Window window = event.getWindow();
                int x = 5;
                int y = hudOnTop ? 20 : window.m_85446_() - 15;
                PoseStack ps = event.getPoseStack();
                mc.f_91062_.m_92763_(ps, (Component)PathfindersQuillItem.getSearchingComponent(), (float)x, (float)y, 0xFFFFFF);
                int qx = x;
                int qy = y - 15;
                float speed = 0.1f;
                float total = ClientTicker.total * speed;
                float offX = (float)(Math.sin(total) + 1.0) * 20.0f;
                float offY = (float)(Math.sin(total * 8.0f) - 1.0);
                if (Math.cos(total) < 0.0) {
                    offY = 0.0f;
                }
                mc.m_91291_().m_115123_(quill, qx += (int)offX, qy += (int)offY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onTradesLoaded(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35588_ && addToCartographer) {
            Object object = mutex;
            synchronized (object) {
                Int2ObjectMap trades = event.getTrades();
                for (TradeInfo info : tradeList) {
                    if (info == null) continue;
                    ((List)trades.get(info.level)).add(new PathfinderQuillTrade(info, true));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onWandererTradesLoaded(WandererTradesEvent event) {
        if (!addToWanderingTraderForced && (addToWanderingTraderGeneric || addToWanderingTraderRare)) {
            Object object = mutex;
            synchronized (object) {
                if (!tradeList.isEmpty()) {
                    List quillTrades = tradeList.stream().map(info -> new PathfinderQuillTrade((TradeInfo)info, false)).collect(Collectors.toList());
                    MultiTrade mt = new MultiTrade(quillTrades);
                    if (addToWanderingTraderGeneric) {
                        event.getGenericTrades().add(mt);
                    }
                    if (addToWanderingTraderRare) {
                        event.getRareTrades().add(mt);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void livingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof WanderingTrader) {
            WanderingTrader wt = (WanderingTrader)livingEntity;
            if (addToWanderingTraderForced && !wt.getPersistentData().m_128471_(TAG_CHECKED_FOR_PATHFINDER)) {
                boolean hasPathfinder = false;
                MerchantOffers offers = wt.m_6616_();
                for (MerchantOffer offer : offers) {
                    if (!offer.m_45368_().m_150930_(pathfinders_quill)) continue;
                    hasPathfinder = true;
                    break;
                }
                if (!hasPathfinder && !tradeList.isEmpty()) {
                    TradeInfo info = tradeList.get(wt.f_19853_.f_46441_.m_188503_(tradeList.size()));
                    PathfinderQuillTrade trade = new PathfinderQuillTrade(info, false);
                    MerchantOffer offer = trade.m_213663_((Entity)wt, wt.f_19853_.f_46441_);
                    offers.add(0, (Object)offer);
                }
                wt.getPersistentData().m_128379_(TAG_CHECKED_FOR_PATHFINDER, true);
            }
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        if (!this.tryCheckCenter(player, InteractionHand.MAIN_HAND)) {
            this.tryCheckCenter(player, InteractionHand.OFF_HAND);
        }
    }

    private boolean tryCheckCenter(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42573_ && stack.m_41782_() && ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_IS_PATHFINDER, (boolean)false)) {
            ListTag decorations = stack.m_41783_().m_128437_("Decorations", (int)stack.m_41783_().m_7060_());
            for (int i = 0; i < decorations.size(); ++i) {
                CompoundTag cmp;
                String id;
                Tag tag = decorations.get(i);
                if (!(tag instanceof CompoundTag) || !(id = (cmp = (CompoundTag)tag).m_128461_("id")).equals("+")) continue;
                double x = cmp.m_128459_("x");
                double z = cmp.m_128459_("z");
                Vec3 pp = player.m_20182_();
                double px = pp.f_82479_;
                double pz = pp.f_82481_;
                double distSq = (px - x) * (px - x) + (pz - z) * (pz - z);
                if (!(distSq < 200.0)) continue;
                pathfinderMapTrigger.trigger((ServerPlayer)player);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configChanged() {
        Object object = mutex;
        synchronized (object) {
            tradeList.clear();
            customTrades.clear();
            this.loadCustomMaps(this.customs);
            if (applyDefaultTrades) {
                tradeList.addAll(builtinTrades);
            }
            tradeList.addAll(customTrades);
        }
    }

    private void loadTradeInfo(ResourceKey<Biome> biome, boolean enabled, int level, int minPrice, int maxPrice, int color) {
        builtinTrades.add(new TradeInfo(biome.m_135782_(), enabled, level, minPrice, maxPrice, color));
    }

    private void loadCustomTradeInfo(ResourceLocation biome, boolean enabled, int level, int minPrice, int maxPrice, int color) {
        customTrades.add(new TradeInfo(biome, enabled, level, minPrice, maxPrice, color));
    }

    private void loadCustomTradeInfo(String line) throws IllegalArgumentException {
        String[] tokens = line.split(",");
        if (tokens.length != 5 && tokens.length != 6) {
            throw new IllegalArgumentException("Wrong number of parameters " + tokens.length + " (expected 5)");
        }
        ResourceLocation biomeName = new ResourceLocation(tokens[0]);
        int level = Integer.parseInt(tokens[1]);
        int minPrice = Integer.parseInt(tokens[2]);
        int maxPrice = Integer.parseInt(tokens[3]);
        int color = Integer.parseInt(tokens[4], 16);
        this.loadCustomTradeInfo(biomeName, true, level, minPrice, maxPrice, color);
    }

    private void loadCustomMaps(Iterable<String> lines) {
        for (String s : lines) {
            try {
                this.loadCustomTradeInfo(s);
            }
            catch (IllegalArgumentException e) {
                Quark.LOG.warn("[Custom Pathfinder Maps] Error while reading custom map string \"{}\"", (Object)s);
                Quark.LOG.warn("[Custom Pathfinder Maps] - {}", (Object)e.getMessage());
            }
        }
    }

    static {
        applyDefaultTrades = true;
        pathfindersQuillSpeed = 32;
        multiThreaded = true;
        searchRadius = 6400;
        xpFromTrade = 5;
        addToCartographer = true;
        addToWanderingTraderForced = true;
        addToWanderingTraderGeneric = false;
        addToWanderingTraderRare = false;
        drawHud = true;
        hudOnTop = false;
    }

    public static class TradeInfo
    extends AbstractConfigType
    implements Predicate<Holder<Biome>> {
        public final ResourceLocation biome;
        public final int color;
        @Config
        public boolean enabled;
        @Config
        public final int level;
        @Config
        public final int minPrice;
        @Config
        public final int maxPrice;

        TradeInfo(ResourceLocation biome, boolean enabled, int level, int minPrice, int maxPrice, int color) {
            this.biome = biome;
            this.enabled = enabled;
            this.level = level;
            this.minPrice = minPrice;
            this.maxPrice = maxPrice;
            this.color = color;
        }

        @Override
        public boolean test(Holder<Biome> biomeHolder) {
            return biomeHolder.m_203373_(this.biome);
        }
    }

    private record PathfinderQuillTrade(TradeInfo info, boolean hasCompass) implements VillagerTrades.ItemListing
    {
        public MerchantOffer m_213663_(@Nonnull Entity entity, @Nonnull RandomSource random) {
            if (!this.info.enabled) {
                return null;
            }
            int i = random.m_188503_(this.info.maxPrice - this.info.minPrice + 1) + this.info.minPrice;
            ItemStack itemstack = PathfindersQuillItem.forBiome(this.info.biome.toString(), this.info.color);
            if (itemstack.m_41619_()) {
                return null;
            }
            int xp = xpFromTrade * Math.max(1, this.info.level - 1);
            if (this.hasCompass) {
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, i), new ItemStack((ItemLike)Items.f_42522_), itemstack, 12, xp, 0.2f);
            }
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, i), itemstack, 12, xp, 0.2f);
        }
    }

    private record MultiTrade(List<? extends VillagerTrades.ItemListing> parents) implements VillagerTrades.ItemListing
    {
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            int idx = random.m_188503_(this.parents.size());
            return this.parents.get(idx).m_213663_(entity, random);
        }
    }
}

