/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.api.block.BOPFluids;
import biomesoplenty.common.block.BloodFluid;
import biomesoplenty.core.BiomesOPlenty;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class ModFluids {
    public static void setup() {
        ModFluids.registerFluids();
    }

    public static void registerFluids() {
        BOPFluids.FLOWING_BLOOD = ModFluids.registerFluid(() -> new BloodFluid.Flowing(), "flowing_blood");
        BOPFluids.BLOOD = ModFluids.registerFluid(() -> new BloodFluid.Source(), "blood");
        BOPFluids.BLOOD_TYPE = ModFluids.registerFluidType(() -> new FluidType(FluidType.Properties.create().descriptionId("block.biomesoplenty.blood").fallDistanceModifier(0.0f).canExtinguish(true).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_).density(3000).viscosity(6000)){

            @Nullable
            public BlockPathTypes getBlockPathType(FluidState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, boolean canFluidLog) {
                return canFluidLog ? super.getBlockPathType(state, level, pos, mob, true) : null;
            }

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){
                    private static final ResourceLocation UNDERWATER_LOCATION = new ResourceLocation("textures/misc/underwater.png");
                    private static final ResourceLocation BLOOD_STILL = new ResourceLocation("biomesoplenty:block/blood_still");
                    private static final ResourceLocation BLOOD_FLOW = new ResourceLocation("biomesoplenty:block/blood_flow");

                    public ResourceLocation getStillTexture() {
                        return BLOOD_STILL;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return BLOOD_FLOW;
                    }
                });
            }
        }, "blood");
    }

    public static RegistryObject<Fluid> registerFluid(Supplier<Fluid> fluidSupplier, String name) {
        return BiomesOPlenty.FLUID_REGISTER.register(name, fluidSupplier);
    }

    public static RegistryObject<FluidType> registerFluidType(Supplier<FluidType> fluidSupplier, String name) {
        return BiomesOPlenty.FORGE_FLUID_REGISTER.register(name, fluidSupplier);
    }
}

