/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client.gui.biomepedia.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import potionstudios.byg.client.gui.biomepedia.screen.AbstractBiomepediaScreen;
import potionstudios.byg.client.gui.biomepedia.screen.BlockItemAboutScreen;
import potionstudios.byg.client.gui.biomepedia.widget.ItemWidget;
import potionstudios.byg.common.item.BYGItems;

public class BiomepediaItemsViewScreen
extends AbstractBiomepediaScreen {
    int page;
    int maxPagePairCount;
    ItemWidget[][][][] items;
    private final Screen parent;

    protected BiomepediaItemsViewScreen(Screen parent) {
        super((Component)Component.m_237113_((String)""));
        this.parent = parent;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.createMenu();
        this.load(this.page);
        PageButton pageBack = new PageButton(this.leftPos + 5, this.topPos - 10, false, button -> {
            this.unload(this.page);
            this.page = this.page == 0 ? this.maxPagePairCount - 1 : (this.page - 1) % this.maxPagePairCount;
            this.load(this.page);
        }, true);
        this.m_142416_((GuiEventListener)pageBack);
        pageBack.f_93620_ = this.leftPos + 15;
        pageBack.f_93621_ = this.topPos - pageBack.m_93694_() - 13;
        PageButton pageForward = new PageButton(this.rightPos - 5, this.topPos - 10, true, button -> {
            this.unload(this.page);
            this.page = (this.page + 1) % this.maxPagePairCount;
            this.load(this.page);
        }, true);
        this.m_142416_((GuiEventListener)pageForward);
        pageForward.f_93620_ = this.rightPos - pageBack.m_5711_() - 22;
        pageForward.f_93621_ = this.topPos - pageBack.m_93694_() - 13;
    }

    private void createMenu() {
        this.createMenu((Supplier[])BYGItems.PROVIDER.getEntries().stream().sorted(Comparator.comparing(itemRegistryObject -> itemRegistryObject.getResourceKey().m_135782_().toString())).toArray(Supplier[]::new), 7, 10);
    }

    private void createMenu(Supplier<? extends Item>[] bygItems, int rowLength, int columnLength) {
        this.maxPagePairCount = bygItems.length / (rowLength * columnLength) / 2 + 1;
        this.items = new ItemWidget[this.maxPagePairCount][2][columnLength][rowLength];
        int registryIdx = 0;
        int width = 17;
        int buttonSize = width - 2;
        int offsetFromEdge = 13;
        for (ItemWidget[][][] pagePair : this.items) {
            for (int pageSide = 0; pageSide < pagePair.length; ++pageSide) {
                ItemWidget[][] page = pagePair[pageSide];
                int yOffset = this.bottomPos + offsetFromEdge;
                for (ItemWidget[] row : page) {
                    int xOffset = this.leftPos + offsetFromEdge + 4;
                    for (int columnIdx = 0; columnIdx < row.length; ++columnIdx) {
                        int startX = 136 * pageSide;
                        if (registryIdx > bygItems.length - 1) break;
                        ItemWidget itemWidget = new ItemWidget(bygItems[registryIdx].get().m_7968_(), this.f_96542_, xOffset + startX, yOffset, buttonSize, buttonSize, button -> {
                            Item item = button.stack.m_41720_();
                            if (button.hasAdditonalInfo && item instanceof BlockItem) {
                                BlockItem blockItem = (BlockItem)item;
                                this.f_96541_.m_91152_((Screen)new BlockItemAboutScreen(this, blockItem));
                            }
                        });
                        row[columnIdx] = (ItemWidget)this.m_142416_((GuiEventListener)itemWidget);
                        ++registryIdx;
                        xOffset += width;
                    }
                    yOffset += width;
                }
            }
        }
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        BiomepediaItemsViewScreen.forEach(this.items, itemWidget -> {
            if (itemWidget.m_5953_(mouseX, mouseY)) {
                List tooltipLines = itemWidget.stack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(this.f_96541_.f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
                if (itemWidget.hasAdditonalInfo) {
                    tooltipLines.add(1, Component.m_237113_((String)"Click for more info"));
                }
                this.m_169388_(poseStack, tooltipLines, itemWidget.stack.m_150921_(), mouseX, mouseY);
            }
        });
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    private static void forEach(ItemWidget[][][][] widgets, Consumer<ItemWidget> widget) {
        ItemWidget[][][][] itemWidgetArray = widgets;
        int n = itemWidgetArray.length;
        for (int i = 0; i < n; ++i) {
            ItemWidget[][][] itemWidgetsPage;
            ItemWidget[][][] itemWidgetArray2 = itemWidgetsPage = itemWidgetArray[i];
            int n2 = itemWidgetArray2.length;
            for (int j = 0; j < n2; ++j) {
                ItemWidget[][] itemWidgetsLeftRight;
                ItemWidget[][] itemWidgetArray3 = itemWidgetsLeftRight = itemWidgetArray2[j];
                int n3 = itemWidgetArray3.length;
                for (int k = 0; k < n3; ++k) {
                    ItemWidget[] itemWidgets;
                    for (ItemWidget itemWidget : itemWidgets = itemWidgetArray3[k]) {
                        if (itemWidget == null) continue;
                        widget.accept(itemWidget);
                    }
                }
            }
        }
    }

    private void unload(int page) {
        ItemWidget[][][] renderableItem;
        ItemWidget[][][] itemWidgetArray = renderableItem = this.items[page];
        int n = itemWidgetArray.length;
        for (int i = 0; i < n; ++i) {
            ItemWidget[][] itemWidgetsByPage;
            ItemWidget[][] itemWidgetArray2 = itemWidgetsByPage = itemWidgetArray[i];
            int n2 = itemWidgetArray2.length;
            for (int j = 0; j < n2; ++j) {
                ItemWidget[] itemWidgets;
                for (ItemWidget itemWidget : itemWidgets = itemWidgetArray2[j]) {
                    if (itemWidget == null) continue;
                    itemWidget.f_93624_ = false;
                    itemWidget.f_93623_ = false;
                }
            }
        }
    }

    private void load(int page) {
        ItemWidget[][][] renderableItem;
        ItemWidget[][][] itemWidgetArray = renderableItem = this.items[page];
        int n = itemWidgetArray.length;
        for (int i = 0; i < n; ++i) {
            ItemWidget[][] itemWidgetsByPage;
            ItemWidget[][] itemWidgetArray2 = itemWidgetsByPage = itemWidgetArray[i];
            int n2 = itemWidgetArray2.length;
            for (int j = 0; j < n2; ++j) {
                ItemWidget[] itemWidgets;
                for (ItemWidget itemWidget : itemWidgets = itemWidgetArray2[j]) {
                    if (itemWidget == null) continue;
                    itemWidget.f_93624_ = true;
                    itemWidget.f_93623_ = true;
                }
            }
        }
    }
}

