/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.nether.quartzdesert;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Material;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.world.feature.config.QuartzSpikeConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class QuartzSpikeFeature
extends Feature<QuartzSpikeConfig> {
    private static final BlockStatePredicate IS_QUARTZ_SAND = BlockStatePredicate.m_61287_((Block)((Block)BYGBlocks.QUARTZITE_SAND.get()));
    FastNoise noise = null;

    public QuartzSpikeFeature(Codec<QuartzSpikeConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<QuartzSpikeConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_225041_(), featurePlaceContext.m_159777_(), (QuartzSpikeConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator generator, RandomSource rand, BlockPos pos, QuartzSpikeConfig config) {
        this.setSeed(world.m_7328_());
        if (world.m_8055_(pos.m_7495_()).m_60767_() == Material.f_76296_ || world.m_8055_(pos.m_7495_()) != BYGBlocks.QUARTZITE_SAND.defaultBlockState() || world.m_8055_(pos.m_7495_()).m_60767_() == Material.f_76307_ || world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_()) < 4) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        double baseRadius = 1.0;
        int height = 10;
        int startHeight = height - 3;
        for (double y = (double)(-height); y <= -1.0; y += 1.0) {
            for (double x = (double)(-height); x <= (double)height; x += 1.0) {
                for (double z = (double)(-height); z <= (double)height; z += 1.0) {
                    mutable.m_122190_((Vec3i)pos).m_122184_((int)x, (int)y + startHeight, (int)z);
                    double noise = this.noise.GetNoise(mutable.m_123341_(), mutable.m_123343_()) * 12.0f;
                    double scaledNoise = noise / 11.0 * (-(y * baseRadius) / (x * x + z * z));
                    double threshold = 0.5;
                    if (y == (double)(-height) && scaledNoise >= threshold && world.m_8055_(mutable.m_121945_(Direction.DOWN)).m_60767_() == Material.f_76296_) {
                        return false;
                    }
                    if (!(scaledNoise >= threshold) || world.m_8055_((BlockPos)mutable).m_60767_() != Material.f_76296_) continue;
                    BlockState blockState = config.getBlockProvider().m_213972_(rand, (BlockPos)mutable);
                    world.m_7731_((BlockPos)mutable, blockState, 2);
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.noise == null) {
            this.noise = new FastNoise((int)seed);
            this.noise.SetNoiseType(FastNoise.NoiseType.PerlinFractal);
            this.noise.SetFractalType(FastNoise.FractalType.FBM);
            this.noise.SetFrequency(0.2f);
        }
    }
}

