/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.hint.Hint;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class HoeHarvestingModule
extends QuarkModule {
    @Hint(key="hoe_harvesting")
    TagKey<Item> hoes = Tags.Items.TOOLS_HOES;
    public static TagKey<Item> bigHarvestingHoesTag;

    public static int getRange(ItemStack hoe) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(HoeHarvestingModule.class)) {
            return 1;
        }
        if (!HoeHarvestingModule.isHoe(hoe)) {
            return 1;
        }
        if (hoe.m_204117_(bigHarvestingHoesTag)) {
            return 3;
        }
        return 2;
    }

    public static boolean isHoe(ItemStack itemStack) {
        return !itemStack.m_41619_() && (itemStack.m_41720_() instanceof HoeItem || itemStack.m_204117_(Tags.Items.TOOLS_HOES) || itemStack.m_41720_().canPerformAction(itemStack, ToolActions.HOE_DIG));
    }

    @Override
    public void setup() {
        bigHarvestingHoesTag = ItemTags.create((ResourceLocation)new ResourceLocation("quark", "big_harvesting_hoes"));
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        LevelAccessor world = event.getLevel();
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        Player player = event.getPlayer();
        BlockPos basePos = event.getPos();
        ItemStack stack = player.m_21205_();
        if (HoeHarvestingModule.isHoe(stack) && this.canHarvest(player, world, basePos, event.getState())) {
            boolean brokeNonInstant = false;
            int range = HoeHarvestingModule.getRange(stack);
            for (int i = 1 - range; i < range; ++i) {
                for (int k = 1 - range; k < range; ++k) {
                    BlockState state;
                    BlockPos pos;
                    if (i == 0 && k == 0 || !this.canHarvest(player, world, pos = basePos.m_7918_(i, 0, k), state = world.m_8055_(pos))) continue;
                    Block block = state.m_60734_();
                    if (state.m_60800_((BlockGetter)world, pos) != 0.0f) {
                        brokeNonInstant = true;
                    }
                    if (block.canHarvestBlock(state, (BlockGetter)world, pos, player)) {
                        block.m_6240_(level, player, pos, state, world.m_7702_(pos), stack);
                    }
                    world.m_46961_(pos, false);
                    world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                }
            }
            if (brokeNonInstant) {
                MiscUtil.damageStack(player, InteractionHand.MAIN_HAND, stack, 1);
            }
        }
    }

    private boolean canHarvest(Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof IPlantable) {
            IPlantable plant = (IPlantable)block;
            PlantType type = plant.getPlantType((BlockGetter)world, pos);
            return type != PlantType.WATER && type != PlantType.DESERT;
        }
        Material mat = state.m_60767_();
        boolean isHarvestableMaterial = mat == Material.f_76300_ || mat == Material.f_76303_ || mat == Material.f_76302_ || mat == Material.f_76301_;
        return isHarvestableMaterial && state.m_60629_(new BlockPlaceContext(new UseOnContext(player, InteractionHand.MAIN_HAND, new BlockHitResult(new Vec3(0.5, 0.5, 0.5), Direction.DOWN, pos, false))));
    }
}

