/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.entries;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.config.entries.FilteringRulesScreen;
import me.shedaniel.rei.impl.client.config.entries.FilteringScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FilteringEntry
extends AbstractConfigListEntry<List<EntryStack<?>>> {
    private int width;
    Consumer<List<EntryStack<?>>> saveConsumer;
    Consumer<List<FilteringRule<?>>> rulesSaveConsumer;
    List<EntryStack<?>> defaultValue;
    Set<EntryStack<?>> configFiltered;
    List<FilteringRule<?>> rules;
    boolean edited = false;
    final FilteringScreen filteringScreen = new FilteringScreen(this);
    final FilteringRulesScreen filteringRulesScreen = new FilteringRulesScreen(this);
    private final AbstractWidget buttonWidget = new Button(0, 0, 0, 20, (Component)Component.m_237115_((String)"config.roughlyenoughitems.filteringScreen"), button -> {
        this.filteringRulesScreen.parent = Minecraft.m_91087_().f_91080_;
        Minecraft.m_91087_().m_91152_((Screen)this.filteringRulesScreen);
    });
    private final List<AbstractWidget> children = ImmutableList.of((Object)this.buttonWidget);

    public FilteringEntry(int width, List<EntryStack<?>> configFiltered, List<FilteringRule<?>> rules, List<EntryStack<?>> defaultValue, Consumer<List<EntryStack<?>>> saveConsumer, Consumer<List<FilteringRule<?>>> rulesSaveConsumer) {
        super((Component)Component.m_237119_(), false);
        this.width = width;
        this.configFiltered = new TreeSet<EntryStack>(Comparator.comparing(EntryStacks::hashExact));
        this.configFiltered.addAll(configFiltered);
        this.rules = Lists.newArrayList(rules);
        this.defaultValue = defaultValue;
        this.saveConsumer = saveConsumer;
        this.rulesSaveConsumer = rulesSaveConsumer;
    }

    public List<EntryStack<?>> getValue() {
        return Lists.newArrayList(this.configFiltered);
    }

    public Optional<List<EntryStack<?>>> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    public void save() {
        this.saveConsumer.accept((List<EntryStack<?>>)this.getValue());
        this.rulesSaveConsumer.accept(this.rules);
        this.edited = false;
    }

    public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        Window window = Minecraft.m_91087_().m_91268_();
        this.buttonWidget.f_93623_ = this.isEditable();
        this.buttonWidget.f_93621_ = y;
        this.buttonWidget.f_93620_ = x + entryWidth / 2 - this.width / 2;
        this.buttonWidget.m_93674_(this.width);
        this.buttonWidget.m_6305_(matrices, mouseX, mouseY, delta);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    public List<? extends NarratableEntry> narratables() {
        return this.children;
    }

    public boolean isEdited() {
        return super.isEdited() || this.edited;
    }
}

