/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.filtering.rules;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleType;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.config.entries.FilteringRuleOptionsScreen;
import me.shedaniel.rei.impl.client.entry.filtering.rules.SearchFilteringRule;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public enum SearchFilteringRuleType implements FilteringRuleType<SearchFilteringRule>
{
    INSTANCE;


    @Override
    public CompoundTag saveTo(SearchFilteringRule rule, CompoundTag tag) {
        tag.m_128359_("filter", rule.filterStr);
        tag.m_128379_("show", rule.show);
        return tag;
    }

    @Override
    public SearchFilteringRule readFrom(CompoundTag tag) {
        String filter = tag.m_128461_("filter");
        boolean show = tag.m_128471_("show");
        return new SearchFilteringRule(filter, show);
    }

    @Override
    public SearchFilteringRule createNew() {
        return new SearchFilteringRule("", false);
    }

    @Override
    public Component getTitle(SearchFilteringRule rule) {
        return Component.m_237115_((String)"rule.roughlyenoughitems.filtering.search");
    }

    @Override
    public Component getSubtitle(SearchFilteringRule rule) {
        return Component.m_237115_((String)"rule.roughlyenoughitems.filtering.search.subtitle");
    }

    @Override
    @Nullable
    public Function<Screen, Screen> createEntryScreen(SearchFilteringRule rule) {
        return screen -> new FilteringRuleOptionsScreen<SearchFilteringRule>(rule, screen){
            FilteringRuleOptionsScreen.TextFieldRuleEntry entry;
            FilteringRuleOptionsScreen.BooleanRuleEntry show;
            List<EntryWidget> entryStacks;
            {
                this.entry = null;
                this.show = null;
                this.entryStacks = new ArrayList<EntryWidget>();
            }

            @Override
            public void addEntries(Consumer<FilteringRuleOptionsScreen.RuleEntry> entryConsumer) {
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (FormattedText)Component.m_237115_((String)"rule.roughlyenoughitems.filtering.search.filter").m_130940_(ChatFormatting.GRAY));
                this.entry = new FilteringRuleOptionsScreen.TextFieldRuleEntry(this.f_96543_ - 36, this.rule, widget -> {
                    widget.m_94199_(9999);
                    widget.m_94151_(searchTerm -> {
                        SearchFilter filter = SearchProvider.getInstance().createFilter((String)searchTerm);
                        this.entryStacks = ((Stream)EntryRegistry.getInstance().getEntryStacks().parallel()).filter(filter).map(EntryStack::normalize).map(stack -> new EntryWidget(new Rectangle(0, 0, 18, 18)).noBackground().entry((EntryStack)stack)).collect(Collectors.toList());
                    });
                    if (this.entry != null) {
                        widget.m_94144_(this.entry.getWidget().m_94155_());
                    } else {
                        widget.m_94144_(((SearchFilteringRule)this.rule).filterStr);
                    }
                });
                entryConsumer.accept(this.entry);
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (FormattedText)Component.m_237115_((String)"rule.roughlyenoughitems.filtering.search.show").m_130940_(ChatFormatting.GRAY));
                Function<Boolean, Component> function = bool -> Component.m_237115_((String)("rule.roughlyenoughitems.filtering.search.show." + bool));
                this.show = new FilteringRuleOptionsScreen.BooleanRuleEntry(this.f_96543_ - 36, this.show == null ? ((SearchFilteringRule)this.rule).show : this.show.getBoolean(), this.rule, function);
                entryConsumer.accept(this.show);
                this.addEmpty(entryConsumer, 10);
                entryConsumer.accept(new FilteringRuleOptionsScreen.SubRulesEntry(this.rule, () -> (Component)function.apply(this.show == null ? ((SearchFilteringRule)this.rule).show : this.show.getBoolean()), Collections.singletonList(new EntryStacksRuleEntry(this.rule, () -> this.entryStacks))));
            }

            @Override
            public void save() {
                ((SearchFilteringRule)this.rule).setFilter(this.entry.getWidget().m_94155_());
                ((SearchFilteringRule)this.rule).show = this.show.getBoolean();
            }
        };
    }

    @Override
    public boolean isSingular() {
        return false;
    }

    public static class EntryStacksRuleEntry
    extends FilteringRuleOptionsScreen.RuleEntry {
        private final Supplier<Iterable<EntryWidget>> entryStacks;
        private int totalHeight;

        public EntryStacksRuleEntry(FilteringRule<?> rule, Supplier<Iterable<EntryWidget>> entryStacks) {
            super(rule);
            this.entryStacks = entryStacks;
        }

        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            BatchedEntryRendererManager<EntryWidget> manager = new BatchedEntryRendererManager<EntryWidget>();
            int entrySize = EntryListWidget.entrySize();
            int width = entryWidth / entrySize;
            int i = 0;
            for (EntryWidget stack : this.entryStacks.get()) {
                stack.getBounds().setLocation(x + i % width * entrySize, y + i / width * entrySize);
                if (stack.getBounds().getMaxY() >= 0 && stack.getBounds().getY() <= Minecraft.m_91087_().m_91268_().m_85446_()) {
                    manager.add(stack);
                }
                ++i;
            }
            manager.render(matrices, mouseX, mouseY, delta);
            this.totalHeight = (i / width + 1) * entrySize;
        }

        public int getItemHeight() {
            return this.totalHeight;
        }

        public List<? extends NarratableEntry> narratables() {
            return Lists.newArrayList();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Lists.newArrayList();
        }
    }
}

