/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.gui.config.SearchFieldLocation;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProvider;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitor;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.craftable.CraftableFilter;
import me.shedaniel.rei.impl.client.gui.dragging.CurrentDraggingStack;
import me.shedaniel.rei.impl.client.gui.modules.MenuAccess;
import me.shedaniel.rei.impl.client.gui.modules.MenuHolder;
import me.shedaniel.rei.impl.client.gui.widget.ConfigButtonWidget;
import me.shedaniel.rei.impl.client.gui.widget.CraftableFilterButtonWidget;
import me.shedaniel.rei.impl.client.gui.widget.DefaultDisplayChoosePageWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryHighlighter;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.PaginatedEntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.ScrolledEntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.gui.widget.hint.HintsContainerWidget;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchField;
import me.shedaniel.rei.impl.common.util.RectangleUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ScreenOverlayImpl
extends ScreenOverlay {
    private static final List<Tooltip> TOOLTIPS = Lists.newArrayList();
    private static EntryListWidget entryListWidget = null;
    private static FavoritesListWidget favoritesListWidget = null;
    private final List<Widget> widgets = Lists.newLinkedList();
    public boolean shouldReload = false;
    public boolean shouldReloadSearch = false;
    private Rectangle bounds;
    private Window window;
    private Widget configButton;
    private final CurrentDraggingStack draggingStack = new CurrentDraggingStack();
    @Nullable
    public DefaultDisplayChoosePageWidget choosePageWidget;
    private final MenuHolder menuHolder = new MenuHolder();
    private final HintsContainerWidget hintsWidget = new HintsContainerWidget();

    public static EntryListWidget getEntryListWidget() {
        boolean widgetScrolled = ConfigObject.getInstance().isEntryListWidgetScrolled();
        if (entryListWidget != null) {
            if (widgetScrolled && entryListWidget instanceof ScrolledEntryListWidget) {
                return entryListWidget;
            }
            if (!widgetScrolled && entryListWidget instanceof PaginatedEntryListWidget) {
                return entryListWidget;
            }
        }
        entryListWidget = widgetScrolled ? new ScrolledEntryListWidget() : new PaginatedEntryListWidget();
        ScreenOverlayImpl overlay = ScreenOverlayImpl.getInstance();
        Rectangle overlayBounds = overlay.bounds;
        entryListWidget.updateArea(Objects.requireNonNullElse(overlayBounds, new Rectangle()), REIRuntimeImpl.getSearchField() == null ? "" : REIRuntimeImpl.getSearchField().getText());
        entryListWidget.updateEntriesPosition();
        return entryListWidget;
    }

    @Nullable
    public static FavoritesListWidget getFavoritesListWidget() {
        return favoritesListWidget;
    }

    public static ScreenOverlayImpl getInstance() {
        return (ScreenOverlayImpl)REIRuntime.getInstance().getOverlay().orElseThrow();
    }

    public void tick() {
        if (REIRuntimeImpl.getSearchField() != null) {
            REIRuntimeImpl.getSearchField().tick();
            if (Minecraft.m_91087_().f_91074_ != null && !PluginManager.areAnyReloading() && Minecraft.m_91087_().f_91074_.f_19797_ % 5 == 0) {
                CraftableFilter.INSTANCE.tick();
            }
        }
    }

    @Override
    public void queueReloadOverlay() {
        this.shouldReload = true;
    }

    @Override
    public void queueReloadSearch() {
        this.shouldReloadSearch = true;
    }

    @Override
    public DraggingContext<?> getDraggingContext() {
        return this.draggingStack;
    }

    protected boolean hasSpace() {
        return !this.bounds.isEmpty();
    }

    public void init() {
        this.draggingStack.set(DraggableComponentProvider.from(ScreenRegistry.getInstance()::getDraggableComponentProviders), DraggableComponentVisitor.from(ScreenRegistry.getInstance()::getDraggableComponentVisitors));
        this.shouldReload = false;
        this.shouldReloadSearch = false;
        this.m_6702_().clear();
        this.window = Minecraft.m_91087_().m_91268_();
        this.bounds = ScreenOverlayImpl.calculateOverlayBounds();
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            if (favoritesListWidget == null) {
                favoritesListWidget = new FavoritesListWidget();
            }
            ScreenOverlayImpl.favoritesListWidget.favoritePanel.resetRows();
            this.widgets.add(favoritesListWidget);
        }
        OverlaySearchField searchField = REIRuntimeImpl.getSearchField();
        searchField.getBounds().setBounds(this.getSearchFieldArea());
        this.widgets.add(searchField);
        EntryListWidget entryListWidget = ScreenOverlayImpl.getEntryListWidget();
        entryListWidget.updateArea(this.bounds, searchField.getText());
        this.widgets.add(entryListWidget);
        searchField.setResponder(s -> entryListWidget.updateSearch((String)s, false));
        entryListWidget.init(this);
        this.configButton = ConfigButtonWidget.create(this);
        this.widgets.add(this.configButton);
        if (ConfigObject.getInstance().isCraftableFilterEnabled()) {
            this.widgets.add(CraftableFilterButtonWidget.create(this));
        }
        this.widgets.add(this.draggingStack);
        this.widgets.add(InternalWidgets.wrapLateRenderable(this.hintsWidget));
        this.hintsWidget.init();
    }

    private Rectangle getSearchFieldArea() {
        int widthRemoved = 1;
        if (ConfigObject.getInstance().isCraftableFilterEnabled()) {
            widthRemoved += 22;
        }
        if (ConfigObject.getInstance().isLowerConfigButton()) {
            widthRemoved += 22;
        }
        SearchFieldLocation searchFieldLocation = REIRuntime.getInstance().getContextualSearchFieldLocation();
        return switch (searchFieldLocation) {
            default -> throw new IncompatibleClassChangeError();
            case SearchFieldLocation.TOP_SIDE -> this.getTopSideSearchFieldArea(widthRemoved);
            case SearchFieldLocation.BOTTOM_SIDE -> this.getBottomSideSearchFieldArea(widthRemoved);
            case SearchFieldLocation.CENTER -> this.getCenterSearchFieldArea(widthRemoved);
        };
    }

    private Rectangle getTopSideSearchFieldArea(int widthRemoved) {
        return new Rectangle(this.bounds.x + 2, 4, this.bounds.width - 6 - widthRemoved, 18);
    }

    private Rectangle getBottomSideSearchFieldArea(int widthRemoved) {
        return new Rectangle(this.bounds.x + 2, this.window.m_85446_() - 22, this.bounds.width - 6 - widthRemoved, 18);
    }

    private Rectangle getCenterSearchFieldArea(int widthRemoved) {
        Rectangle screenBounds = ScreenRegistry.getInstance().getScreenBounds(this.minecraft.f_91080_);
        return new Rectangle(screenBounds.x, this.window.m_85446_() - 22, screenBounds.width - widthRemoved, 18);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.shouldReload || !ScreenOverlayImpl.calculateOverlayBounds().equals((Object)this.bounds)) {
            this.init();
            ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
        } else {
            for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(this.minecraft.f_91080_)) {
                if (decider == null || !decider.shouldRecalculateArea(ConfigObject.getInstance().getDisplayPanelLocation(), this.bounds)) continue;
                this.init();
                break;
            }
        }
        if (this.shouldReloadSearch || ConfigManager.getInstance().isCraftableOnlyEnabled() && CraftableFilter.INSTANCE.wasDirty()) {
            this.shouldReloadSearch = false;
            ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
        }
        if (OverlaySearchField.isHighlighting) {
            EntryHighlighter.render(matrices);
        }
        if (!this.hasSpace()) {
            return;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderWidgets(matrices, mouseX, mouseY, delta);
        if (ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            ClickArea.ClickAreaContext<Screen> context = this.createClickAreaContext(mouseX, mouseY, screen);
            List<Component> clickAreaTooltips = ScreenRegistry.getInstance().getClickAreaTooltips(screen.getClass(), context);
            if (clickAreaTooltips != null && !clickAreaTooltips.isEmpty()) {
                Tooltip.create(clickAreaTooltips).queue();
            }
        }
    }

    private ClickArea.ClickAreaContext<Screen> createClickAreaContext(final double mouseX, final double mouseY, final Screen screen) {
        return new ClickArea.ClickAreaContext<Screen>(){

            @Override
            public Screen getScreen() {
                return screen;
            }

            @Override
            public Point getMousePosition() {
                return new Point(mouseX, mouseY);
            }
        };
    }

    private static Rectangle calculateOverlayBounds() {
        Rectangle bounds = ScreenRegistry.getInstance().getOverlayBounds(ConfigObject.getInstance().getDisplayPanelLocation(), Minecraft.m_91087_().f_91080_);
        int widthReduction = (int)Math.round((double)bounds.width * (1.0 - ConfigObject.getInstance().getHorizontalEntriesBoundariesPercentage()));
        if (ConfigObject.getInstance().getDisplayPanelLocation() == DisplayPanelLocation.RIGHT) {
            bounds.x += widthReduction;
        }
        bounds.width -= widthReduction;
        int maxWidth = (int)Math.ceil((double)EntryListWidget.entrySize() * ConfigObject.getInstance().getHorizontalEntriesBoundariesColumns() + (double)EntryListWidget.entrySize() * 0.75);
        if (bounds.width > maxWidth) {
            if (ConfigObject.getInstance().getDisplayPanelLocation() == DisplayPanelLocation.RIGHT) {
                bounds.x += bounds.width - maxWidth;
            }
            bounds.width = maxWidth;
        }
        return ScreenOverlayImpl.avoidButtons(bounds);
    }

    private static Rectangle avoidButtons(Rectangle bounds) {
        int buttonsHeight = 2;
        if (REIRuntime.getInstance().getContextualSearchFieldLocation() == SearchFieldLocation.TOP_SIDE) {
            buttonsHeight += 24;
        }
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            buttonsHeight += 22;
        }
        Rectangle area = REIRuntime.getInstance().calculateEntryListArea(bounds).clone();
        area.height = buttonsHeight;
        return RectangleUtils.excludeZones(bounds, ScreenRegistry.getInstance().exclusionZones().getExclusionZones(Minecraft.m_91087_().f_91080_).stream().filter(zone -> zone.intersects(area)));
    }

    public void lateRender(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (REIRuntime.getInstance().isOverlayVisible() && this.hasSpace()) {
            for (Widget widget : this.widgets) {
                if (widget instanceof LateRenderable && widget != this.menuHolder.widget()) {
                    widget.m_6305_(matrices, mouseX, mouseY, delta);
                    continue;
                }
                if (!(widget instanceof OverlaySearchField)) continue;
                OverlaySearchField field = (OverlaySearchField)widget;
                field.laterRender(matrices, mouseX, mouseY, delta);
            }
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, 500.0);
            this.menuHolder.lateRender(matrices, mouseX, mouseY, delta);
            matrices.m_85849_();
            if (this.choosePageWidget != null) {
                this.m_93250_(500);
                this.m_93179_(matrices, 0, 0, this.window.m_85445_(), this.window.m_85446_(), -1072689136, -804253680);
                this.m_93250_(0);
                this.choosePageWidget.m_6305_(matrices, mouseX, mouseY, delta);
            }
        }
        if (this.choosePageWidget == null) {
            TOOLTIPS.stream().filter(Objects::nonNull).reduce((tooltip, tooltip2) -> tooltip2).ifPresent(tooltip -> this.renderTooltip(matrices, (Tooltip)tooltip));
        }
        TOOLTIPS.clear();
        if (REIRuntime.getInstance().isOverlayVisible()) {
            this.menuHolder.afterRender();
        }
    }

    public void renderTooltip(PoseStack matrices, Tooltip tooltip) {
        this.renderTooltipInner(this.minecraft.f_91080_, matrices, tooltip, tooltip.getX(), tooltip.getY());
    }

    protected abstract void renderTooltipInner(Screen var1, PoseStack var2, Tooltip var3, int var4, int var5);

    public void addTooltip(@Nullable Tooltip tooltip) {
        if (tooltip != null) {
            TOOLTIPS.add(tooltip);
        }
    }

    public void clearTooltips() {
        TOOLTIPS.clear();
    }

    public void renderWidgets(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return;
        }
        for (Widget widget : this.widgets) {
            if (widget instanceof LateRenderable) continue;
            widget.m_6305_(matrices, mouseX, mouseY, delta);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (this.menuHolder.mouseScrolled(mouseX, mouseY, amount)) {
            return true;
        }
        if (this.hintsWidget.m_6050_(mouseX, mouseY, amount)) {
            return true;
        }
        if (this.isInside(mouseX, mouseY) && ScreenOverlayImpl.getEntryListWidget().m_6050_(mouseX, mouseY, amount)) {
            return true;
        }
        if (this.isNotInExclusionZones(PointHelper.getMouseX(), PointHelper.getMouseY()) && favoritesListWidget != null && favoritesListWidget.m_6050_(mouseX, mouseY, amount)) {
            return true;
        }
        for (Widget widget : this.widgets) {
            if (widget == ScreenOverlayImpl.getEntryListWidget() || favoritesListWidget != null && widget == favoritesListWidget || widget == this.menuHolder.widget() || widget == this.hintsWidget || !widget.m_6050_(mouseX, mouseY, amount)) continue;
            return true;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.hasSpace()) {
            return false;
        }
        if (REIRuntime.getInstance().isOverlayVisible()) {
            if (keyCode == 256 && this.choosePageWidget != null) {
                this.choosePageWidget = null;
                return true;
            }
            if (this.choosePageWidget != null) {
                return this.choosePageWidget.m_7933_(keyCode, scanCode, modifiers);
            }
            if (REIRuntimeImpl.getSearchField().m_7933_(keyCode, scanCode, modifiers)) {
                return true;
            }
            for (GuiEventListener guiEventListener : this.widgets) {
                if (guiEventListener == REIRuntimeImpl.getSearchField() || !guiEventListener.m_7933_(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        if (ConfigObject.getInstance().getHideKeybind().matchesKey(keyCode, scanCode)) {
            REIRuntime.getInstance().toggleOverlayVisible();
            return true;
        }
        EntryStack<?> stack = ScreenRegistry.getInstance().getFocusedStack(Minecraft.m_91087_().f_91080_, PointHelper.ofMouse());
        if (stack != null && !stack.isEmpty()) {
            stack = stack.copy();
            if (ConfigObject.getInstance().getRecipeKeybind().matchesKey(keyCode, scanCode)) {
                return ViewSearchBuilder.builder().addRecipesFor(stack).open();
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesKey(keyCode, scanCode)) {
                return ViewSearchBuilder.builder().addUsagesFor(stack).open();
            }
            if (ConfigObject.getInstance().getFavoriteKeyCode().matchesKey(keyCode, scanCode)) {
                FavoriteEntry favoriteEntry = FavoriteEntry.fromEntryStack(stack);
                ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
                return true;
            }
        }
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (ConfigObject.getInstance().getFocusSearchFieldKeybind().matchesKey(keyCode, scanCode)) {
            REIRuntimeImpl.getSearchField().setFocused(true);
            this.m_7522_((GuiEventListener)REIRuntimeImpl.getSearchField());
            REIRuntimeImpl.getSearchField().keybindFocusTime = System.currentTimeMillis();
            REIRuntimeImpl.getSearchField().keybindFocusKey = keyCode;
            return true;
        }
        return false;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (!this.hasSpace()) {
            return false;
        }
        if (REIRuntime.getInstance().isOverlayVisible() && this.choosePageWidget == null) {
            if (REIRuntimeImpl.getSearchField().m_7920_(keyCode, scanCode, modifiers)) {
                return true;
            }
            for (GuiEventListener guiEventListener : this.widgets) {
                if (guiEventListener == REIRuntimeImpl.getSearchField() || guiEventListener != this.m_7222_() || !guiEventListener.m_7933_(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_5534_(char character, int modifiers) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (!this.hasSpace()) {
            return false;
        }
        if (this.choosePageWidget != null) {
            return this.choosePageWidget.m_5534_(character, modifiers);
        }
        if (REIRuntimeImpl.getSearchField().m_5534_(character, modifiers)) {
            return true;
        }
        for (GuiEventListener guiEventListener : this.widgets) {
            if (guiEventListener == REIRuntimeImpl.getSearchField() || !guiEventListener.m_5534_(character, modifiers)) continue;
            return true;
        }
        return false;
    }

    public List<Widget> m_6702_() {
        return this.widgets;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean visible = REIRuntime.getInstance().isOverlayVisible();
        if (this.choosePageWidget != null) {
            if (this.choosePageWidget.containsMouse(mouseX, mouseY)) {
                return this.choosePageWidget.m_6375_(mouseX, mouseY, button);
            }
            this.choosePageWidget = null;
            this.init();
            return false;
        }
        if (!this.hasSpace()) {
            return false;
        }
        if (visible && this.configButton.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.configButton);
            if (button == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        if (ConfigObject.getInstance().getHideKeybind().matchesMouse(button)) {
            REIRuntime.getInstance().toggleOverlayVisible();
            return REIRuntime.getInstance().isOverlayVisible();
        }
        EntryStack<?> stack = ScreenRegistry.getInstance().getFocusedStack(Minecraft.m_91087_().f_91080_, PointHelper.ofMouse());
        if (stack != null && !stack.isEmpty()) {
            stack = stack.copy();
            if (ConfigObject.getInstance().getRecipeKeybind().matchesMouse(button)) {
                return ViewSearchBuilder.builder().addRecipesFor(stack).open();
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesMouse(button)) {
                return ViewSearchBuilder.builder().addUsagesFor(stack).open();
            }
            if (visible && ConfigObject.getInstance().getFavoriteKeyCode().matchesMouse(button)) {
                FavoriteEntry favoriteEntry = FavoriteEntry.fromEntryStack(stack);
                ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
                return true;
            }
        }
        if (visible) {
            Widget menuWidget = this.menuHolder.widget();
            if (menuWidget != null && menuWidget.m_6375_(mouseX, mouseY, button)) {
                this.m_7522_((GuiEventListener)menuWidget);
                if (button == 0) {
                    this.m_7897_(true);
                }
                REIRuntimeImpl.getSearchField().setFocused(false);
                return true;
            }
            if (this.hintsWidget.m_6375_(mouseX, mouseY, button)) {
                this.m_7522_((GuiEventListener)this.hintsWidget);
                if (button == 0) {
                    this.m_7897_(true);
                }
                REIRuntimeImpl.getSearchField().setFocused(false);
                return true;
            }
        }
        if (ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            ClickArea.ClickAreaContext<Screen> clickAreaContext = this.createClickAreaContext(mouseX, mouseY, screen);
            if (ScreenRegistry.getInstance().executeClickArea(screen.getClass(), clickAreaContext)) {
                return true;
            }
        }
        if (!visible) {
            return false;
        }
        for (GuiEventListener guiEventListener : this.widgets) {
            if (guiEventListener == this.configButton || guiEventListener == this.menuHolder.widget() || guiEventListener == this.hintsWidget || !guiEventListener.m_6375_(mouseX, mouseY, button)) continue;
            this.m_7522_(guiEventListener);
            if (button == 0) {
                this.m_7897_(true);
            }
            if (!(guiEventListener instanceof OverlaySearchField)) {
                REIRuntimeImpl.getSearchField().setFocused(false);
            }
            return true;
        }
        if (ConfigObject.getInstance().getFocusSearchFieldKeybind().matchesMouse(button)) {
            REIRuntimeImpl.getSearchField().setFocused(true);
            this.m_7522_((GuiEventListener)REIRuntimeImpl.getSearchField());
            REIRuntimeImpl.getSearchField().keybindFocusTime = -1L;
            REIRuntimeImpl.getSearchField().keybindFocusKey = -1;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (!this.hasSpace()) {
            return false;
        }
        if (this.choosePageWidget != null) {
            return this.choosePageWidget.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return this.m_7222_() != null && this.m_7282_() && button == 0 && this.m_7222_().m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public GuiEventListener m_7222_() {
        if (this.choosePageWidget != null) {
            return this.choosePageWidget;
        }
        return super.m_7222_();
    }

    public boolean isInside(double mouseX, double mouseY) {
        return this.bounds.contains(mouseX, mouseY) && this.isNotInExclusionZones(mouseX, mouseY);
    }

    @Override
    public boolean isNotInExclusionZones(double mouseX, double mouseY) {
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(Minecraft.m_91087_().f_91080_)) {
            InteractionResult in = decider.isInZone(mouseX, mouseY);
            if (in == InteractionResult.PASS) continue;
            return in == InteractionResult.SUCCESS;
        }
        return true;
    }

    public boolean isInside(Point point) {
        return this.isInside(point.getX(), point.getY());
    }

    @Override
    public OverlayListWidget getEntryList() {
        return ScreenOverlayImpl.getEntryListWidget();
    }

    @Override
    public Optional<OverlayListWidget> getFavoritesList() {
        return Optional.ofNullable(ScreenOverlayImpl.getFavoritesListWidget());
    }

    public MenuAccess menuAccess() {
        return this.menuHolder;
    }

    public HintsContainerWidget getHintsContainer() {
        return this.hintsWidget;
    }
}

