/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.search.method.InputMethod;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.util.FormattingUtils;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.dragging.CurrentDraggingStack;
import me.shedaniel.rei.impl.client.gui.widget.AutoCraftingEvaluator;
import me.shedaniel.rei.impl.client.gui.widget.DisplayTooltipComponent;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.registry.display.DisplayRegistryImpl;
import me.shedaniel.rei.impl.client.registry.display.DisplaysHolder;
import me.shedaniel.rei.impl.client.view.ViewsImpl;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class EntryWidget
extends Slot
implements DraggableStackProviderWidget {
    @ApiStatus.Internal
    public static long stackDisplayOffset = 0L;
    @ApiStatus.Internal
    private byte noticeMark = 0;
    protected boolean highlight = true;
    protected boolean tooltips = true;
    protected boolean background = true;
    protected boolean interactable = true;
    protected boolean interactableFavorites = true;
    protected boolean wasClicked = false;
    private Rectangle bounds;
    private List<EntryStack<?>> entryStacks;
    @Nullable
    private Set<UnaryOperator<Tooltip>> tooltipProcessors;
    public ResourceLocation tagMatch;
    public boolean removeTagMatch = true;
    private long lastCheckTime = -1L;
    private long lastCheckedTime = -1L;
    private Display display;
    private Supplier<DisplayTooltipComponent> displayTooltipComponent;
    private final NumberAnimator<Float> darkBackgroundAlpha = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(REIRuntime.getInstance().isDarkThemeEnabled() ? 1.0f : 0.0f), ValueAnimator.typicalTransitionTime()).asFloat();
    private final NumberAnimator<Float> darkHighlightedAlpha = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(REIRuntime.getInstance().isDarkThemeEnabled() ? 1.0f : 0.0f), ValueAnimator.typicalTransitionTime()).asFloat();

    public EntryWidget(Point point) {
        this(new Rectangle(point.x - 1, point.y - 1, 18, 18));
    }

    public EntryWidget(Rectangle bounds) {
        this.bounds = bounds;
        this.entryStacks = Collections.emptyList();
    }

    @Override
    public EntryWidget unmarkInputOrOutput() {
        this.noticeMark = 0;
        return this;
    }

    public EntryWidget markIsInput() {
        this.noticeMark = 1;
        return this;
    }

    public EntryWidget markIsOutput() {
        this.noticeMark = (byte)2;
        return this;
    }

    @Override
    public byte getNoticeMark() {
        return this.noticeMark;
    }

    @Override
    public void setNoticeMark(byte noticeMark) {
        this.noticeMark = noticeMark;
    }

    @Override
    public void setInteractable(boolean interactable) {
        this.interactable(interactable);
    }

    @Override
    public boolean isInteractable() {
        return this.interactable;
    }

    @Override
    public void setInteractableFavorites(boolean interactableFavorites) {
        this.interactableFavorites(interactableFavorites);
    }

    @Override
    public boolean isInteractableFavorites() {
        return this.interactableFavorites;
    }

    public EntryWidget disableInteractions() {
        return this.interactable(false);
    }

    @Override
    public EntryWidget interactable(boolean b) {
        this.interactable = b;
        this.interactableFavorites = this.interactableFavorites && this.interactable;
        return this;
    }

    public EntryWidget disableFavoritesInteractions() {
        return this.interactableFavorites(false);
    }

    @Override
    public EntryWidget interactableFavorites(boolean b) {
        this.interactableFavorites = b && this.interactable;
        return this;
    }

    public EntryWidget noHighlight() {
        return this.highlight(false);
    }

    public EntryWidget highlight(boolean b) {
        this.highlight = b;
        return this;
    }

    @Override
    public boolean isHighlightEnabled() {
        return this.highlight;
    }

    @Override
    public void setHighlightEnabled(boolean highlights) {
        this.highlight(highlights);
    }

    public EntryWidget noTooltips() {
        return this.tooltips(false);
    }

    public EntryWidget tooltips(boolean b) {
        this.tooltips = b;
        return this;
    }

    @Override
    public void setTooltipsEnabled(boolean tooltipsEnabled) {
        this.tooltips(tooltipsEnabled);
    }

    @Override
    public boolean isTooltipsEnabled() {
        return this.tooltips;
    }

    public EntryWidget noBackground() {
        return this.background(false);
    }

    public EntryWidget background(boolean b) {
        this.background = b;
        return this;
    }

    @Override
    public void setBackgroundEnabled(boolean backgroundEnabled) {
        this.background(backgroundEnabled);
    }

    @Override
    public boolean isBackgroundEnabled() {
        return this.background;
    }

    public EntryWidget clearStacks() {
        this.entryStacks = Collections.emptyList();
        return this;
    }

    @Override
    public Slot clearEntries() {
        return this.clearStacks();
    }

    @Override
    public EntryWidget entry(EntryStack<?> stack) {
        Objects.requireNonNull(stack);
        if (this.entryStacks.isEmpty()) {
            this.entryStacks = Collections.singletonList(stack);
        } else {
            if (!(this.entryStacks instanceof ArrayList)) {
                this.entryStacks = new ArrayList(this.entryStacks);
            }
            this.entryStacks.add(stack);
        }
        if (this.removeTagMatch) {
            this.tagMatch = null;
        }
        return this;
    }

    @Override
    public EntryWidget entries(Collection<? extends EntryStack<?>> stacks) {
        if (!stacks.isEmpty()) {
            if (!(this.entryStacks instanceof ArrayList)) {
                this.entryStacks = new ArrayList(this.entryStacks);
            }
            this.entryStacks.addAll(stacks);
            if (this.removeTagMatch) {
                this.tagMatch = null;
            }
        }
        return this;
    }

    @Override
    public EntryStack<?> getCurrentEntry() {
        int size = this.entryStacks.size();
        if (size == 0) {
            return EntryStack.empty();
        }
        if (size == 1) {
            return this.entryStacks.get(0);
        }
        return this.entryStacks.get(Mth.m_14107_((double)((double)((System.currentTimeMillis() + stackDisplayOffset) / this.getCyclingInterval()) % (double)size)));
    }

    protected long getCyclingInterval() {
        return 1000L;
    }

    @Override
    public List<EntryStack<?>> getEntries() {
        return this.entryStacks;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public Rectangle getInnerBounds() {
        return new Rectangle(this.bounds.x + 1, this.bounds.y + 1, this.bounds.width - 2, this.bounds.height - 2);
    }

    @Nullable
    private TransferHandler _getTransferHandler() {
        this.lastCheckTime = Util.m_137550_();
        if (PluginManager.areAnyReloading()) {
            return null;
        }
        try {
            DisplayRegistry displayRegistry = DisplayRegistry.getInstance();
            DisplaysHolder displaysHolder = ((DisplayRegistryImpl)displayRegistry).displaysHolder();
            CategoryRegistry categoryRegistry = CategoryRegistry.getInstance();
            Map<CategoryIdentifier<?>, Boolean> filteringQuickCraftCategories = ConfigObject.getInstance().getFilteringQuickCraftCategories();
            boolean shouldFilterDisplays = ConfigObject.getInstance().shouldFilterDisplays();
            for (Display display : displaysHolder.getAllDisplaysByOutputs(this.getEntries())) {
                CategoryIdentifier<?> categoryIdentifier = display.getCategoryIdentifier();
                Optional<CategoryRegistry.CategoryConfiguration<?>> configuration = categoryRegistry.tryGet(categoryIdentifier);
                if (configuration.isEmpty() || categoryRegistry.isCategoryInvisible(configuration.get().getCategory()) || !filteringQuickCraftCategories.getOrDefault(categoryIdentifier, configuration.get().isQuickCraftingEnabledByDefault()).booleanValue() || shouldFilterDisplays && !displayRegistry.isDisplayVisible(display)) continue;
                AutoCraftingEvaluator.AutoCraftingResult result = AutoCraftingEvaluator.evaluateAutoCrafting(false, false, display, null);
                if (!result.successful) continue;
                this.display = display;
                this.displayTooltipComponent = Suppliers.memoize(() -> new DisplayTooltipComponent(display));
                return result.successfulHandler;
            }
        }
        catch (ConcurrentModificationException ignored) {
            this.display = null;
            this.displayTooltipComponent = null;
            this.lastCheckTime = -1L;
        }
        return null;
    }

    private TransferHandler getTransferHandler(boolean query) {
        if (PluginManager.areAnyReloading()) {
            return null;
        }
        if (this.display != null) {
            if (ViewsImpl.isRecipesFor(null, this.getEntries(), this.display)) {
                AutoCraftingEvaluator.AutoCraftingResult result = AutoCraftingEvaluator.evaluateAutoCrafting(false, false, this.display, null);
                if (result.successful) {
                    return result.successfulHandler;
                }
            }
            this.display = null;
            this.displayTooltipComponent = null;
            this.lastCheckTime = -1L;
        }
        if (this.lastCheckTime != -1L && Util.m_137550_() - this.lastCheckTime < 2000L) {
            return null;
        }
        return query ? this._getTransferHandler() : null;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.drawBackground(matrices, mouseX, mouseY, delta);
        this.drawCurrentEntry(matrices, mouseX, mouseY, delta);
        boolean highlighted = this.containsMouse(mouseX, mouseY);
        if (this.hasTooltips() && highlighted) {
            this.queueTooltip(matrices, mouseX, mouseY, delta);
        }
        if (this.hasHighlight() && highlighted) {
            this.drawHighlighted(matrices, mouseX, mouseY, delta);
        }
        this.drawExtra(matrices, mouseX, mouseY, delta);
    }

    public final boolean hasTooltips() {
        return this.isTooltipsEnabled();
    }

    public final boolean hasHighlight() {
        return this.isHighlightEnabled();
    }

    protected void drawBackground(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.background) {
            this.darkBackgroundAlpha.update((double)delta);
            RenderSystem.m_69478_();
            RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
            RenderSystem.m_69405_((int)770, (int)771);
            RenderSystem.m_157456_((int)0, (ResourceLocation)InternalTextures.CHEST_GUI_TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.m_93228_(matrices, this.bounds.x, this.bounds.y, 0, 222, this.bounds.width, this.bounds.height);
            if (((Float)this.darkBackgroundAlpha.value()).floatValue() > 0.0f) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)InternalTextures.CHEST_GUI_TEXTURE_DARK);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((Float)this.darkBackgroundAlpha.value()).floatValue());
                this.m_93228_(matrices, this.bounds.x, this.bounds.y, 0, 222, this.bounds.width, this.bounds.height);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    protected void drawCurrentEntry(PoseStack matrices, int mouseX, int mouseY, float delta) {
        EntryStack<?> entry = this.getCurrentEntry();
        entry.setZ(100);
        entry.render(matrices, this.getInnerBounds(), mouseX, mouseY, delta);
    }

    protected void queueTooltip(PoseStack matrices, int mouseX, int mouseY, float delta) {
        Tooltip tooltip = this.getCurrentTooltip(TooltipContext.ofMouse());
        if (tooltip != null) {
            tooltip.queue();
        }
    }

    protected void drawExtra(PoseStack matrices, int mouseX, int mouseY, float delta) {
    }

    @Override
    @Nullable
    public Tooltip getCurrentTooltip(TooltipContext context) {
        Tooltip tooltip = this.getCurrentEntry().getTooltip(context);
        if (tooltip != null && !(Minecraft.m_91087_().f_91080_ instanceof DisplayScreen)) {
            boolean exists;
            boolean bl = exists = this.getTransferHandler(false) != null;
            if (!exists) {
                if (this.lastCheckedTime == -1L || Util.m_137550_() - this.lastCheckedTime > 400L) {
                    this.lastCheckedTime = Util.m_137550_();
                }
                if (Util.m_137550_() - this.lastCheckedTime > 200L) {
                    this.lastCheckedTime = -1L;
                    exists = this.getTransferHandler(true) != null;
                }
            } else {
                this.lastCheckedTime = -1L;
            }
            if (exists) {
                tooltip.add((Component)Component.m_237115_((String)"text.auto_craft.move_items.tooltip").m_130940_(ChatFormatting.YELLOW));
                tooltip.add(this.displayTooltipComponent.get());
            }
        }
        if (tooltip != null) {
            if (this.interactableFavorites && ConfigObject.getInstance().doDisplayFavoritesTooltip() && !ConfigObject.getInstance().getFavoriteKeyCode().isUnknown()) {
                String name = ConfigObject.getInstance().getFavoriteKeyCode().getLocalizedName().getString();
                if (this.reverseFavoritesAction()) {
                    tooltip.addAllTexts(Stream.of(I18n.m_118938_((String)"text.rei.remove_favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(Component::m_237113_).collect(Collectors.toList()));
                } else {
                    tooltip.addAllTexts(Stream.of(I18n.m_118938_((String)"text.rei.favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(Component::m_237113_).collect(Collectors.toList()));
                }
            }
            if (this.tooltipProcessors != null) {
                for (UnaryOperator<Tooltip> processor : this.tooltipProcessors) {
                    tooltip = (Tooltip)processor.apply(tooltip);
                }
            }
        }
        if (tooltip != null) {
            Tooltip.Entry entry;
            if (this.interactableFavorites && ConfigObject.getInstance().doDisplayFavoritesTooltip() && !ConfigObject.getInstance().getFavoriteKeyCode().isUnknown()) {
                String name = ConfigObject.getInstance().getFavoriteKeyCode().getLocalizedName().getString();
                if (this.reverseFavoritesAction()) {
                    tooltip.addAllTexts(Stream.of(I18n.m_118938_((String)"text.rei.remove_favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(Component::m_237113_).collect(Collectors.toList()));
                } else {
                    tooltip.addAllTexts(Stream.of(I18n.m_118938_((String)"text.rei.favorites_tooltip", (Object[])new Object[]{name}).split("\n")).map(Component::m_237113_).collect(Collectors.toList()));
                }
            }
            if (this.tooltipProcessors != null) {
                for (UnaryOperator<Tooltip> processor : this.tooltipProcessors) {
                    tooltip = (Tooltip)processor.apply(tooltip);
                }
            }
            if (!tooltip.entries().isEmpty() && ConfigObject.getInstance().doDisplayIMEHints() && (entry = tooltip.entries().get(0)).isText()) {
                String name = FormattingUtils.stripFormatting(entry.getAsText().getString());
                InputMethod<?> active = InputMethod.active();
                String suggested = active.suggestInputString(name);
                if (suggested != null) {
                    tooltip.entries().add(1, Tooltip.entry((Component)Component.m_237113_((String)suggested).m_130940_(ChatFormatting.GRAY)));
                }
            }
        }
        return tooltip;
    }

    protected void drawHighlighted(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.darkHighlightedAlpha.update((double)delta);
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        Rectangle bounds = this.getInnerBounds();
        this.m_93179_(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), -2130706433, -2130706433);
        int darkColor = 0x111111 | (int)(90.0f * ((Float)this.darkHighlightedAlpha.value()).floatValue()) << 24;
        this.m_93179_(matrices, bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), darkColor, darkColor);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
    }

    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }

    protected boolean wasClicked() {
        boolean b = this.wasClicked;
        this.wasClicked = false;
        return b;
    }

    public void tooltipProcessor(UnaryOperator<Tooltip> operator) {
        if (this.tooltipProcessors == null) {
            this.tooltipProcessors = Collections.singleton(operator);
        } else {
            if (!(this.tooltipProcessors instanceof LinkedHashSet)) {
                this.tooltipProcessors = new LinkedHashSet<UnaryOperator<Tooltip>>(this.tooltipProcessors);
            }
            this.tooltipProcessors.add(operator);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.containsMouse(mouseX, mouseY)) {
            this.wasClicked = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (REIRuntimeImpl.isWithinRecipeViewingScreen && this.entryStacks.size() > 1 && this.containsMouse(mouseX, mouseY)) {
            if (amount < 0.0) {
                stackDisplayOffset = ((System.currentTimeMillis() + stackDisplayOffset) / 1000L - 1L) * 1000L;
                return true;
            }
            if (amount > 0.0) {
                stackDisplayOffset = ((System.currentTimeMillis() + stackDisplayOffset) / 1000L + 1L) * 1000L;
                return true;
            }
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (!this.interactable) {
            return false;
        }
        if (this.wasClicked() && this.containsMouse(mouseX, mouseY) && this.doAction(mouseX, mouseY, button)) {
            ((CurrentDraggingStack)DraggingContext.getInstance()).drop();
            return true;
        }
        return false;
    }

    protected boolean doAction(double mouseX, double mouseY, int button) {
        FavoriteEntry favoriteEntry;
        ModifierKeyCode keyCode;
        if (this.interactableFavorites && ConfigObject.getInstance().isFavoritesEnabled() && !this.getCurrentEntry().isEmpty() && (keyCode = ConfigObject.getInstance().getFavoriteKeyCode()).matchesMouse(button) && (favoriteEntry = this.asFavoriteEntry()) != null) {
            if (this.reverseFavoritesAction()) {
                ConfigObject.getInstance().getFavoriteEntries().remove(favoriteEntry);
            } else {
                ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
            }
            ConfigManager.getInstance().saveConfig();
            FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
            if (favoritesListWidget != null) {
                favoritesListWidget.updateSearch();
            }
            return true;
        }
        if (!(Minecraft.m_91087_().f_91080_ instanceof DisplayScreen) && Screen.m_96637_()) {
            try {
                TransferHandler handler = this.getTransferHandler(true);
                if (handler != null) {
                    AbstractContainerScreen<?> containerScreen = REIRuntime.getInstance().getPreviousContainerScreen();
                    TransferHandler.Context context = TransferHandler.Context.create(true, Screen.m_96638_() || button == 1, containerScreen, this.display);
                    TransferHandler.Result transferResult = handler.handle(context);
                    if (transferResult.isBlocking()) {
                        this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                        if (transferResult.isReturningToScreen() && Minecraft.m_91087_().f_91080_ != containerScreen) {
                            Minecraft.m_91087_().m_91152_(containerScreen);
                            REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                        }
                        return true;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (ConfigObject.getInstance().getRecipeKeybind().getType() != InputConstants.Type.MOUSE && button == 0 || ConfigObject.getInstance().getRecipeKeybind().matchesMouse(button)) {
            return ViewSearchBuilder.builder().addRecipesFor(this.getCurrentEntry()).open();
        }
        if (ConfigObject.getInstance().getUsageKeybind().getType() != InputConstants.Type.MOUSE && button == 1 || ConfigObject.getInstance().getUsageKeybind().matchesMouse(button)) {
            return ViewSearchBuilder.builder().addUsagesFor(this.getCurrentEntry()).open();
        }
        return false;
    }

    @ApiStatus.Internal
    @Nullable
    protected FavoriteEntry asFavoriteEntry() {
        FavoriteEntry entry = FavoriteEntry.fromEntryStack(this.getCurrentEntry().normalize());
        return entry.isInvalid() ? null : entry;
    }

    @ApiStatus.Internal
    public boolean cancelDeleteItems(EntryStack<?> stack) {
        return false;
    }

    protected boolean reverseFavoritesAction() {
        return false;
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return mouseX >= (double)(this.bounds.x + 1) && mouseY >= (double)(this.bounds.y + 1) && mouseX <= (double)(this.bounds.getMaxX() - 1) && mouseY <= (double)(this.bounds.getMaxY() - 1);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.containsMouse(EntryWidget.mouse())) {
            return this.keyPressedIgnoreContains(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean keyPressedIgnoreContains(int keyCode, int scanCode, int modifiers) {
        FavoriteEntry favoriteEntry;
        if (!this.interactable) {
            return false;
        }
        if (this.interactableFavorites && ConfigObject.getInstance().isFavoritesEnabled() && !this.getCurrentEntry().isEmpty() && ConfigObject.getInstance().getFavoriteKeyCode().matchesKey(keyCode, scanCode) && (favoriteEntry = this.asFavoriteEntry()) != null) {
            if (this.reverseFavoritesAction()) {
                ConfigObject.getInstance().getFavoriteEntries().remove(favoriteEntry);
            } else {
                ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
            }
            ConfigManager.getInstance().saveConfig();
            FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
            if (favoritesListWidget != null) {
                favoritesListWidget.updateSearch();
            }
            return true;
        }
        if (ConfigObject.getInstance().getRecipeKeybind().matchesKey(keyCode, scanCode)) {
            return ViewSearchBuilder.builder().addRecipesFor(this.getCurrentEntry()).open();
        }
        if (ConfigObject.getInstance().getUsageKeybind().matchesKey(keyCode, scanCode)) {
            return ViewSearchBuilder.builder().addUsagesFor(this.getCurrentEntry()).open();
        }
        return false;
    }

    @Override
    @Nullable
    public DraggableStack getHoveredStack(final DraggingContext<Screen> context, double mouseX, double mouseY) {
        if (!this.getCurrentEntry().isEmpty() && this.containsMouse(mouseX, mouseY)) {
            return new DraggableStack(){
                EntryStack<?> stack;
                {
                    this.stack = EntryWidget.this.getCurrentEntry().copy().removeSetting(EntryStack.Settings.RENDERER).removeSetting(EntryStack.Settings.FLUID_RENDER_RATIO);
                }

                @Override
                public EntryStack<?> getStack() {
                    return this.stack;
                }

                @Override
                public void drag() {
                }

                @Override
                public void release(DraggedAcceptorResult result) {
                    if (result == DraggedAcceptorResult.PASS) {
                        context.renderBackToPosition((DraggableStack)this, DraggingContext.getInstance().getCurrentPosition(), () -> new Point(EntryWidget.this.getBounds().x, EntryWidget.this.getBounds().y));
                    }
                }
            };
        }
        return null;
    }

    @Override
    @Deprecated
    public void render(PoseStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
        Rectangle clone = this.getBounds().clone();
        this.getBounds().setBounds(bounds.x - 1, bounds.y - 1, bounds.width + 2, bounds.height + 2);
        this.m_6305_(matrices, mouseX, mouseY, delta);
        this.getBounds().setBounds(clone);
    }

    @Override
    public void fillCrashReport(CrashReport report, CrashReportCategory category) {
        super.fillCrashReport(report, category);
        category.m_128165_("Notice mark", () -> String.valueOf(this.getNoticeMark()));
        category.m_128165_("Interactable", () -> String.valueOf(this.isInteractable()));
        category.m_128165_("Interactable favorites", () -> String.valueOf(this.isInteractableFavorites()));
        category.m_128165_("Highlight enabled", () -> String.valueOf(this.isHighlightEnabled()));
        category.m_128165_("Tooltip enabled", () -> String.valueOf(this.isTooltipsEnabled()));
        category.m_128165_("Background enabled", () -> String.valueOf(this.isBackgroundEnabled()));
        category.m_128165_("Entries count", () -> String.valueOf(this.entryStacks.size()));
        EntryStack<?> currentEntry = this.getCurrentEntry();
        CrashReportCategory entryCategory = report.m_127514_("Current Rendering Entry");
        currentEntry.fillCrashReport(report, entryCategory);
    }
}

