/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultCompostingDisplay;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultCompostingCategory
implements DisplayCategory<DefaultCompostingDisplay> {
    @Override
    public CategoryIdentifier<? extends DefaultCompostingDisplay> getCategoryIdentifier() {
        return BuiltinPlugin.COMPOSTING;
    }

    @Override
    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)Blocks.f_50715_);
    }

    @Override
    public Component getTitle() {
        return Component.m_237115_((String)"category.rei.composting");
    }

    @Override
    public DisplayRenderer getDisplayRenderer(final DefaultCompostingDisplay display) {
        return new DisplayRenderer(){
            private Component text;
            {
                this.text = Component.m_237110_((String)"text.rei.composting.page", (Object[])new Object[]{display.getPage() + 1});
            }

            @Override
            public int getHeight() {
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                return 10 + 9;
            }

            @Override
            public void render(PoseStack matrices, Rectangle rectangle, int mouseX, int mouseY, float delta) {
                Minecraft.m_91087_().f_91062_.m_92877_(matrices, this.text.m_7532_(), (float)(rectangle.x + 5), (float)(rectangle.y + 6), -1);
            }
        };
    }

    @Override
    public List<Widget> setupDisplay(DefaultCompostingDisplay display, Rectangle bounds) {
        ArrayList widgets = Lists.newArrayList();
        Point startingPoint = new Point(bounds.x + bounds.width - 55, bounds.y + 110);
        ArrayList<EntryIngredient> stacks = new ArrayList<EntryIngredient>(display.getInputEntries());
        widgets.add(Widgets.createRecipeBase(bounds));
        int i = 0;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 7; ++x) {
                ItemStack firstStack;
                float chance;
                EntryIngredient entryIngredient;
                EntryIngredient entryIngredient2 = entryIngredient = stacks.size() > i ? (EntryIngredient)stacks.get(i) : EntryIngredient.empty();
                if (!entryIngredient.isEmpty() && (chance = ComposterBlock.f_51914_.getFloat((Object)(firstStack = (ItemStack)((EntryStack)entryIngredient.get(0)).getValue()).m_41720_())) > 0.0f) {
                    entryIngredient = entryIngredient.map(stack -> stack.copy().tooltip(new Component[]{Component.m_237110_((String)"text.rei.composting.chance", (Object[])new Object[]{Mth.m_14045_((int)Mth.m_14080_((double)(chance * 100.0f)), (int)0, (int)100)}).m_130940_(ChatFormatting.YELLOW)}));
                }
                widgets.add(Widgets.createSlot(new Point(bounds.getCenterX() - 72 + 9 + x * 18, bounds.y + 12 + y * 18)).entries(entryIngredient).markInput());
                ++i;
            }
        }
        widgets.add(Widgets.createArrow(new Point(startingPoint.x - 1 - 5, startingPoint.y + 7 - 5)));
        widgets.add(Widgets.createResultSlotBackground(new Point(startingPoint.x + 33 - 5, startingPoint.y + 8 - 5)));
        widgets.add(Widgets.createSlot(new Point(startingPoint.x + 33 - 5, startingPoint.y + 8 - 5)).entries(display.getOutputEntries().get(0)).disableBackground().markOutput());
        return widgets;
    }

    @Override
    public int getDisplayHeight() {
        return 140;
    }

    @Override
    public int getFixedDisplaysPerPage() {
        return 1;
    }
}

