/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.AutomobileComponent;
import io.github.foundationgames.automobility.automobile.AutomobileData;
import io.github.foundationgames.automobility.automobile.render.AutomobileModels;
import io.github.foundationgames.automobility.automobile.render.AutomobileRenderer;
import io.github.foundationgames.automobility.automobile.render.ExhaustFumesModel;
import io.github.foundationgames.automobility.automobile.render.SkidEffectModel;
import io.github.foundationgames.automobility.automobile.render.attachment.front.HarvesterFrontAttachmentModel;
import io.github.foundationgames.automobility.automobile.render.attachment.front.MobControllerFrontAttachmentModel;
import io.github.foundationgames.automobility.automobile.render.attachment.rear.BannerPostRearAttachmentModel;
import io.github.foundationgames.automobility.automobile.render.attachment.rear.BlockRearAttachmentModel;
import io.github.foundationgames.automobility.automobile.render.attachment.rear.ChestRearAttachmentModel;
import io.github.foundationgames.automobility.automobile.render.attachment.rear.GrindstoneRearAttachmentModel;
import io.github.foundationgames.automobility.automobile.render.attachment.rear.PassengerSeatRearAttachmentModel;
import io.github.foundationgames.automobility.automobile.render.attachment.rear.PlowRearAttachmentModel;
import io.github.foundationgames.automobility.automobile.render.attachment.rear.StonecutterRearAttachmentModel;
import io.github.foundationgames.automobility.automobile.render.engine.CopperEngineModel;
import io.github.foundationgames.automobility.automobile.render.engine.CreativeEngineModel;
import io.github.foundationgames.automobility.automobile.render.engine.DiamondEngineModel;
import io.github.foundationgames.automobility.automobile.render.engine.GoldEngineModel;
import io.github.foundationgames.automobility.automobile.render.engine.IronEngineModel;
import io.github.foundationgames.automobility.automobile.render.engine.StoneEngineModel;
import io.github.foundationgames.automobility.automobile.render.frame.CARRFrameModel;
import io.github.foundationgames.automobility.automobile.render.frame.MotorcarFrameModel;
import io.github.foundationgames.automobility.automobile.render.frame.PineappleFrameModel;
import io.github.foundationgames.automobility.automobile.render.frame.RickshawFrameModel;
import io.github.foundationgames.automobility.automobile.render.frame.ShoppingCartFrameModel;
import io.github.foundationgames.automobility.automobile.render.frame.StandardFrameModel;
import io.github.foundationgames.automobility.automobile.render.frame.TractorFrameModel;
import io.github.foundationgames.automobility.automobile.render.item.ItemRenderableAutomobile;
import io.github.foundationgames.automobility.automobile.render.wheel.CarriageWheelModel;
import io.github.foundationgames.automobility.automobile.render.wheel.OffRoadWheelModel;
import io.github.foundationgames.automobility.automobile.render.wheel.StandardWheelModel;
import io.github.foundationgames.automobility.automobile.render.wheel.SteelWheelModel;
import io.github.foundationgames.automobility.automobile.render.wheel.TractorWheelModel;
import io.github.foundationgames.automobility.block.AutomobilityBlocks;
import io.github.foundationgames.automobility.block.entity.render.AutomobileAssemblerBlockEntityRenderer;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.entity.AutomobilityEntities;
import io.github.foundationgames.automobility.entity.render.AutomobileEntityRenderer;
import io.github.foundationgames.automobility.item.AutomobileComponentItem;
import io.github.foundationgames.automobility.item.AutomobilityItems;
import io.github.foundationgames.automobility.platform.Platform;
import io.github.foundationgames.automobility.screen.AutoMechanicTableScreen;
import io.github.foundationgames.automobility.screen.SingleSlotScreen;
import io.github.foundationgames.automobility.sound.AutomobileSoundInstance;
import io.github.foundationgames.automobility.util.FloatFunc;
import io.github.foundationgames.automobility.util.network.ClientPackets;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.model.Model;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;

public class AutomobilityClient {
    public static final BlockColor GRASS_COLOR = (state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0);
    public static final ItemColor GRASS_ITEM_COLOR = (stack, tintIndex) -> GrassColor.m_46415_((double)0.5, (double)1.0);

    public static void init() {
        AutomobileModels.init();
        AutomobilityClient.initBlocks();
        AutomobilityClient.initItems();
        AutomobilityClient.initEntities();
        ClientPackets.initClient();
        Platform.get().registerMenuScreen(Automobility.AUTO_MECHANIC_SCREEN.require(), AutoMechanicTableScreen::new);
        Platform.get().registerMenuScreen(Automobility.SINGLE_SLOT_SCREEN.require(), SingleSlotScreen::new);
    }

    public static void initBlocks() {
        Platform.get().blockEntityRenderer(AutomobilityBlocks.AUTOMOBILE_ASSEMBLER_ENTITY.require(), AutomobileAssemblerBlockEntityRenderer::new);
    }

    public static void initItems() {
        AutomobileData automobileReader = new AutomobileData();
        ItemRenderableAutomobile itemAutomobile = new ItemRenderableAutomobile(automobileReader);
        Platform.get().builtinItemRenderer(AutomobilityItems.AUTOMOBILE.require(), (stack, type, pose, buffers, light, overlay) -> {
            automobileReader.read(stack.m_41698_("Automobile"));
            float wheelDist = automobileReader.getFrame().model().lengthPx() / 16.0f;
            float scale = 1.0f;
            pose.m_85841_(scale /= wheelDist * 0.77f, scale, scale);
            AutomobileRenderer.render(pose, buffers, light, overlay, Minecraft.m_91087_().m_91296_(), itemAutomobile);
        });
        AutomobilityClient.componentItemRenderer(AutomobilityItems.AUTOMOBILE_FRAME.require(), t -> AutomobileModels.getModel(t.model().modelId()), t -> t.model().texture(), t -> 1.0f / (t.model().lengthPx() / 16.0f * 0.77f));
        AutomobilityClient.componentItemRenderer(AutomobilityItems.AUTOMOBILE_WHEEL.require(), t -> AutomobileModels.getModel(t.model().modelId()), t -> t.model().texture(), t -> 6.0f / t.model().radius());
        AutomobilityClient.componentItemRenderer(AutomobilityItems.AUTOMOBILE_ENGINE.require(), t -> AutomobileModels.getModel(t.model().modelId()), t -> t.model().texture(), t -> 1.0f);
        AutomobilityClient.componentItemRenderer(AutomobilityItems.REAR_ATTACHMENT.require(), t -> AutomobileModels.getModel(t.model().modelId()), t -> t.model().texture(), t -> 1.0f);
        AutomobilityClient.componentItemRenderer(AutomobilityItems.FRONT_ATTACHMENT.require(), t -> AutomobileModels.getModel(t.model().modelId()), t -> t.model().texture(), t -> t.model().scale());
    }

    public static <T extends AutomobileComponent<T>> void componentItemRenderer(AutomobileComponentItem<T> item, Function<T, Model> modelProvider, Function<T, ResourceLocation> textureProvider, FloatFunc<T> scaleProvider) {
        Platform.get().builtinItemRenderer(item, (stack, mode, matrices, vertexConsumers, light, overlay) -> {
            Object component = item.getComponent((ItemStack)stack);
            if (item.isVisible(component)) {
                Model model = (Model)modelProvider.apply(component);
                float scale = scaleProvider.apply(component);
                matrices.m_85837_(0.5, 0.0, 0.5);
                matrices.m_85841_(scale, -scale, -scale);
                model.m_7695_(matrices, vertexConsumers.m_6299_(model.m_103119_((ResourceLocation)textureProvider.apply(component))), light.intValue(), overlay.intValue(), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        });
    }

    public static void initEntities() {
        Platform libs = Platform.get();
        libs.entityRenderer(AutomobilityEntities.AUTOMOBILE.require(), AutomobileEntityRenderer::new);
        libs.modelLayer(StandardFrameModel.MODEL_LAYER);
        libs.modelLayer(TractorFrameModel.MODEL_LAYER);
        libs.modelLayer(MotorcarFrameModel.MODEL_LAYER);
        libs.modelLayer(ShoppingCartFrameModel.MODEL_LAYER);
        libs.modelLayer(CARRFrameModel.MODEL_LAYER);
        libs.modelLayer(PineappleFrameModel.MODEL_LAYER);
        libs.modelLayer(RickshawFrameModel.MODEL_LAYER);
        libs.modelLayer(StandardWheelModel.MODEL_LAYER);
        libs.modelLayer(OffRoadWheelModel.MODEL_LAYER);
        libs.modelLayer(TractorWheelModel.MODEL_LAYER);
        libs.modelLayer(CarriageWheelModel.MODEL_LAYER);
        libs.modelLayer(SteelWheelModel.MODEL_LAYER);
        libs.modelLayer(StoneEngineModel.MODEL_LAYER);
        libs.modelLayer(IronEngineModel.MODEL_LAYER);
        libs.modelLayer(CopperEngineModel.MODEL_LAYER);
        libs.modelLayer(GoldEngineModel.MODEL_LAYER);
        libs.modelLayer(DiamondEngineModel.MODEL_LAYER);
        libs.modelLayer(CreativeEngineModel.MODEL_LAYER);
        libs.modelLayer(PassengerSeatRearAttachmentModel.MODEL_LAYER);
        libs.modelLayer(BlockRearAttachmentModel.MODEL_LAYER);
        libs.modelLayer(GrindstoneRearAttachmentModel.MODEL_LAYER);
        libs.modelLayer(StonecutterRearAttachmentModel.MODEL_LAYER);
        libs.modelLayer(ChestRearAttachmentModel.MODEL_LAYER);
        libs.modelLayer(BannerPostRearAttachmentModel.MODEL_LAYER);
        libs.modelLayer(PlowRearAttachmentModel.MODEL_LAYER);
        libs.modelLayer(MobControllerFrontAttachmentModel.MODEL_LAYER);
        libs.modelLayer(HarvesterFrontAttachmentModel.MODEL_LAYER);
        libs.modelLayer(SkidEffectModel.MODEL_LAYER);
        libs.modelLayer(ExhaustFumesModel.MODEL_LAYER);
        AutomobileEntity.engineSound = auto -> {
            if (auto.getEngine().isEmpty()) {
                return;
            }
            Minecraft client = Minecraft.m_91087_();
            client.m_91106_().m_120367_((SoundInstance)new AutomobileSoundInstance.EngineSound(client, (AutomobileEntity)auto));
        };
        AutomobileEntity.skidSound = auto -> {
            Minecraft client = Minecraft.m_91087_();
            client.m_91106_().m_120367_((SoundInstance)new AutomobileSoundInstance.SkiddingSound(client, (AutomobileEntity)auto));
        };
    }

    public static double modifyBoostFov(Minecraft client, double old, float tickDelta) {
        LocalPlayer player = client.f_91074_;
        Entity entity = player.m_20202_();
        if (entity instanceof AutomobileEntity) {
            AutomobileEntity auto = (AutomobileEntity)entity;
            return old + Math.sqrt(auto.getBoostSpeed(tickDelta)) * 18.0 * (Double)client.f_91066_.m_231925_().m_231551_();
        }
        return old;
    }
}

