/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block;

import io.github.foundationgames.automobility.block.entity.AutomobileAssemblerBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AutomobileAssemblerBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final Component USE_CROWBAR_DIALOG = Component.m_237115_((String)"dialog.automobility.use_crowbar").m_130940_(ChatFormatting.GOLD);
    public static final Component INCOMPLETE_AUTOMOBILE_DIALOG = Component.m_237115_((String)"dialog.automobility.incomplete_automobile").m_130940_(ChatFormatting.RED);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final VoxelShape BASE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)Block.m_49796_((double)5.0, (double)4.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0));
    private static final VoxelShape NORTH_SOUTH = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0));
    private static final VoxelShape EAST_WEST = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)12.0, (double)16.0));

    public AutomobileAssemblerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.m_6861_(state, world, pos, block, fromPos, notify);
        boolean power = world.m_46753_(pos);
        if (power != (Boolean)state.m_61143_((Property)POWERED)) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(power)));
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!world.m_5776_() && placer instanceof Player) {
            Player player = (Player)placer;
            player.m_5661_(USE_CROWBAR_DIALOG, true);
        }
        super.m_6402_(world, pos, state, placer, itemStack);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof AutomobileAssemblerBlockEntity) {
            AutomobileAssemblerBlockEntity assembler = (AutomobileAssemblerBlockEntity)blockEntity;
            return assembler.interact(player, hand);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity blockEntity;
        if (!newState.m_60713_((Block)this) && (blockEntity = world.m_7702_(pos)) instanceof AutomobileAssemblerBlockEntity) {
            AutomobileAssemblerBlockEntity assembler = (AutomobileAssemblerBlockEntity)blockEntity;
            assembler.dropParts();
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.EAST, Direction.WEST -> EAST_WEST;
            default -> NORTH_SOUTH;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)super.m_5573_(ctx).m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, POWERED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new AutomobileAssemblerBlockEntity(pos, state);
    }
}

