/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block.model;

import com.mojang.math.Vector3f;
import io.github.foundationgames.automobility.block.model.GeometryBuilder;
import io.github.foundationgames.automobility.block.model.SlopeUnbakedModel;
import io.github.foundationgames.automobility.platform.Platform;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SlopeBakedModel
implements BakedModel {
    public static Factory impl = SlopeBakedModel::new;
    private final Map<BlockState, TextureAtlasSprite> frameTexOverrides;
    @Nullable
    protected final TextureAtlasSprite plateInner;
    @Nullable
    protected final TextureAtlasSprite plateOuter;
    protected final ModelState settings;
    protected final SlopeUnbakedModel.Type type;
    private final TextureAtlasSprite frame;

    public SlopeBakedModel(TextureAtlasSprite frame, Map<BlockState, TextureAtlasSprite> frameTexOverrides, @Nullable TextureAtlasSprite plateInner, @Nullable TextureAtlasSprite plateOuter, ModelState settings, SlopeUnbakedModel.Type type) {
        this.frame = frame;
        this.frameTexOverrides = frameTexOverrides;
        this.plateInner = plateInner;
        this.plateOuter = plateOuter;
        this.settings = settings;
        this.type = type;
    }

    public TextureAtlasSprite getFrameSprite(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos) {
        if (level != null && pos != null) {
            BlockState blockBelow = level.m_8055_(pos.m_7495_());
            if (this.frameTexOverrides.containsKey(blockBelow)) {
                return this.frameTexOverrides.get(blockBelow);
            }
            if (!blockBelow.m_60795_() && blockBelow.m_60838_((BlockGetter)level, pos)) {
                return Minecraft.m_91087_().m_91289_().m_110910_(blockBelow).m_6160_();
            }
        }
        return this.frame;
    }

    public int getFrameColor(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos) {
        if (level != null && pos != null) {
            BlockState blockBelow = level.m_8055_(pos.m_7495_());
            BlockColor belowColor = Platform.get().blockColor(blockBelow);
            if (belowColor != null) {
                return belowColor.m_92566_(blockBelow, level, pos.m_7495_(), 0) | 0xFF000000;
            }
        }
        return -1;
    }

    public void buildSlopeGeometry(TextureAtlasSprite sprite, GeometryBuilder geo, int frameColor, boolean borderedLeft, boolean borderedRight) {
        float height;
        boolean steep = this.type == SlopeUnbakedModel.Type.STEEP;
        float f = height = steep ? 1.0f : 0.5f;
        float rise = steep ? 0.0f : (this.type == SlopeUnbakedModel.Type.TOP ? 0.5f : 0.0f);
        boolean top = true;
        if (this.plateOuter != null && this.plateInner != null) {
            top = false;
            this.plate(height, rise, !borderedLeft, !borderedRight, this.plateInner, this.plateOuter, geo);
        }
        this.rightTriPrism(height, rise, frameColor, top, sprite, geo);
        float invRH = 1.0f - (rise + height);
        geo.vertex(0.0f, rise + height, 1.0f, Direction.SOUTH, 0.0f, 0.0f, 1.0f, sprite, 0.0f, invRH, frameColor).vertex(0.0f, 0.0f, 1.0f, Direction.SOUTH, 0.0f, 0.0f, 1.0f, sprite, 0.0f, 1.0f, frameColor).vertex(1.0f, 0.0f, 1.0f, Direction.SOUTH, 0.0f, 0.0f, 1.0f, sprite, 1.0f, 1.0f, frameColor).vertex(1.0f, rise + height, 1.0f, Direction.SOUTH, 0.0f, 0.0f, 1.0f, sprite, 1.0f, invRH, frameColor).vertex(0.0f, 0.0f, 1.0f, Direction.DOWN, 0.0f, -1.0f, 0.0f, sprite, 0.0f, 0.0f, frameColor).vertex(0.0f, 0.0f, 0.0f, Direction.DOWN, 0.0f, -1.0f, 0.0f, sprite, 0.0f, 1.0f, frameColor).vertex(1.0f, 0.0f, 0.0f, Direction.DOWN, 0.0f, -1.0f, 0.0f, sprite, 1.0f, 1.0f, frameColor).vertex(1.0f, 0.0f, 1.0f, Direction.DOWN, 0.0f, -1.0f, 0.0f, sprite, 1.0f, 0.0f, frameColor);
        if (rise > 0.0f) {
            float invR = 1.0f - rise;
            geo.vertex(0.0f, rise, 0.0f, Direction.WEST, -1.0f, 0.0f, 0.0f, sprite, 0.0f, invR, frameColor).vertex(0.0f, 0.0f, 0.0f, Direction.WEST, -1.0f, 0.0f, 0.0f, sprite, 0.0f, 1.0f, frameColor).vertex(0.0f, 0.0f, 1.0f, Direction.WEST, -1.0f, 0.0f, 0.0f, sprite, 1.0f, 1.0f, frameColor).vertex(0.0f, rise, 1.0f, Direction.WEST, -1.0f, 0.0f, 0.0f, sprite, 1.0f, invR, frameColor).vertex(1.0f, rise, 1.0f, Direction.EAST, 1.0f, 0.0f, 0.0f, sprite, 1.0f, invR, frameColor).vertex(1.0f, 0.0f, 1.0f, Direction.EAST, 1.0f, 0.0f, 0.0f, sprite, 1.0f, 1.0f, frameColor).vertex(1.0f, 0.0f, 0.0f, Direction.EAST, 1.0f, 0.0f, 0.0f, sprite, 0.0f, 1.0f, frameColor).vertex(1.0f, rise, 0.0f, Direction.EAST, 1.0f, 0.0f, 0.0f, sprite, 0.0f, invR, frameColor).vertex(1.0f, rise, 0.0f, Direction.NORTH, 0.0f, 0.0f, 1.0f, sprite, 1.0f, invR, frameColor).vertex(1.0f, 0.0f, 0.0f, Direction.NORTH, 0.0f, 0.0f, 1.0f, sprite, 1.0f, 1.0f, frameColor).vertex(0.0f, 0.0f, 0.0f, Direction.NORTH, 0.0f, 0.0f, 1.0f, sprite, 0.0f, 1.0f, frameColor).vertex(0.0f, rise, 0.0f, Direction.NORTH, 0.0f, 0.0f, 1.0f, sprite, 0.0f, invR, frameColor);
        }
    }

    private void rightTriPrism(float height, float rise, int color, boolean top, TextureAtlasSprite sprite, GeometryBuilder geo) {
        float invR = 1.0f - rise;
        float invRH = 1.0f - (rise + height);
        Vector3f topNormal = new Vector3f(0.0f, 1.0f, -height);
        topNormal.m_122278_();
        geo.vertex(0.0f, rise + height, 1.0f, Direction.WEST, -1.0f, 0.0f, 0.0f, sprite, 1.0f, invRH, color).vertex(0.0f, rise, 0.0f, Direction.WEST, -1.0f, 0.0f, 0.0f, sprite, 0.0f, invR, color).vertex(0.0f, rise, 1.0f, Direction.WEST, -1.0f, 0.0f, 0.0f, sprite, 1.0f, invR, color).vertex(0.0f, rise + height, 1.0f, Direction.WEST, -1.0f, 0.0f, 0.0f, sprite, 1.0f, invRH, color).vertex(1.0f, rise + height, 1.0f, Direction.EAST, 1.0f, 0.0f, 0.0f, sprite, 0.0f, invRH, color).vertex(1.0f, rise + height, 1.0f, Direction.EAST, 1.0f, 0.0f, 0.0f, sprite, 0.0f, invRH, color).vertex(1.0f, rise, 1.0f, Direction.EAST, 1.0f, 0.0f, 0.0f, sprite, 0.0f, invR, color).vertex(1.0f, rise, 0.0f, Direction.EAST, 1.0f, 0.0f, 0.0f, sprite, 1.0f, invR, color);
        if (top) {
            geo.vertex(0.0f, rise, 0.0f, null, topNormal.m_122239_(), topNormal.m_122260_(), topNormal.m_122269_(), sprite, 1.0f, 1.0f, color).vertex(0.0f, rise + height, 1.0f, null, topNormal.m_122239_(), topNormal.m_122260_(), topNormal.m_122269_(), sprite, 1.0f, 0.0f, color).vertex(1.0f, rise + height, 1.0f, null, topNormal.m_122239_(), topNormal.m_122260_(), topNormal.m_122269_(), sprite, 0.0f, 0.0f, color).vertex(1.0f, rise, 0.0f, null, topNormal.m_122239_(), topNormal.m_122260_(), topNormal.m_122269_(), sprite, 0.0f, 1.0f, color);
        }
    }

    private void plate(float height, float rise, boolean left, boolean right, TextureAtlasSprite plateInner, TextureAtlasSprite plateOuter, GeometryBuilder geo) {
        Vector3f topNormal = new Vector3f(0.0f, 1.0f, -height);
        topNormal.m_122278_();
        Vector3f northNormal = new Vector3f(0.0f, -height, 1.0f);
        northNormal.m_122278_();
        Vector3f southNormal = new Vector3f(0.0f, height, 1.0f);
        southNormal.m_122278_();
        Vector3f topFaceOffset = topNormal.m_122281_();
        topFaceOffset.m_122261_(0.0625f);
        Vector3f onePxUp = southNormal.m_122281_();
        onePxUp.m_122278_();
        onePxUp.m_122261_(0.0625f);
        geo.vertex(right ? 0.9375f : 1.0f, 0.001f + rise + topFaceOffset.m_122260_() + onePxUp.m_122260_(), topFaceOffset.m_122269_() + onePxUp.m_122269_(), null, topNormal.m_122239_(), topNormal.m_122260_(), topNormal.m_122269_(), plateInner, right ? 0.0625f : 0.0f, 0.9375f).vertex(left ? 0.0625f : 0.0f, 0.001f + rise + topFaceOffset.m_122260_() + onePxUp.m_122260_(), topFaceOffset.m_122269_() + onePxUp.m_122269_(), null, topNormal.m_122239_(), topNormal.m_122260_(), topNormal.m_122269_(), plateInner, left ? 0.9375f : 1.0f, 0.9375f).vertex(left ? 0.0625f : 0.0f, 0.001f + rise + height + topFaceOffset.m_122260_() - onePxUp.m_122260_(), 1.0f + topFaceOffset.m_122269_() - onePxUp.m_122269_(), null, topNormal.m_122239_(), topNormal.m_122260_(), topNormal.m_122269_(), plateInner, left ? 0.9375f : 1.0f, 0.0625f).vertex(right ? 0.9375f : 1.0f, 0.001f + rise + height + topFaceOffset.m_122260_() - onePxUp.m_122260_(), 1.0f + topFaceOffset.m_122269_() - onePxUp.m_122269_(), null, topNormal.m_122239_(), topNormal.m_122260_(), topNormal.m_122269_(), plateInner, right ? 0.0625f : 0.0f, 0.0625f).vertex(1.0f, rise + topFaceOffset.m_122260_(), topFaceOffset.m_122269_(), null, topNormal.m_122239_(), topNormal.m_122260_(), topNormal.m_122269_(), plateOuter, 0.0f, 1.0f).vertex(0.0f, rise + topFaceOffset.m_122260_(), topFaceOffset.m_122269_(), null, topNormal.m_122239_(), topNormal.m_122260_(), topNormal.m_122269_(), plateOuter, 1.0f, 1.0f).vertex(0.0f, rise + height + topFaceOffset.m_122260_(), 1.0f + topFaceOffset.m_122269_(), null, topNormal.m_122239_(), topNormal.m_122260_(), topNormal.m_122269_(), plateOuter, 1.0f, 0.0f).vertex(1.0f, rise + height + topFaceOffset.m_122260_(), 1.0f + topFaceOffset.m_122269_(), null, topNormal.m_122239_(), topNormal.m_122260_(), topNormal.m_122269_(), plateOuter, 0.0f, 0.0f).vertex(1.0f, rise, 0.0f, null, northNormal.m_122239_(), northNormal.m_122260_(), northNormal.m_122269_(), plateOuter, 0.0f, 1.0f).vertex(0.0f, rise, 0.0f, null, northNormal.m_122239_(), northNormal.m_122260_(), northNormal.m_122269_(), plateOuter, 1.0f, 1.0f).vertex(0.0f, rise + topFaceOffset.m_122260_(), topFaceOffset.m_122269_(), null, northNormal.m_122239_(), northNormal.m_122260_(), northNormal.m_122269_(), plateOuter, 1.0f, 0.9375f).vertex(1.0f, rise + topFaceOffset.m_122260_(), topFaceOffset.m_122269_(), null, northNormal.m_122239_(), northNormal.m_122260_(), northNormal.m_122269_(), plateOuter, 0.0f, 0.9375f).vertex(1.0f, rise + height + topFaceOffset.m_122260_(), 1.0f + topFaceOffset.m_122269_(), null, southNormal.m_122239_(), southNormal.m_122260_(), southNormal.m_122269_(), plateOuter, 0.0f, 0.0f).vertex(0.0f, rise + height + topFaceOffset.m_122260_(), 1.0f + topFaceOffset.m_122269_(), null, southNormal.m_122239_(), southNormal.m_122260_(), southNormal.m_122269_(), plateOuter, 1.0f, 0.0f).vertex(0.0f, rise + height, 1.0f, null, southNormal.m_122239_(), southNormal.m_122260_(), southNormal.m_122269_(), plateOuter, 1.0f, 0.0625f).vertex(1.0f, rise + height, 1.0f, null, southNormal.m_122239_(), southNormal.m_122260_(), southNormal.m_122269_(), plateOuter, 0.0f, 0.0625f).vertex(1.0f, rise + height, 1.0f, null, 1.0f, 0.0f, 0.0f, plateOuter, 0.0f, 0.0f).vertex(1.0f, rise, 0.0f, null, 1.0f, 0.0f, 0.0f, plateOuter, 0.0f, 1.0f).vertex(1.0f, rise + topFaceOffset.m_122260_(), topFaceOffset.m_122269_(), null, 1.0f, 0.0f, 0.0f, plateOuter, 0.0625f, 1.0f).vertex(1.0f, rise + height + topFaceOffset.m_122260_(), 1.0f + topFaceOffset.m_122269_(), null, 1.0f, 0.0f, 0.0f, plateOuter, 0.0625f, 0.0f).vertex(0.0f, rise + height + topFaceOffset.m_122260_(), 1.0f + topFaceOffset.m_122269_(), null, -1.0f, 0.0f, 0.0f, plateOuter, 1.0f, 0.0f).vertex(0.0f, rise + topFaceOffset.m_122260_(), topFaceOffset.m_122269_(), null, -1.0f, 0.0f, 0.0f, plateOuter, 1.0f, 1.0f).vertex(0.0f, rise, 0.0f, null, -1.0f, 0.0f, 0.0f, plateOuter, 0.9375f, 1.0f).vertex(0.0f, rise + height, 1.0f, null, -1.0f, 0.0f, 0.0f, plateOuter, 0.9375f, 0.0f);
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState blockState, @Nullable Direction direction, RandomSource randomSource) {
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.getFrameSprite(null, null);
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public static interface Factory {
        public SlopeBakedModel create(TextureAtlasSprite var1, Map<BlockState, TextureAtlasSprite> var2, @Nullable TextureAtlasSprite var3, @Nullable TextureAtlasSprite var4, ModelState var5, SlopeUnbakedModel.Type var6);
    }
}

