/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.platform;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.foundationgames.automobility.platform.GlobalPlatformInstance;
import io.github.foundationgames.automobility.util.HexCons;
import io.github.foundationgames.automobility.util.TriCons;
import io.github.foundationgames.automobility.util.TriFunc;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface Platform {
    public static void init(Platform instance) {
        GlobalPlatformInstance.INSTANCE = instance;
    }

    public static Platform get() {
        if (GlobalPlatformInstance.INSTANCE == null) {
            throw new RuntimeException("Automobility's load order was disrupted!");
        }
        return GlobalPlatformInstance.INSTANCE;
    }

    public CreativeModeTab creativeTab(ResourceLocation var1, Supplier<ItemStack> var2);

    public void builtinItemRenderer(Item var1, HexCons<ItemStack, ItemTransforms.TransformType, PoseStack, MultiBufferSource, Integer, Integer> var2);

    public <T extends AbstractContainerMenu> MenuType<T> menuType(BiFunction<Integer, Inventory, T> var1);

    public <T extends AbstractContainerMenu, U extends Screen> void registerMenuScreen(MenuType<T> var1, TriFunc<T, Inventory, Component, U> var2);

    @Nullable
    public BlockColor blockColor(BlockState var1);

    public <T extends BlockEntity> BlockEntityType<T> blockEntity(BiFunction<BlockPos, BlockState, T> var1, Block ... var2);

    public <T extends BlockEntity> void blockEntityRenderer(BlockEntityType<T> var1, Function<BlockEntityRendererProvider.Context, BlockEntityRenderer<T>> var2);

    public void serverSendPacket(ServerPlayer var1, ResourceLocation var2, FriendlyByteBuf var3);

    public void clientSendPacket(ResourceLocation var1, FriendlyByteBuf var2);

    public void serverReceivePacket(ResourceLocation var1, TriCons<MinecraftServer, ServerPlayer, FriendlyByteBuf> var2);

    public void clientReceivePacket(ResourceLocation var1, BiConsumer<Minecraft, FriendlyByteBuf> var2);

    public <T extends Entity> EntityType<T> entityType(MobCategory var1, BiFunction<EntityType<?>, Level, T> var2, EntityDimensions var3, int var4, int var5);

    public <T extends Entity> void entityRenderer(EntityType<T> var1, Function<EntityRendererProvider.Context, EntityRenderer<T>> var2);

    public void modelLayer(ModelLayerLocation var1);

    public SimpleParticleType simpleParticleType(boolean var1);

    public boolean controllerAccel();

    public boolean controllerBrake();

    public boolean controllerDrift();

    public boolean inControllerMode();
}

