/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.recipe.AutoMechanicTableRecipe;
import io.github.foundationgames.automobility.screen.AutoMechanicTableScreenHandler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class AutoMechanicTableScreen
extends AbstractContainerScreen<AutoMechanicTableScreenHandler> {
    private static final ResourceLocation TEXTURE = Automobility.rl("textures/gui/container/auto_mechanic_table.png");
    private static final int RECIPE_BUTTON_SIZE = 17;
    private static final int RECIPE_PANEL_WIDTH = 85;
    private static final int RECIPE_PANEL_HEIGHT = 51;
    private static final int CATEGORY_BUTTON_WIDTH = 12;
    private static final int CATEGORY_BUTTON_HEIGHT = 15;
    private static final int CATEGORY_BUTTON_AREA_WIDTH = 91;
    private static final int SCROLL_BAR_WIDTH = 3;
    private static final int SCROLL_BAR_HEIGHT = 10;
    private static final int SCROLL_BAR_AREA_HEIGHT = 51;
    private long time = 0L;
    private int recipePanelX;
    private int recipePanelY;
    private int categoryButtonsX;
    private int categoryButtonsY;
    private int currentCategory = 0;
    private int recipeScroll = 0;
    private final List<ResourceLocation> orderedCategories = AutoMechanicTableScreen.createDefaultCategories();
    private final Map<ResourceLocation, List<RecipeEntry>> recipes = new HashMap<ResourceLocation, List<RecipeEntry>>();
    private FormattedCharSequence categoryTitle;

    public AutoMechanicTableScreen(AutoMechanicTableScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 209;
        this.f_97729_ = 8;
        for (int id = 0; id < handler.recipes.size(); ++id) {
            AutoMechanicTableRecipe recipe = handler.recipes.get(id);
            ResourceLocation category = recipe.getCategory();
            this.recipes.computeIfAbsent(category, cat -> new ArrayList());
            if (!this.orderedCategories.contains(category)) {
                this.orderedCategories.add(category);
            }
            this.recipes.get(category).add(new RecipeEntry(id, recipe));
        }
        this.f_97731_ = this.f_97736_ + 115;
    }

    private static List<ResourceLocation> createDefaultCategories() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        list.add(Automobility.rl("frames"));
        list.add(Automobility.rl("engines"));
        list.add(Automobility.rl("wheels"));
        return list;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.recipePanelX = this.f_97735_ + 76;
        this.recipePanelY = this.f_97736_ + 21;
        this.categoryButtonsX = this.f_97735_ + 75;
        this.categoryButtonsY = this.f_97736_ + 4;
        this.categoryTitle = this.createCategoryTitle(this.orderedCategories.get(0));
    }

    protected void m_181908_() {
        super.m_181908_();
        ++this.time;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6305_(matrices, mouseX, mouseY, delta);
        this.m_7025_(matrices, mouseX, mouseY);
    }

    private void preDraw() {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
    }

    protected void m_7286_(PoseStack matrices, float delta, int mouseX, int mouseY) {
        this.m_7333_(matrices);
        this.preDraw();
        this.m_93228_(matrices, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.drawCategoryBar(matrices, mouseX, mouseY);
        this.drawRecipes(matrices, mouseX, mouseY);
        this.drawMissingIngredients(matrices);
    }

    protected void m_7027_(PoseStack matrices, int mouseX, int mouseY) {
        super.m_7027_(matrices, mouseX, mouseY);
        int hoveredRecipe = this.getHoveredRecipe(mouseX, mouseY);
        if (hoveredRecipe >= 0) {
            this.m_6057_(matrices, ((AutoMechanicTableScreenHandler)this.f_97732_).recipes.get(hoveredRecipe).m_8043_(), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    private void changeCategory(int by) {
        this.currentCategory = Math.floorMod(this.currentCategory + by, this.orderedCategories.size());
        this.categoryTitle = this.createCategoryTitle(this.orderedCategories.get(this.currentCategory));
        this.recipeScroll = 0;
    }

    private FormattedCharSequence createCategoryTitle(ResourceLocation category) {
        String translated = I18n.m_118938_((String)("part_category." + category.m_135827_() + "." + category.m_135815_()), (Object[])new Object[0]);
        if (this.f_96547_.m_92895_(translated) > 64) {
            return Component.m_237113_((String)(this.f_96547_.m_92834_(translated, 57) + "...")).m_7532_();
        }
        return Component.m_237113_((String)this.f_96547_.m_92834_(translated, 64)).m_7532_();
    }

    private void buttonClicked() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int selectedCatButton = this.getHoveredCategoryButton((int)mouseX, (int)mouseY);
            if (selectedCatButton != 0) {
                this.changeCategory(selectedCatButton);
                this.buttonClicked();
                return true;
            }
            int recipe = this.getHoveredRecipe((int)mouseX, (int)mouseY);
            if (recipe >= 0) {
                this.selectRecipe(recipe);
                this.buttonClicked();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void selectRecipe(int id) {
        ((AutoMechanicTableScreenHandler)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, id);
        this.f_96541_.f_91072_.m_105208_(((AutoMechanicTableScreenHandler)this.f_97732_).f_38840_, id);
    }

    private int getMaxRecipeScroll() {
        return Math.max(0, Mth.m_14167_((float)((float)this.getRecipeList().size() / 5.0f)) - 3);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (amount != 0.0 && this.getHoveredRecipe((int)mouseX, (int)mouseY) >= -1) {
            this.recipeScroll += amount > 0.0 ? -1 : 1;
            this.recipeScroll = Mth.m_14045_((int)this.recipeScroll, (int)0, (int)this.getMaxRecipeScroll());
            return true;
        }
        return false;
    }

    protected final void drawMissingIngredient(PoseStack matrices, Ingredient ing, int x, int y) {
        GuiComponent.m_93172_((PoseStack)matrices, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)1174339584);
        ItemStack[] stacks = ing.m_43908_();
        this.f_96542_.m_115218_(stacks[Mth.m_14143_((float)((float)this.time / 30.0f)) % stacks.length], x, y);
        RenderSystem.m_69456_((int)516);
        GuiComponent.m_93172_((PoseStack)matrices, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)0x30FFFFFF);
        RenderSystem.m_69456_((int)515);
    }

    protected void drawMissingIngredients(PoseStack matrices) {
        SimpleContainer inputInv = ((AutoMechanicTableScreenHandler)this.f_97732_).inputInv;
        ArrayDeque<Ingredient> missingIngs = new ArrayDeque<Ingredient>(((AutoMechanicTableScreenHandler)this.f_97732_).missingIngredients);
        for (int i = 0; i < inputInv.m_6643_(); ++i) {
            if (missingIngs.size() <= 0) continue;
            int x = this.f_97735_ + 8 + i * 18;
            int y = this.f_97736_ + 88;
            if (!inputInv.m_8020_(i).m_41619_()) continue;
            this.drawMissingIngredient(matrices, missingIngs.removeFirst(), x, y);
        }
    }

    protected List<RecipeEntry> getRecipeList() {
        if (this.currentCategory < this.orderedCategories.size() && this.currentCategory >= 0) {
            return this.recipes.get(this.orderedCategories.get(this.currentCategory));
        }
        return Collections.emptyList();
    }

    protected int getHoveredCategoryButton(int mouseX, int mouseY) {
        if (mouseY > this.categoryButtonsY && mouseY < this.categoryButtonsY + 15) {
            int relX = mouseX - this.categoryButtonsX;
            if (relX < 0 || relX > 91) {
                return 0;
            }
            if (relX < 12) {
                return -1;
            }
            if (relX > 79) {
                return 1;
            }
        }
        return 0;
    }

    protected int getHoveredRecipe(int mouseX, int mouseY) {
        if (this.currentCategory < this.orderedCategories.size() && this.currentCategory >= 0 && (mouseX -= this.recipePanelX) >= 0 && mouseX < 85 && (mouseY -= this.recipePanelY) >= 0 && mouseY < 51) {
            int row = Mth.m_14143_((float)((float)mouseY / 17.0f));
            int col = Mth.m_14143_((float)((float)mouseX / 17.0f));
            if (row >= 0 && col >= 0) {
                int idx = 5 * (row + this.recipeScroll) + col;
                List<RecipeEntry> recipes = this.recipes.get(this.orderedCategories.get(this.currentCategory));
                if (idx < recipes.size()) {
                    return recipes.get(idx).id();
                }
                return -1;
            }
        }
        return -2;
    }

    protected void drawCategoryBar(PoseStack matrices, int mouseX, int mouseY) {
        int hoveredCatButton = this.getHoveredCategoryButton(mouseX, mouseY);
        this.preDraw();
        this.m_93228_(matrices, this.categoryButtonsX, this.categoryButtonsY, 176, 17 + (hoveredCatButton < 0 ? 15 : 0), 12, 15);
        this.m_93228_(matrices, this.categoryButtonsX + 79, this.categoryButtonsY, 188, 17 + (hoveredCatButton > 0 ? 15 : 0), 12, 15);
        if (this.categoryTitle != null) {
            GuiComponent.m_168749_((PoseStack)matrices, (Font)this.f_96547_, (FormattedCharSequence)this.categoryTitle, (int)(this.f_97735_ + 120), (int)(this.f_97736_ + 8), (int)0xFFFFFF);
        }
    }

    protected void drawRecipes(PoseStack matrices, int mouseX, int mouseY) {
        if (this.orderedCategories.size() > 0) {
            List<RecipeEntry> recipes = this.recipes.get(this.orderedCategories.get(this.currentCategory));
            for (int row = 0; row < 3; ++row) {
                int idx;
                for (int col = 0; col < 5 && (idx = 5 * this.recipeScroll + 5 * row + col) < recipes.size(); ++col) {
                    int x = col * 17 + this.recipePanelX;
                    int y = row * 17 + this.recipePanelY;
                    RecipeEntry entry = recipes.get(idx);
                    RecipeButtonState state = RecipeButtonState.DEFAULT;
                    if (((AutoMechanicTableScreenHandler)this.f_97732_).getSelectedRecipe().isPresent() && ((AutoMechanicTableScreenHandler)this.f_97732_).getSelectedRecipeId() == entry.id()) {
                        state = RecipeButtonState.SELECTED;
                    } else if (this.getHoveredRecipe(mouseX, mouseY) == entry.id()) {
                        state = RecipeButtonState.HOVERED;
                    }
                    this.drawRecipeEntry(entry, matrices, x, y, state);
                }
            }
        }
        this.preDraw();
        int maxScroll = this.getMaxRecipeScroll();
        int scrollBarX = this.f_97735_ + 162;
        int scrollBarY = this.f_97736_ + 21;
        if (maxScroll > 0) {
            scrollBarY += (int)(41.0f * ((float)this.recipeScroll / (float)maxScroll));
        }
        this.m_93228_(matrices, scrollBarX, scrollBarY, 227, 0, 3, 10);
    }

    protected void drawRecipeEntry(RecipeEntry entry, PoseStack matrices, int x, int y, RecipeButtonState state) {
        this.preDraw();
        this.m_93228_(matrices, x, y, 176 + state.ordinal() * 17, 0, 17, 17);
        ItemStack stack = entry.recipe.m_8043_();
        this.f_96542_.m_115218_(stack, x, y);
    }

    public record RecipeEntry(int id, AutoMechanicTableRecipe recipe) {
    }

    public static enum RecipeButtonState {
        DEFAULT,
        HOVERED,
        SELECTED;

    }
}

