/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.platform.Platform;
import io.github.foundationgames.automobility.util.AUtils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;

public final class AutomobileHud
extends Enum<AutomobileHud> {
    public static final List<ControlHint> CONTROL_HINTS;
    private static final /* synthetic */ AutomobileHud[] $VALUES;

    public static AutomobileHud[] values() {
        return (AutomobileHud[])$VALUES.clone();
    }

    public static AutomobileHud valueOf(String name) {
        return Enum.valueOf(AutomobileHud.class, name);
    }

    public static void render(PoseStack pose, Player player, AutomobileEntity auto, float tickDelta) {
        float alpha;
        AutomobileHud.renderSpeedometer(pose, auto);
        if (!Platform.get().inControllerMode() && (int)((alpha = Math.max(0.0f, auto.getStandStillTime() * 2.0f - 1.0f)) * 255.0f) > 0) {
            AutomobileHud.renderControlHints(pose, alpha);
        }
    }

    private static void renderSpeedometer(PoseStack pose, AutomobileEntity auto) {
        float speed = (float)auto.getEffectiveSpeed() * 20.0f;
        int color = 0xFFFFFF;
        if (auto.getBoostTimer() > 0) {
            color = 0xFF6F00;
        }
        if (auto.getTurboCharge() > 35) {
            color = 16771658;
        }
        if (auto.getTurboCharge() > 70) {
            color = 8251903;
        }
        if (auto.getTurboCharge() > 115) {
            color = 9465599;
        }
        GuiComponent.m_93243_((PoseStack)pose, (Font)Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)(AUtils.DEC_TWO_PLACES.format(speed) + " m/s")), (int)20, (int)20, (int)color);
    }

    private static void renderControlHints(PoseStack pose, float alpha) {
        int x = 20;
        int y = 50;
        Options options = Minecraft.m_91087_().f_91066_;
        Font font = Minecraft.m_91087_().f_91062_;
        for (ControlHint control : CONTROL_HINTS) {
            Component keyTxt = control.getKeybindText(options);
            int keyTxtWid = font.m_92852_((FormattedText)keyTxt);
            GuiComponent.m_93172_((PoseStack)pose, (int)x, (int)y, (int)(x + keyTxtWid + 6), (int)(y + 14), (int)((int)(alpha * 171.0f) << 24));
            int textColor = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
            GuiComponent.m_93243_((PoseStack)pose, (Font)font, (Component)keyTxt, (int)(x + 3), (int)(y + 3), (int)textColor);
            GuiComponent.m_93243_((PoseStack)pose, (Font)font, (Component)control.getText(), (int)(x + keyTxtWid + 9), (int)(y + 3), (int)textColor);
            y += 17;
        }
    }

    private static /* synthetic */ AutomobileHud[] $values() {
        return new AutomobileHud[0];
    }

    static {
        $VALUES = AutomobileHud.$values();
        CONTROL_HINTS = Lists.newArrayList((Object[])new ControlHint[]{new ControlHint("accelerate", options -> options.f_92085_), new ControlHint("brake", options -> options.f_92087_), new ControlHint("steer_left", options -> options.f_92086_), new ControlHint("steer_right", options -> options.f_92088_), new ControlHint("drift", options -> options.f_92089_)});
    }

    public record ControlHint(String name, Function<Options, KeyMapping> keybind) {
        public Component getText() {
            return Component.m_237115_((String)("automobile_control." + this.name));
        }

        public Component getKeybindText(Options options) {
            return this.keybind.apply(options).m_90863_();
        }
    }
}

