/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.common.entity.movement;

import com.abdelaziz.canary.common.block.BlockCountingSection;
import com.abdelaziz.canary.common.block.BlockStateFlags;
import com.abdelaziz.canary.common.shapes.VoxelShapeCaster;
import com.abdelaziz.canary.common.util.Pos;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChunkAwareBlockCollisionSweeper
extends AbstractIterator<VoxelShape> {
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    private final AABB box;
    private final VoxelShape shape;
    private final Level level;
    private final CollisionContext context;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private int chunkX;
    private int chunkYIndex;
    private int chunkZ;
    private int cStartX;
    private int cStartZ;
    private int cEndX;
    private int cEndZ;
    private int cX;
    private int cY;
    private int cZ;
    private int maxHitX;
    private int maxHitY;
    private int maxHitZ;
    private int maxIndex;
    private int index;
    private int cTotalSize;
    private int cIterated;
    private boolean sectionOversizedBlocks;
    private ChunkAccess cachedChunk;
    private LevelChunkSection cachedChunkSection;

    public ChunkAwareBlockCollisionSweeper(Level level, Entity entity, AABB box) {
        this.box = box;
        this.shape = Shapes.m_83064_((AABB)box);
        this.context = entity == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)entity);
        this.level = level;
        this.minX = Mth.m_14107_((double)(box.f_82288_ - 1.0E-7));
        this.maxX = Mth.m_14107_((double)(box.f_82291_ + 1.0E-7));
        this.minY = Mth.m_14045_((int)Mth.m_14107_((double)(box.f_82289_ - 1.0E-7)), (int)Pos.BlockCoord.getMinY((LevelHeightAccessor)this.level), (int)Pos.BlockCoord.getMaxYInclusive((LevelHeightAccessor)this.level));
        this.maxY = Mth.m_14045_((int)Mth.m_14107_((double)(box.f_82292_ + 1.0E-7)), (int)Pos.BlockCoord.getMinY((LevelHeightAccessor)this.level), (int)Pos.BlockCoord.getMaxYInclusive((LevelHeightAccessor)this.level));
        this.minZ = Mth.m_14107_((double)(box.f_82290_ - 1.0E-7));
        this.maxZ = Mth.m_14107_((double)(box.f_82293_ + 1.0E-7));
        this.maxHitX = Integer.MIN_VALUE;
        this.maxHitY = Integer.MIN_VALUE;
        this.maxHitZ = Integer.MIN_VALUE;
        this.maxIndex = Integer.MIN_VALUE;
        this.index = 0;
        this.chunkX = Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMin(this.minX));
        this.chunkZ = Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMin(this.minZ));
        this.cIterated = 0;
        this.cTotalSize = 0;
        --this.chunkX;
    }

    private static boolean canInteractWithBlock(BlockState state, int edgesHit) {
        return !(edgesHit == 1 && !state.m_60779_() || edgesHit == 2 && state.m_60734_() != Blocks.f_50110_);
    }

    private static VoxelShape getCollidedShape(AABB entityBox, VoxelShape entityShape, VoxelShape shape, int x, int y, int z) {
        if (shape == Shapes.m_83144_()) {
            return entityBox.m_82314_((double)x, (double)y, (double)z, (double)x + 1.0, (double)y + 1.0, (double)z + 1.0) ? shape.m_83216_((double)x, (double)y, (double)z) : null;
        }
        if (shape instanceof VoxelShapeCaster) {
            if (((VoxelShapeCaster)shape).intersects(entityBox, x, y, z)) {
                return shape.m_83216_((double)x, (double)y, (double)z);
            }
            return null;
        }
        if (Shapes.m_83157_((VoxelShape)(shape = shape.m_83216_((double)x, (double)y, (double)z)), (VoxelShape)entityShape, (BooleanOp)BooleanOp.f_82689_)) {
            return shape;
        }
        return null;
    }

    private static boolean hasChunkSectionOversizedBlocks(ChunkAccess chunk, int chunkY) {
        if (BlockStateFlags.ENABLED) {
            LevelChunkSection section = chunk.m_7103_()[chunkY];
            return section != null && ((BlockCountingSection)section).anyMatch(BlockStateFlags.OVERSIZED_SHAPE, true);
        }
        return true;
    }

    private static int expandMin(int coord) {
        return coord - 1;
    }

    private static int expandMax(int coord) {
        return coord + 1;
    }

    private boolean nextSection() {
        while (true) {
            if (this.cachedChunk != null && this.chunkYIndex < Pos.SectionYIndex.getMaxYSectionIndexInclusive((LevelHeightAccessor)this.level) && this.chunkYIndex < Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)this.level, ChunkAwareBlockCollisionSweeper.expandMax(this.maxY))) {
                ++this.chunkYIndex;
                this.cachedChunkSection = this.cachedChunk.m_7103_()[this.chunkYIndex];
            } else {
                this.chunkYIndex = Mth.m_14045_((int)Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)this.level, ChunkAwareBlockCollisionSweeper.expandMin(this.minY)), (int)Pos.SectionYIndex.getMinYSectionIndex((LevelHeightAccessor)this.level), (int)Pos.SectionYIndex.getMaxYSectionIndexInclusive((LevelHeightAccessor)this.level));
                if (this.chunkX < Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMax(this.maxX))) {
                    ++this.chunkX;
                } else {
                    this.chunkX = Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMin(this.minX));
                    if (this.chunkZ < Pos.ChunkCoord.fromBlockCoord(ChunkAwareBlockCollisionSweeper.expandMax(this.maxZ))) {
                        ++this.chunkZ;
                    } else {
                        return false;
                    }
                }
                BlockGetter view = this.level.m_7925_(this.chunkX, this.chunkZ);
                if (view instanceof ChunkAccess) {
                    this.cachedChunk = this.level.m_6522_(this.chunkX, this.chunkZ, ChunkStatus.f_62326_, false);
                    if (this.cachedChunk != null) {
                        this.cachedChunkSection = this.cachedChunk.m_7103_()[this.chunkYIndex];
                    }
                }
            }
            if (this.cachedChunk == null || this.cachedChunkSection == null || this.cachedChunkSection.m_188008_()) continue;
            this.sectionOversizedBlocks = ChunkAwareBlockCollisionSweeper.hasChunkSectionOversizedBlocks(this.cachedChunk, this.chunkYIndex);
            int sizeExtension = this.sectionOversizedBlocks ? 1 : 0;
            this.cEndX = Math.min(this.maxX + sizeExtension, Pos.BlockCoord.getMaxInSectionCoord(this.chunkX));
            int cEndY = Math.min(this.maxY + sizeExtension, Pos.BlockCoord.getMaxYInSectionIndex((LevelHeightAccessor)this.level, this.chunkYIndex));
            this.cEndZ = Math.min(this.maxZ + sizeExtension, Pos.BlockCoord.getMaxInSectionCoord(this.chunkZ));
            this.cStartX = Math.max(this.minX - sizeExtension, Pos.BlockCoord.getMinInSectionCoord(this.chunkX));
            int cStartY = Math.max(this.minY - sizeExtension, Pos.BlockCoord.getMinYInSectionIndex((LevelHeightAccessor)this.level, this.chunkYIndex));
            this.cStartZ = Math.max(this.minZ - sizeExtension, Pos.BlockCoord.getMinInSectionCoord(this.chunkZ));
            this.cX = this.cStartX;
            this.cY = cStartY;
            this.cZ = this.cStartZ;
            this.cTotalSize = (this.cEndX - this.cStartX + 1) * (cEndY - cStartY + 1) * (this.cEndZ - this.cStartZ + 1);
            if (this.cTotalSize != 0) break;
        }
        this.cIterated = 0;
        return true;
    }

    public VoxelShape computeNext() {
        while (this.cIterated < this.cTotalSize || this.nextSection()) {
            VoxelShape collidedShape;
            BlockState state;
            int edgesHit;
            ++this.cIterated;
            int x = this.cX;
            int y = this.cY++;
            int z = this.cZ;
            if (this.cX < this.cEndX) {
                ++this.cX;
            } else if (this.cZ < this.cEndZ) {
                this.cX = this.cStartX;
                ++this.cZ;
            } else {
                this.cX = this.cStartX;
                this.cZ = this.cStartZ;
            }
            if ((edgesHit = this.sectionOversizedBlocks ? (x < this.minX || x > this.maxX ? 1 : 0) + (y < this.minY || y > this.maxY ? 1 : 0) + (z < this.minZ || z > this.maxZ ? 1 : 0) : 0) == 3 || !ChunkAwareBlockCollisionSweeper.canInteractWithBlock(state = this.cachedChunkSection.m_62982_(x & 0xF, y & 0xF, z & 0xF), edgesHit)) continue;
            this.pos.m_122178_(x, y, z);
            VoxelShape collisionShape = state.m_60742_((BlockGetter)this.level, (BlockPos)this.pos, this.context);
            if (collisionShape == Shapes.m_83040_() || collisionShape == null || (collidedShape = ChunkAwareBlockCollisionSweeper.getCollidedShape(this.box, this.shape, collisionShape, x, y, z)) == null) continue;
            if (z >= this.maxHitZ && (z > this.maxHitZ || y >= this.maxHitY && (y > this.maxHitY || x > this.maxHitX))) {
                this.maxHitX = x;
                this.maxHitY = y;
                this.maxHitZ = z;
                this.maxIndex = this.index;
            }
            ++this.index;
            return collidedShape;
        }
        return (VoxelShape)this.endOfData();
    }

    public List<VoxelShape> collectAll() {
        ArrayList<VoxelShape> collisions = new ArrayList<VoxelShape>();
        while (this.hasNext()) {
            collisions.add((VoxelShape)this.next());
        }
        int collisionsSize = collisions.size();
        if (collisionsSize >= 2) {
            collisions.set(this.maxIndex, collisions.set(collisions.size() - 1, collisions.get(this.maxIndex)));
        }
        return collisions;
    }
}

