/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.world.player_chunk_tick;

import com.abdelaziz.canary.common.util.Pos;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntityAccess;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ChunkMap.class})
public abstract class ChunkMapMixin {
    @Shadow
    @Final
    private Int2ObjectMap<ChunkMap.TrackedEntity> f_140150_;
    @Shadow
    @Final
    ServerLevel f_140133_;
    @Shadow
    @Final
    private PlayerMap f_140149_;
    @Shadow
    @Final
    private ChunkMap.DistanceManager f_140145_;
    @Shadow
    int f_140126_;

    @Shadow
    protected abstract void m_183760_(ServerPlayer var1, MutableObject<ClientboundLevelChunkWithLightPacket> var2, LevelChunk var3);

    @Shadow
    protected abstract SectionPos m_140373_(ServerPlayer var1);

    @Overwrite
    public void m_140184_(ServerPlayer player) {
        boolean movedSections;
        for (ChunkMap.TrackedEntity tracker : this.f_140150_.values()) {
            if (tracker.f_140472_ == player) {
                tracker.m_140487_(this.f_140133_.m_6907_());
                continue;
            }
            tracker.m_140497_(player);
        }
        SectionPos oldPos = player.m_8965_();
        SectionPos newPos = SectionPos.m_235861_((EntityAccess)player);
        boolean isWatchingWorld = this.f_140149_.m_8262_(player);
        boolean doesNotGenerateChunks = this.m_140329_(player);
        boolean bl = movedSections = !newPos.equals((Object)oldPos);
        if (movedSections || isWatchingWorld != doesNotGenerateChunks) {
            this.m_140373_(player);
            if (!isWatchingWorld) {
                this.f_140145_.m_140828_(oldPos, player);
            }
            if (!doesNotGenerateChunks) {
                this.f_140145_.m_140802_(newPos, player);
            }
            if (!isWatchingWorld && doesNotGenerateChunks) {
                this.f_140149_.m_8256_(player);
            }
            if (isWatchingWorld && !doesNotGenerateChunks) {
                this.f_140149_.m_8258_(player);
            }
        } else {
            return;
        }
        long oldChunkPos = ChunkPos.m_45589_((int)oldPos.m_123341_(), (int)oldPos.m_123343_());
        long newChunkPos = ChunkPos.m_45589_((int)newPos.m_123341_(), (int)newPos.m_123343_());
        this.f_140149_.m_8245_(oldChunkPos, newChunkPos, player);
        if (player.f_19853_ == this.f_140133_) {
            this.sendChunks(oldPos, player);
        }
    }

    private void sendChunks(SectionPos oldPos, ServerPlayer player) {
        int newCenterX = Pos.ChunkCoord.fromBlockCoord(Mth.m_14107_((double)player.m_20185_()));
        int newCenterZ = Pos.ChunkCoord.fromBlockCoord(Mth.m_14107_((double)player.m_20189_()));
        int oldCenterX = oldPos.m_123170_();
        int oldCenterZ = oldPos.m_123222_();
        int watchRadius = this.f_140126_;
        int watchRadiusIncr = watchRadius + 1;
        int watchDiameter = watchRadius * 2;
        if (Math.abs(oldCenterX - newCenterX) <= watchDiameter && Math.abs(oldCenterZ - newCenterZ) <= watchDiameter) {
            int minX = Math.min(newCenterX, oldCenterX) - watchRadiusIncr;
            int minZ = Math.min(newCenterZ, oldCenterZ) - watchRadiusIncr;
            int maxX = Math.max(newCenterX, oldCenterX) + watchRadiusIncr;
            int maxZ = Math.max(newCenterZ, oldCenterZ) + watchRadiusIncr;
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    boolean isWithinOldRadius = ChunkMap.m_200878_((int)x, (int)z, (int)oldCenterX, (int)oldCenterZ, (int)watchRadius);
                    boolean isWithinNewRadius = ChunkMap.m_200878_((int)x, (int)z, (int)newCenterX, (int)newCenterZ, (int)watchRadius);
                    if (isWithinNewRadius && !isWithinOldRadius) {
                        this.startWatchingChunk(player, x, z);
                    }
                    if (!isWithinOldRadius || isWithinNewRadius) continue;
                    this.stopWatchingChunk(player, x, z);
                }
            }
        } else {
            int z;
            int x;
            for (x = oldCenterX - watchRadiusIncr; x <= oldCenterX + watchRadiusIncr; ++x) {
                for (z = oldCenterZ - watchRadiusIncr; z <= oldCenterZ + watchRadiusIncr; ++z) {
                    if (!ChunkMap.m_200878_((int)x, (int)z, (int)oldCenterX, (int)oldCenterZ, (int)watchRadius)) continue;
                    this.stopWatchingChunk(player, x, z);
                }
            }
            for (x = newCenterX - watchRadiusIncr; x <= newCenterX + watchRadiusIncr; ++x) {
                for (z = newCenterZ - watchRadiusIncr; z <= newCenterZ + watchRadiusIncr; ++z) {
                    if (!ChunkMap.m_200878_((int)x, (int)z, (int)newCenterX, (int)newCenterZ, (int)watchRadius)) continue;
                    this.startWatchingChunk(player, x, z);
                }
            }
        }
    }

    protected void startWatchingChunk(ServerPlayer player, int x, int z) {
        LevelChunk chunk;
        ChunkHolder holder = this.m_140327_(ChunkPos.m_45589_((int)x, (int)z));
        if (holder != null && (chunk = holder.m_140085_()) != null) {
            this.m_183760_(player, (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), chunk);
        }
    }

    protected void stopWatchingChunk(ServerPlayer player, int x, int z) {
        player.m_9088_(new ChunkPos(x, z));
    }

    @Shadow
    protected abstract boolean m_140329_(ServerPlayer var1);

    @Shadow
    protected abstract ChunkHolder m_140327_(long var1);
}

