/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.besr;

import com.communi.suggestu.scena.core.client.fluid.IClientFluidManager;
import com.communi.suggestu.scena.core.client.rendering.IRenderingManager;
import com.communi.suggestu.scena.core.client.rendering.type.IRenderTypeManager;
import com.communi.suggestu.scena.core.fluid.FluidInformation;
import com.communi.suggestu.scena.core.fluid.IFluidManager;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import java.util.function.Supplier;
import mod.chiselsandbits.api.block.storage.IStateEntryStorage;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.block.entities.BitStorageBlockEntity;
import mod.chiselsandbits.block.entities.storage.SimpleStateEntryStorage;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModelManager;
import mod.chiselsandbits.client.util.BlockInformationUtils;
import mod.chiselsandbits.client.util.FluidCuboidUtils;
import mod.chiselsandbits.utils.MultiStateSnapshotUtils;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class BitStorageBESR
implements BlockEntityRenderer<BitStorageBlockEntity> {
    private static final SimpleMaxSizedCache<CacheKey, IStateEntryStorage> STORAGE_CONTENTS_BLOB_CACHE = new SimpleMaxSizedCache(((Supplier<Long>)IClientConfiguration.getInstance().getBitStorageContentCacheSize())::get);

    public static void clearCache() {
        STORAGE_CONTENTS_BLOB_CACHE.clear();
    }

    public void render(BitStorageBlockEntity te, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.containsFluid()) {
            FluidInformation fluidStack = te.getFluid().get();
            RenderType.m_110506_().forEach(renderType -> {
                if (!IRenderTypeManager.getInstance().canRenderInType(fluidStack.fluid().m_76145_(), renderType)) {
                    return;
                }
                if (renderType == RenderType.m_110466_() && Minecraft.m_91085_()) {
                    renderType = Sheets.m_110792_();
                }
                VertexConsumer builder = buffer.m_6299_(renderType);
                float fullness = (float)fluidStack.amount() / (float)IFluidManager.getInstance().getBucketAmount();
                float heightFactor = Math.min(Math.max(0.0f, fullness), 1.0f);
                FluidCuboidUtils.renderScaledFluidCuboid(fluidStack, poseStack, builder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 15.0f, 15.0f * heightFactor, 15.0f);
            });
            return;
        }
        int bits = te.getBits();
        IBlockInformation blockInformation = te.getContainedBlockInformation();
        if (bits <= 0 || blockInformation == null) {
            return;
        }
        CacheKey cacheKey = new CacheKey(blockInformation, bits);
        IStateEntryStorage innerModelBlob = STORAGE_CONTENTS_BLOB_CACHE.get(cacheKey);
        if (innerModelBlob == null) {
            innerModelBlob = new SimpleStateEntryStorage();
            innerModelBlob.fillFromBottom(blockInformation, bits);
            STORAGE_CONTENTS_BLOB_CACHE.put(cacheKey, innerModelBlob);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.125, 0.125, 0.125);
        poseStack.m_85841_(0.75f, 0.75f, 0.75f);
        IStateEntryStorage finalInnerModelBlob = innerModelBlob;
        Set<RenderType> renderTypes = BlockInformationUtils.extractRenderTypes(Sets.newHashSet((Object[])new IBlockInformation[]{blockInformation}));
        renderTypes.forEach(renderType -> {
            ChiseledBlockBakedModel innerModel = ChiseledBlockBakedModelManager.getInstance().get(MultiStateSnapshotUtils.createFromStorage(finalInnerModelBlob), blockInformation, ChiselRenderType.fromLayer(renderType, te.containsFluid()), null, null, te.m_58899_(), (RenderType)renderType);
            if (!innerModel.isEmpty()) {
                float b;
                float g;
                float r;
                if (te.containsFluid()) {
                    r = (float)te.getFluid().map(arg_0 -> ((IClientFluidManager)IClientFluidManager.getInstance()).getFluidColor(arg_0)).map(color -> color >> 16 & 0xFF).orElse(255).intValue() / 255.0f;
                    g = (float)te.getFluid().map(arg_0 -> ((IClientFluidManager)IClientFluidManager.getInstance()).getFluidColor(arg_0)).map(color -> color >> 8 & 0xFF).orElse(255).intValue() / 255.0f;
                    b = (float)te.getFluid().map(arg_0 -> ((IClientFluidManager)IClientFluidManager.getInstance()).getFluidColor(arg_0)).map(color -> color & 0xFF).orElse(255).intValue() / 255.0f;
                } else {
                    int color2 = Minecraft.m_91087_().f_91041_.m_92676_(new ItemStack((ItemLike)blockInformation.getBlockState().m_60734_()), 0);
                    r = (float)(color2 >> 16 & 0xFF) / 255.0f;
                    g = (float)(color2 >> 8 & 0xFF) / 255.0f;
                    b = (float)(color2 & 0xFF) / 255.0f;
                }
                IRenderingManager.getInstance().renderModel(poseStack.m_85850_(), buffer.m_6299_(renderType), blockInformation.getBlockState(), (BakedModel)innerModel, r, g, b, combinedLightIn, combinedOverlayIn, renderType);
            }
        });
        poseStack.m_85849_();
    }

    private record CacheKey(IBlockInformation blockInformation, int bitCount) {
    }
}

