/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.girder;

import com.google.common.base.Predicates;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.girder.GirderBlock;
import com.simibubi.create.content.decoration.girder.GirderEncasedShaftBlock;
import com.simibubi.create.content.equipment.extendoGrip.ExtendoGripItem;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeMod;

public class GirderPlacementHelper
implements IPlacementHelper {
    @Override
    public Predicate<ItemStack> getItemPredicate() {
        return arg_0 -> AllBlocks.METAL_GIRDER.isIn(arg_0);
    }

    @Override
    public Predicate<BlockState> getStatePredicate() {
        return Predicates.or(arg_0 -> AllBlocks.METAL_GIRDER.has(arg_0), arg_0 -> AllBlocks.METAL_GIRDER_ENCASED_SHAFT.has(arg_0));
    }

    private boolean canExtendToward(BlockState state, Direction side) {
        Direction.Axis axis = side.m_122434_();
        if (state.m_60734_() instanceof GirderBlock) {
            boolean x = (Boolean)state.m_61143_((Property)GirderBlock.X);
            boolean z = (Boolean)state.m_61143_((Property)GirderBlock.Z);
            if (!x && !z) {
                return axis == Direction.Axis.Y;
            }
            if (x && z) {
                return true;
            }
            return axis == (x ? Direction.Axis.X : Direction.Axis.Z);
        }
        if (state.m_60734_() instanceof GirderEncasedShaftBlock) {
            return axis != Direction.Axis.Y && axis != state.m_61143_(GirderEncasedShaftBlock.HORIZONTAL_AXIS);
        }
        return false;
    }

    private int attachedPoles(Level world, BlockPos pos, Direction direction) {
        BlockPos checkPos = pos.m_121945_(direction);
        BlockState state = world.m_8055_(checkPos);
        int count = 0;
        while (this.canExtendToward(state, direction)) {
            ++count;
            checkPos = checkPos.m_121945_(direction);
            state = world.m_8055_(checkPos);
        }
        return count;
    }

    private BlockState withAxis(BlockState state, Direction.Axis axis) {
        if (state.m_60734_() instanceof GirderBlock) {
            return (BlockState)((BlockState)((BlockState)state.m_61124_((Property)GirderBlock.X, (Comparable)Boolean.valueOf(axis == Direction.Axis.X))).m_61124_((Property)GirderBlock.Z, (Comparable)Boolean.valueOf(axis == Direction.Axis.Z))).m_61124_(GirderBlock.AXIS, (Comparable)axis);
        }
        if (state.m_60734_() instanceof GirderEncasedShaftBlock && axis.m_122479_()) {
            return (BlockState)state.m_61124_(GirderEncasedShaftBlock.HORIZONTAL_AXIS, (Comparable)(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        return state;
    }

    @Override
    public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
        List<Direction> directions = IPlacementHelper.orderedByDistance(pos, ray.m_82450_(), (Direction dir) -> this.canExtendToward(state, (Direction)dir));
        for (Direction dir2 : directions) {
            BlockPos newPos;
            BlockState newState;
            int poles;
            AttributeInstance reach;
            int range = (Integer)AllConfigs.server().equipment.placementAssistRange.get();
            if (player != null && (reach = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get())) != null && reach.m_22109_(ExtendoGripItem.singleRangeAttributeModifier)) {
                range += 4;
            }
            if ((poles = this.attachedPoles(world, pos, dir2)) >= range || !(newState = world.m_8055_(newPos = pos.m_5484_(dir2, poles + 1))).m_60767_().m_76336_()) continue;
            return PlacementOffset.success((Vec3i)newPos, bState -> Block.m_49931_((BlockState)this.withAxis((BlockState)bState, dir2.m_122434_()), (LevelAccessor)world, (BlockPos)newPos));
        }
        return PlacementOffset.fail();
    }
}

