/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.instruction;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.instruction.TickingInstruction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.phys.Vec3;

public class EmitParticlesInstruction
extends TickingInstruction {
    private Vec3 anchor;
    private Emitter emitter;
    private float runsPerTick;

    public EmitParticlesInstruction(Vec3 anchor, Emitter emitter, float runsPerTick, int ticks) {
        super(false, ticks);
        this.anchor = anchor;
        this.emitter = emitter;
        this.runsPerTick = runsPerTick;
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        int runs = (int)this.runsPerTick;
        if (Create.RANDOM.nextFloat() < this.runsPerTick - (float)runs) {
            ++runs;
        }
        for (int i = 0; i < runs; ++i) {
            this.emitter.create(scene.getWorld(), this.anchor.f_82479_, this.anchor.f_82480_, this.anchor.f_82481_);
        }
    }

    @FunctionalInterface
    public static interface Emitter {
        public static <T extends ParticleOptions> Emitter simple(T data, Vec3 motion) {
            return (w, x, y, z) -> w.m_7106_(data, x, y, z, motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }

        public static <T extends ParticleOptions> Emitter withinBlockSpace(T data, Vec3 motion) {
            return (w, x, y, z) -> w.m_7106_(data, Math.floor(x) + (double)Create.RANDOM.nextFloat(), Math.floor(y) + (double)Create.RANDOM.nextFloat(), Math.floor(z) + (double)Create.RANDOM.nextFloat(), motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }

        public static ParticleEngine paticleManager() {
            return Minecraft.m_91087_().f_91061_;
        }

        public void create(PonderWorld var1, double var2, double var4, double var6);
    }
}

