/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.client.ChunkScreen;
import dev.ftb.mods.ftbchunks.data.ClaimResults;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import java.util.EnumMap;
import net.minecraft.network.FriendlyByteBuf;

public class ChunkChangeResponsePacket
extends BaseS2CMessage {
    private final int totalChunks;
    private final int changedChunks;
    private final EnumMap<ClaimResults, Integer> problems;

    public ChunkChangeResponsePacket(int totalChunks, int changedChunks, EnumMap<ClaimResults, Integer> problems) {
        this.totalChunks = totalChunks;
        this.changedChunks = changedChunks;
        this.problems = problems;
    }

    ChunkChangeResponsePacket(FriendlyByteBuf buf) {
        this.totalChunks = buf.m_130242_();
        this.changedChunks = buf.m_130242_();
        this.problems = new EnumMap(ClaimResults.class);
        int nProblems = buf.m_130242_();
        for (int i = 0; i < nProblems; ++i) {
            String name = buf.m_130136_(Short.MAX_VALUE);
            int count = buf.m_130242_();
            ClaimResults.forName(name).ifPresent(res -> this.problems.put((ClaimResults)res, count));
        }
    }

    public MessageType getType() {
        return FTBChunksNet.CHUNK_CHANGE_RESPONSE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.totalChunks);
        buf.m_130130_(this.changedChunks);
        buf.m_130130_(this.problems.size());
        this.problems.forEach((res, count) -> {
            buf.m_130070_(res.claimResultName());
            buf.m_130130_(count.intValue());
        });
    }

    public void handle(NetworkManager.PacketContext context) {
        ChunkScreen.notifyChunkUpdates(this.totalChunks, this.changedChunks, this.problems);
    }
}

