/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.ftb.mods.ftbessentials.FTBEssentials;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;

public class FTBEWorldData {
    private static final LevelResource FTBESSENTIALS_DIRECTORY = new LevelResource("ftbessentials");
    private static final String DATA_FILE = "data.snbt";
    public static FTBEWorldData instance;
    private final MinecraftServer server;
    private boolean needSave;
    public final Map<String, TeleportPos> warps;
    private final Map<UUID, Long> muteTimeouts;

    public FTBEWorldData(MinecraftServer s) {
        this.server = s;
        this.warps = new LinkedHashMap<String, TeleportPos>();
        this.muteTimeouts = new HashMap<UUID, Long>();
    }

    public Path mkdirs(String path) {
        Path dir = this.server.m_129843_(FTBESSENTIALS_DIRECTORY);
        if (!path.isEmpty()) {
            dir = dir.resolve(path);
        }
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not create FTB Essentials data directory: " + ex);
            }
        }
        return dir;
    }

    public void markDirty() {
        this.needSave = true;
    }

    public void saveNow() {
        if (this.needSave && SNBT.write((Path)this.mkdirs("").resolve(DATA_FILE), (CompoundTag)this.toNBT())) {
            this.needSave = false;
        }
    }

    public void load() {
        try {
            SNBTCompoundTag tag = SNBT.read((Path)this.mkdirs("").resolve(DATA_FILE));
            if (tag != null) {
                this.loadNBT(tag);
            }
        }
        catch (Exception ex) {
            FTBEssentials.LOGGER.error("Failed to load world data: " + ex);
            ex.printStackTrace();
        }
    }

    private SNBTCompoundTag toNBT() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        SNBTCompoundTag warpsTag = new SNBTCompoundTag();
        this.warps.forEach((key, value) -> warpsTag.m_128365_(key, (Tag)value.write()));
        tag.m_128365_("warps", (Tag)warpsTag);
        SNBTCompoundTag mutesTag = new SNBTCompoundTag();
        this.muteTimeouts.forEach((id, until) -> mutesTag.m_128356_(id.toString(), until.longValue()));
        tag.m_128365_("mute_timeouts", (Tag)mutesTag);
        return tag;
    }

    public void loadNBT(SNBTCompoundTag tag) {
        this.warps.clear();
        SNBTCompoundTag warpsTag = tag.getCompound("warps");
        for (String key : warpsTag.m_128431_()) {
            this.warps.put(key, new TeleportPos((CompoundTag)warpsTag.getCompound(key)));
        }
        this.muteTimeouts.clear();
        SNBTCompoundTag mutesTag = tag.getCompound("mute_timeouts");
        for (String key : mutesTag.m_128431_()) {
            this.muteTimeouts.put(UUID.fromString(key), mutesTag.m_128454_(key));
        }
    }

    public void tickMuteTimeouts(MinecraftServer server) {
        long now = System.currentTimeMillis();
        HashSet toExpire = new HashSet();
        this.muteTimeouts.forEach((id, expiry) -> {
            if (now >= expiry) {
                toExpire.add(id);
            }
        });
        toExpire.forEach(id -> {
            FTBEPlayerData data;
            ServerPlayer player = server.m_6846_().m_11259_(id);
            if (player != null) {
                player.m_5661_((Component)player.m_5446_().m_6881_().m_130946_(" is no longer muted"), false);
            }
            if ((data = FTBEPlayerData.get((Player)player)) != null) {
                data.muted = false;
            }
            this.muteTimeouts.remove(id);
            this.markDirty();
        });
    }

    public void setMuteTimeout(ServerPlayer player, long until) {
        if (until > 0L) {
            this.muteTimeouts.put(player.m_20148_(), until);
        } else {
            this.muteTimeouts.remove(player.m_20148_());
        }
        this.markDirty();
    }

    public Optional<Long> getMuteTimeout(ServerPlayer player) {
        return Optional.ofNullable(this.muteTimeouts.get(player.m_20148_()));
    }
}

