/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ConnectingModelBuilder
extends ModelBuilder<ConnectingModelBuilder> {
    protected final Map<String, Boolean> connectingTextures = new LinkedHashMap<String, Boolean>();
    private boolean shouldConnect = false;

    public ConnectingModelBuilder(ResourceLocation outputLocation, ExistingFileHelper existingFileHelper) {
        super(outputLocation, existingFileHelper);
    }

    public ConnectingModelBuilder connectToOtherBlocks() {
        this.shouldConnect = true;
        return this;
    }

    public ConnectingModelBuilder connectToOtherBlocks(boolean connect) {
        this.shouldConnect = connect;
        return this;
    }

    public ConnectingModelBuilder texture(String key, String texture, boolean isConnectingTexture) {
        if (isConnectingTexture && texture.charAt(0) == '#') {
            throw new IllegalArgumentException("Only textures can be 'connecting', references (starts with '#') cannot: " + texture);
        }
        super.texture(key, texture);
        this.connectingTextures.put(key, isConnectingTexture);
        return this;
    }

    public ConnectingModelBuilder texture(String key, ResourceLocation texture, boolean isConnectingTexture) {
        super.texture(key, texture);
        this.connectingTextures.put(key, isConnectingTexture);
        return this;
    }

    public ConnectingModelBuilder texture(String key, String texture) {
        super.texture(key, texture);
        this.connectingTextures.put(key, false);
        return this;
    }

    public ConnectingModelBuilder texture(String key, ResourceLocation texture) {
        super.texture(key, texture);
        this.connectingTextures.put(key, false);
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("loader", "rechiseled:connecting_model");
        if (this.shouldConnect) {
            json.addProperty("should_connect", Boolean.valueOf(true));
        }
        if (!this.textures.isEmpty() && !this.connectingTextures.isEmpty() && json.has("textures")) {
            JsonObject textures = json.remove("textures").getAsJsonObject();
            for (Map.Entry<String, Boolean> e : this.connectingTextures.entrySet()) {
                textures.remove(e.getKey());
                JsonObject textureJson = new JsonObject();
                textureJson.addProperty("location", (String)this.textures.get(e.getKey()));
                textureJson.addProperty("connecting", e.getValue());
                textures.add(e.getKey(), (JsonElement)textureJson);
            }
            json.add("model_textures", (JsonElement)textures);
        }
        return json;
    }
}

