/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc;

import com.mojang.realmsclient.dto.PlayerInfo;
import com.mojang.realmsclient.dto.RealmsServer;
import java.util.concurrent.atomic.AtomicReference;
import me.hypherionmc.simplerpc.SimpleRPCClient;
import me.hypherionmc.simplerpclib.RPCConstants;
import me.hypherionmc.simplerpclib.discord.RichPresenceVariables;
import me.hypherionmc.simplerpclib.integrations.known.KnownBiomeHelper;
import me.hypherionmc.simplerpclib.integrations.known.KnownDimensionHelper;
import me.hypherionmc.simplerpclib.integrations.known.KnownServerHelpers;
import me.hypherionmc.simplerpclib.integrations.launchers.LauncherAssets;
import me.hypherionmc.simplerpclib.util.APIUtils;
import me.hypherionmc.simplerpclib.util.MCTimeUtils;
import me.hypherionmc.simplerpclib.util.MinecraftUtilHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerStatusPinger;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class Utils
implements MinecraftUtilHandler {
    private final Minecraft mc = Minecraft.m_91087_();
    public static RealmsServer realmsServer;

    @Override
    public String parseVars(String input) {
        block11: {
            input = RichPresenceVariables.MCVER.resolve(input, SharedConstants.m_183709_().getName());
            input = RichPresenceVariables.PLAYER.resolve(input, this.mc.m_91094_().m_92546_());
            input = RichPresenceVariables.MODS.resolve(input, String.valueOf(SimpleRPCClient.sidedHandler.getModCount()));
            input = RichPresenceVariables.PLAYER_HEAD.resolve(input, RichPresenceVariables.PLAYER_HEAD.getDefaultVal().replace("{UUID}", this.mc.m_91094_().m_92545_()) + "?size=512");
            if (this.mc.f_91073_ != null) {
                input = RichPresenceVariables.WORLD.resolve(input, this.resolveWorldName((Level)this.mc.f_91073_));
                input = RichPresenceVariables.DIFFICULTY.resolve(input, this.mc.f_91073_.m_46791_().m_19033_().getString());
                input = this.mc.m_91092_() != null ? RichPresenceVariables.SAVENAME.resolve(input, this.mc.m_91092_().m_129910_().m_5462_()) : RichPresenceVariables.SAVENAME.resolve(input, "Server World");
                input = RichPresenceVariables.GAME_TIME.resolve(input, MCTimeUtils.format12(this.mc.f_91073_.m_46468_()));
                input = RichPresenceVariables.GAME_TIME24.resolve(input, MCTimeUtils.format24(this.mc.f_91073_.m_46468_()));
                input = RichPresenceVariables.DAY.resolve(input, String.valueOf(this.mc.f_91073_.m_8044_() / 24000L));
            }
            if (this.mc.f_91074_ != null) {
                input = RichPresenceVariables.POSITION.resolve(input, this.getBlockPosString(this.mc.f_91074_.m_20097_()));
                input = RichPresenceVariables.BIOME.resolve(input, this.resolveBiomeName(this.mc.f_91074_.m_20097_()));
                if (this.mc.f_91073_ != null) {
                    String weather = "Clear";
                    if (this.mc.f_91073_.m_46471_()) {
                        weather = "Raining/Snowing";
                    }
                    if (this.mc.f_91073_.m_46470_()) {
                        weather = "Thunderstorm";
                    }
                    input = RichPresenceVariables.WEATHER.resolve(input, weather);
                }
            }
            if (this.mc.m_91089_() != null && !this.mc.m_91294_()) {
                try {
                    ServerData serverData = this.mc.m_91089_();
                    input = RichPresenceVariables.SERVERIP.resolve(input, serverData.f_105363_);
                    input = RichPresenceVariables.SERVER.resolve(input, serverData.f_105363_.toLowerCase().replace(".", "_"));
                    input = RichPresenceVariables.SERVERNAME.resolve(input, KnownServerHelpers.isKnownServer(serverData.f_105363_) ? KnownServerHelpers.getKnownServer((String)serverData.f_105363_).severName : APIUtils.stringNN(serverData.f_105362_));
                    input = RichPresenceVariables.MOTD.resolve(input, serverData.f_105365_ != null ? serverData.f_105365_.getString() : RichPresenceVariables.MOTD.getDefaultVal());
                    input = RichPresenceVariables.SERVERICON.resolve(input, RichPresenceVariables.SERVERICON.getDefaultVal().replace("{serverurl}", serverData.f_105363_));
                    if (serverData.f_105364_ == null) {
                        ServerStatusPinger pinger = new ServerStatusPinger();
                        pinger.m_105459_(serverData, () -> {});
                    }
                    int online = this.mc.m_91403_().m_105142_() != null ? this.mc.m_91403_().m_105142_().size() : 0;
                    int maxOnline = Integer.parseInt(ChatFormatting.m_126649_((String)serverData.f_105364_.getString()).split("/")[1]);
                    input = RichPresenceVariables.PLAYERS.resolve(input, String.valueOf(online));
                    input = RichPresenceVariables.PLAYERS_EXCL.resolve(input, String.valueOf(online - 1));
                    input = RichPresenceVariables.MAXPLAYERS.resolve(input, String.valueOf(maxOnline));
                }
                catch (Exception e) {
                    if (!SimpleRPCClient.rpcCore.getClientConfig().general.debugging) break block11;
                    RPCConstants.logger.error(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        if (realmsServer != null && this.mc.m_91294_()) {
            input = RichPresenceVariables.REALM_NAME.resolve(input, realmsServer.m_87512_());
            input = RichPresenceVariables.REALM_DESCRIPTION.resolve(input, realmsServer.m_87494_());
            input = RichPresenceVariables.REALM_WORLD.resolve(input, Utils.realmsServer.f_87485_.name().toLowerCase());
            input = RichPresenceVariables.REALM_GAME.resolve(input, realmsServer.m_87517_());
            input = RichPresenceVariables.REALM_IMAGE.resolve(input, Utils.realmsServer.f_87489_);
            input = RichPresenceVariables.PLAYERS.resolve(input, String.valueOf(Utils.realmsServer.f_87480_.stream().filter(PlayerInfo::m_87461_).count()));
            input = RichPresenceVariables.MAXPLAYERS.resolve(input, "10");
        }
        if (SimpleRPCClient.rpcCore != null) {
            LauncherAssets launcherAssets = SimpleRPCClient.rpcCore.getLauncherAssets();
            input = RichPresenceVariables.LAUNCHER.resolve(input, StringUtils.capitalize((String)SimpleRPCClient.rpcCore.getLauncherType().toString().toLowerCase()));
            input = RichPresenceVariables.INSTANCE.resolve(input, launcherAssets != null ? launcherAssets.PACK_NAME : "Unknown Instance");
            input = RichPresenceVariables.LAUNCHER_NAME.resolve(input, SimpleRPCClient.rpcCore.getLauncherType().toString().toLowerCase().replace(" ", ""));
        }
        return input;
    }

    @Override
    public String getWorld() {
        if (this.mc.f_91073_.m_46472_() != null) {
            return this.mc.f_91073_.m_46472_().m_135782_().toString();
        }
        return "unknown_world";
    }

    private String resolveWorldName(Level world) {
        if (this.mc.f_91073_.m_46472_() != null) {
            String worldResKey = this.mc.f_91073_.m_46472_().m_135782_().m_135815_();
            return KnownDimensionHelper.tryKnownDimensions(worldResKey).equalsIgnoreCase(worldResKey) ? APIUtils.worldNameToReadable(worldResKey) : KnownDimensionHelper.tryKnownDimensions(worldResKey);
        }
        return "Unknown World";
    }

    private String resolveBiomeName(BlockPos pos) {
        AtomicReference<String> biome = new AtomicReference<String>("Unknown Biome");
        if (this.mc.f_91073_ != null) {
            this.mc.f_91073_.m_204166_(pos).m_203439_().ifLeft(b -> {
                ResourceLocation location = b.m_135782_();
                if (KnownBiomeHelper.tryKnownBiomes(location.m_135815_()).equalsIgnoreCase(location.m_135815_())) {
                    MutableComponent biomeName = Component.m_237115_((String)Util.m_137492_((String)"biome", (ResourceLocation)location));
                    biome.set(biomeName.getString());
                } else {
                    biome.set(KnownBiomeHelper.tryKnownBiomes(location.m_135815_()));
                }
            });
        }
        return biome.get();
    }

    public String getBlockPosString(BlockPos pos) {
        return "x: " + pos.m_123341_() + ", y:" + pos.m_123342_() + ", z:" + pos.m_123343_();
    }

    @Override
    public String getBiome() {
        AtomicReference<String> biome = new AtomicReference<String>("unknown");
        if (this.mc.f_91074_ != null && this.mc.f_91073_ != null) {
            BlockPos pos = this.mc.f_91074_.m_20097_();
            this.mc.f_91073_.m_204166_(pos).m_203439_().ifLeft(b -> biome.set(b.m_135782_().toString()));
        }
        return biome.get();
    }
}

