/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.hypherionmc.shaded.moonconfig.core.CommentedConfig;
import me.hypherionmc.shaded.moonconfig.core.Config;
import me.hypherionmc.shaded.moonconfig.core.UnmodifiableConfig;
import me.hypherionmc.shaded.moonconfig.core.conversion.ObjectConverter;
import me.hypherionmc.shaded.moonconfig.core.fields.RandomArrayList;
import me.hypherionmc.shaded.moonconfig.core.file.CommentedFileConfig;
import me.hypherionmc.simplerpclib.RPCConstants;
import me.hypherionmc.simplerpclib.config.ConfigWatcherController;

public class BaseRPCConfig {
    private final transient File configPath;
    private final transient String configName;

    public BaseRPCConfig(String configName, String langCode) {
        this(configName, langCode, "simple-rpc");
    }

    public BaseRPCConfig(String configName) {
        this(configName, "en_us", "simple-rpc");
    }

    public BaseRPCConfig(String configName, String langCode, String subFolder) {
        Config.setInsertionOrderPreserved(true);
        File configDir = new File("config" + (subFolder.isEmpty() ? "" : File.separator + subFolder));
        File configPath1 = new File(configDir + File.separator + configName + ".toml");
        String configName1 = configName;
        File translated = new File(configDir + File.separator + configName + "_" + langCode + ".toml");
        if (!langCode.isEmpty() && translated.exists()) {
            configPath1 = translated;
            configName1 = configName + "_" + langCode + ".toml";
        }
        this.configName = configName1;
        this.configPath = configPath1;
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
    }

    public void registerAndSetup(BaseRPCConfig config) {
        if (!this.configPath.exists() || this.configPath.length() < 2L) {
            this.appendAdditional();
            this.saveConfig(config);
            RPCConstants.logger.info("Saved config to {}", (Object)this.configPath.getAbsolutePath());
        } else {
            this.migrateConfig(config);
        }
        RPCConstants.logger.info("Loading config file from {}", (Object)this.configPath.getAbsolutePath());
        ConfigWatcherController.register_config(this);
        this.configReloaded();
    }

    public void saveConfig(BaseRPCConfig conf) {
        ObjectConverter converter = new ObjectConverter();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(this.configPath).build();
        converter.toConfig((Object)conf, (Config)config);
        config.save();
    }

    public <T> T loadConfig(Object conf) {
        ObjectConverter converter = new ObjectConverter();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(this.configPath).build();
        config.load();
        converter.toObject((UnmodifiableConfig)config, conf);
        return (T)conf;
    }

    private void migrateConfig(BaseRPCConfig conf) {
        int ver;
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(this.configPath).build();
        CommentedFileConfig newConfig = (CommentedFileConfig)CommentedFileConfig.builder(this.configPath).build();
        config.load();
        int n = ver = config.contains("general.version") ? config.getInt("general.version") : config.getIntOrElse("version", 0);
        if (ver != this.getConfigVersion()) {
            new ObjectConverter().toConfig((Object)conf, (Config)newConfig);
            this.updateConfigValues(config, newConfig, newConfig, "", ver);
            this.configPath.renameTo(new File(this.configPath.getAbsolutePath().replace(".toml", ".bak")));
            newConfig.save();
        }
        config.close();
        newConfig.close();
    }

    private void updateConfigValues(CommentedConfig oldConfig, CommentedConfig newConfig, CommentedConfig outputConfig, String subKey, int ver) {
        List entryConfig;
        newConfig.valueMap().forEach((key, value) -> {
            String finalKey = subKey + (subKey.isEmpty() ? "" : ".") + key;
            if (value instanceof CommentedConfig) {
                this.updateConfigValues(oldConfig, (CommentedConfig)((Object)value), outputConfig, finalKey, ver);
            } else {
                RandomArrayList<Object> val;
                RandomArrayList<Object> randomArrayList = val = oldConfig.contains(finalKey) ? oldConfig.get(finalKey) : value;
                if ((finalKey.contains("largeImageKey") || finalKey.contains("smallImageKey")) && !List.class.isAssignableFrom(val.getClass())) {
                    val = RandomArrayList.of(new Object[]{val});
                }
                outputConfig.set(finalKey, (Object)val);
            }
        });
        List commentedConfig = (List)newConfig.get("dimension_overrides.dimensions");
        if (commentedConfig != null && !commentedConfig.isEmpty()) {
            commentedConfig.forEach(dim -> {
                Object largeImg;
                if (!dim.contains("buttons")) {
                    dim.add("buttons", new ArrayList());
                }
                if (!List.class.isAssignableFrom((largeImg = dim.get("largeImageKey")).getClass())) {
                    dim.update("largeImageKey", RandomArrayList.of(new Object[]{largeImg}));
                } else {
                    dim.update("largeImageKey", largeImg);
                }
                Object smallImg = dim.get("smallImageKey");
                if (!List.class.isAssignableFrom(smallImg.getClass())) {
                    dim.update("smallImageKey", RandomArrayList.of(new Object[]{smallImg}));
                } else {
                    dim.update("smallImageKey", smallImg);
                }
            });
            outputConfig.set("dimension_overrides.dimensions", (Object)commentedConfig);
        }
        if ((entryConfig = (List)newConfig.get("entry")) != null && !entryConfig.isEmpty()) {
            entryConfig.forEach(dim -> {
                Object largeImg = dim.get("largeImageKey");
                if (!List.class.isAssignableFrom(largeImg.getClass())) {
                    dim.update("largeImageKey", RandomArrayList.of(new Object[]{largeImg}));
                } else {
                    dim.update("largeImageKey", largeImg);
                }
                Object smallImg = dim.get("smallImageKey");
                if (!List.class.isAssignableFrom(smallImg.getClass())) {
                    dim.update("smallImageKey", RandomArrayList.of(new Object[]{smallImg}));
                } else {
                    dim.update("smallImageKey", smallImg);
                }
            });
            outputConfig.set("entry", (Object)entryConfig);
        }
        if (outputConfig.contains("general.version")) {
            outputConfig.update("general.version", (Object)this.getConfigVersion());
        }
        if (outputConfig.contains("version")) {
            outputConfig.update("version", (Object)this.getConfigVersion());
        }
        if (oldConfig.contains("general.clientID")) {
            outputConfig.update("general.applicationID", oldConfig.get("general.clientID"));
        }
    }

    public File getConfigPath() {
        return this.configPath;
    }

    public void configReloaded() {
    }

    public void appendAdditional() {
    }

    public String getConfigName() {
        return this.configName;
    }

    public int getConfigVersion() {
        return 0;
    }
}

