/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.discord;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.hypherionmc.shaded.moonconfig.core.CommentedConfig;
import me.hypherionmc.shaded.moonconfig.core.UnmodifiableConfig;
import me.hypherionmc.shaded.moonconfig.core.conversion.ObjectConverter;
import me.hypherionmc.shaded.moonconfig.toml.TomlParser;
import me.hypherionmc.simplerpclib.config.ConfigMigrationHelper;
import me.hypherionmc.simplerpclib.configuration.ClientConfig;
import me.hypherionmc.simplerpclib.configuration.ReplayModConfig;
import me.hypherionmc.simplerpclib.configuration.ServerConfig;
import me.hypherionmc.simplerpclib.configuration.ServerEntriesConfig;
import me.hypherionmc.simplerpclib.discord.DiscordController;
import me.hypherionmc.simplerpclib.discord.RichPresenceEvents;
import me.hypherionmc.simplerpclib.integrations.launchers.LauncherAssets;
import me.hypherionmc.simplerpclib.integrations.launchers.LauncherUtils;
import me.hypherionmc.simplerpclib.util.CompatUtils;
import me.hypherionmc.simplerpclib.util.MinecraftUtilHandler;
import me.hypherionmc.simplerpclib.util.SafeRunUtils;

public class RichPresenceCore {
    public static final ScheduledExecutorService taskManager = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private final MinecraftUtilHandler utilHandler;
    private DiscordController discordController;
    private RichPresenceEvents events;
    private LauncherUtils.LauncherType launcherType;
    private LauncherAssets launcherAssets;
    private final SafeRunUtils safeRunner = new SafeRunUtils();
    private final String configPath;
    private String langCode;
    private long lastDiscordID = 0L;
    private ClientConfig clientConfig;
    private ServerEntriesConfig serverEntriesConfig;
    private static ServerConfig serverConfig;
    private static ReplayModConfig replayModConfig;

    public RichPresenceCore(MinecraftUtilHandler minecraftUtilHandler, String configPath, String langCode) {
        this.utilHandler = minecraftUtilHandler;
        this.configPath = configPath;
        this.langCode = langCode;
        this.safeRunner.executeSafely(ConfigMigrationHelper::checkAndMove, true);
        this.clientConfig = new ClientConfig(this);
        this.serverEntriesConfig = new ServerEntriesConfig(this);
        if (this.clientConfig != null) {
            this.discordController = new DiscordController(this.clientConfig);
            this.events = new RichPresenceEvents(this);
            this.lastDiscordID = this.clientConfig.general.discordid;
            this.launcherType = LauncherUtils.getLauncherType(this);
            this.launcherAssets = LauncherUtils.getLauncherInfo(this.launcherType);
            taskManager.scheduleAtFixedRate(() -> {
                if (this.events != null) {
                    this.events.updateRPC();
                }
            }, 1L, 2L, TimeUnit.SECONDS);
        }
        if (CompatUtils.hasReplay) {
            replayModConfig = new ReplayModConfig(this);
        }
    }

    private void reInit() {
        this.discordController.shutdownRichPresence();
        this.discordController = new DiscordController(this.clientConfig);
        this.lastDiscordID = this.clientConfig.general.discordid;
        this.events.updateRPC();
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public RichPresenceEvents getEvents() {
        return this.events;
    }

    public DiscordController getDiscordHandler() {
        return this.discordController;
    }

    public MinecraftUtilHandler getUtilHandler() {
        return this.utilHandler;
    }

    public String getLangCode() {
        return this.langCode;
    }

    public void setLangCode(String code) {
        if (code != null && !code.equalsIgnoreCase(this.langCode)) {
            try {
                this.langCode = code;
                this.clientConfig = new ClientConfig(this);
                this.reInit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public LauncherUtils.LauncherType getLauncherType() {
        return this.launcherType;
    }

    public LauncherAssets getLauncherAssets() {
        return this.launcherAssets;
    }

    public ServerEntriesConfig getServerEntriesConfig() {
        return this.serverEntriesConfig;
    }

    public ServerConfig getServerConfig() {
        return serverConfig;
    }

    public static void setServerConfig(String serverConfig) {
        CommentedConfig c = (CommentedConfig)new TomlParser().parse(serverConfig);
        ObjectConverter converter = new ObjectConverter();
        RichPresenceCore.serverConfig = new ServerConfig(false);
        converter.toObject((UnmodifiableConfig)c, RichPresenceCore.serverConfig);
    }

    public SafeRunUtils getSafeRunner() {
        return this.safeRunner;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        if (this.discordController != null && this.lastDiscordID != clientConfig.general.discordid) {
            this.reInit();
        }
        if (this.discordController != null) {
            this.getEvents().updateRPC();
        }
    }

    public void setServerEntriesConfig(ServerEntriesConfig serverEntriesConfig) {
        this.serverEntriesConfig = serverEntriesConfig;
        if (this.discordController != null) {
            this.getEvents().updateRPC();
        }
    }

    public ReplayModConfig getReplayModConfig() {
        return replayModConfig;
    }

    public void setReplayModConfig(ReplayModConfig replayModConfig) {
        RichPresenceCore.replayModConfig = replayModConfig;
    }
}

