/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;

public class RegistrationHandler {
    private static final Map<String, RegistrationHandler> REGISTRATION_HELPER_MAP = new HashMap<String, RegistrationHandler>();
    private final String modid;
    private final Map<Registries.Registry<?>, Map<ResourceLocation, Supplier<?>>> entryMap = new HashMap();
    private final Map<Registries.Registry<?>, List<Consumer<Helper<?>>>> callbacks = new HashMap();
    private final Set<Registries.Registry<?>> encounteredEvents = new HashSet();

    public static synchronized RegistrationHandler get(String modid) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String activeMod = ModLoadingContext.get().getActiveNamespace();
        if (activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge")) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '" + ModLoadingContext.get().getActiveContainer().getModInfo().getDisplayName() + "' is requesting registration helper for different modid '" + modid + "'!");
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is requesting registration helper for modid '" + modid + "'!");
        }
        return REGISTRATION_HELPER_MAP.computeIfAbsent(modid, RegistrationHandler::new);
    }

    private RegistrationHandler(String modid) {
        this.modid = modid;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::handleRegisterEvent);
    }

    public void registerBlock(String identifier, Supplier<Block> block) {
        this.addEntry(Registries.BLOCKS, identifier, block);
    }

    public void registerBlock(String identifier, Block block) {
        this.addEntry(Registries.BLOCKS, identifier, () -> block);
    }

    public void registerBlockOverride(String namespace, String identifier, Supplier<Block> block) {
        this.addEntry(Registries.BLOCKS, namespace, identifier, block);
    }

    public void registerBlockOverride(String namespace, String identifier, Block block) {
        this.addEntry(Registries.BLOCKS, namespace, identifier, () -> block);
    }

    public void registerBlockCallback(Consumer<Helper<Block>> callback) {
        this.addCallback(Registries.BLOCKS, callback);
    }

    public void registerFluid(String identifier, Supplier<Fluid> fluid) {
        this.addEntry(Registries.FLUIDS, identifier, fluid);
    }

    public void registerFluid(String identifier, Fluid fluid) {
        this.addEntry(Registries.FLUIDS, identifier, () -> fluid);
    }

    public void registerFluidOverride(String namespace, String identifier, Supplier<Fluid> fluid) {
        this.addEntry(Registries.FLUIDS, namespace, identifier, fluid);
    }

    public void registerFluidOverride(String namespace, String identifier, Fluid fluid) {
        this.addEntry(Registries.FLUIDS, namespace, identifier, () -> fluid);
    }

    public void registerFluidCallback(Consumer<Helper<Fluid>> callback) {
        this.addCallback(Registries.FLUIDS, callback);
    }

    public void registerItem(String identifier, Supplier<Item> item) {
        this.addEntry(Registries.ITEMS, identifier, item);
    }

    public void registerItem(String identifier, Item item) {
        this.addEntry(Registries.ITEMS, identifier, () -> item);
    }

    public void registerItemOverride(String namespace, String identifier, Supplier<Item> item) {
        this.addEntry(Registries.ITEMS, namespace, identifier, item);
    }

    public void registerItemOverride(String namespace, String identifier, Item item) {
        this.addEntry(Registries.ITEMS, namespace, identifier, () -> item);
    }

    public void registerItemCallback(Consumer<Helper<Item>> callback) {
        this.addCallback(Registries.ITEMS, callback);
    }

    public void registerMobEffect(String identifier, Supplier<MobEffect> effect) {
        this.addEntry(Registries.MOB_EFFECTS, identifier, effect);
    }

    public void registerMobEffect(String identifier, MobEffect effect) {
        this.addEntry(Registries.MOB_EFFECTS, identifier, () -> effect);
    }

    public void registerMobEffectOverride(String namespace, String identifier, Supplier<MobEffect> effect) {
        this.addEntry(Registries.MOB_EFFECTS, namespace, identifier, effect);
    }

    public void registerMobEffectOverride(String namespace, String identifier, MobEffect effect) {
        this.addEntry(Registries.MOB_EFFECTS, namespace, identifier, () -> effect);
    }

    public void registerMobEffectCallback(Consumer<Helper<MobEffect>> callback) {
        this.addCallback(Registries.MOB_EFFECTS, callback);
    }

    public void registerSoundEvent(String identifier, Supplier<SoundEvent> sound) {
        this.addEntry(Registries.SOUND_EVENTS, identifier, sound);
    }

    public void registerSoundEvent(String identifier, SoundEvent sound) {
        this.addEntry(Registries.SOUND_EVENTS, identifier, () -> sound);
    }

    public void registerSoundEventOverride(String namespace, String identifier, Supplier<SoundEvent> sound) {
        this.addEntry(Registries.SOUND_EVENTS, namespace, identifier, sound);
    }

    public void registerSoundEventOverride(String namespace, String identifier, SoundEvent sound) {
        this.addEntry(Registries.SOUND_EVENTS, namespace, identifier, () -> sound);
    }

    public void registerSoundEventCallback(Consumer<Helper<SoundEvent>> callback) {
        this.addCallback(Registries.SOUND_EVENTS, callback);
    }

    public void registerPotion(String identifier, Supplier<Potion> potion) {
        this.addEntry(Registries.POTIONS, identifier, potion);
    }

    public void registerPotion(String identifier, Potion potion) {
        this.addEntry(Registries.POTIONS, identifier, () -> potion);
    }

    public void registerPotionOverride(String namespace, String identifier, Supplier<Potion> potion) {
        this.addEntry(Registries.POTIONS, namespace, identifier, potion);
    }

    public void registerPotionOverride(String namespace, String identifier, Potion potion) {
        this.addEntry(Registries.POTIONS, namespace, identifier, () -> potion);
    }

    public void registerPotionCallback(Consumer<Helper<Potion>> callback) {
        this.addCallback(Registries.POTIONS, callback);
    }

    public void registerEnchantment(String identifier, Supplier<Enchantment> enchantment) {
        this.addEntry(Registries.ENCHANTMENTS, identifier, enchantment);
    }

    public void registerEnchantment(String identifier, Enchantment enchantment) {
        this.addEntry(Registries.ENCHANTMENTS, identifier, () -> enchantment);
    }

    public void registerEnchantmentOverride(String namespace, String identifier, Supplier<Enchantment> enchantment) {
        this.addEntry(Registries.ENCHANTMENTS, namespace, identifier, enchantment);
    }

    public void registerEnchantmentOverride(String namespace, String identifier, Enchantment enchantment) {
        this.addEntry(Registries.ENCHANTMENTS, namespace, identifier, () -> enchantment);
    }

    public void registerEnchantmentCallback(Consumer<Helper<Enchantment>> callback) {
        this.addCallback(Registries.ENCHANTMENTS, callback);
    }

    public void registerEntityType(String identifier, Supplier<EntityType<?>> entityType) {
        this.addEntry(Registries.ENTITY_TYPES, identifier, entityType);
    }

    public void registerEntityType(String identifier, EntityType<?> entityType) {
        this.addEntry(Registries.ENTITY_TYPES, identifier, () -> entityType);
    }

    public void registerEntityTypeOverride(String namespace, String identifier, Supplier<EntityType<?>> entityType) {
        this.addEntry(Registries.ENTITY_TYPES, namespace, identifier, entityType);
    }

    public void registerEntityTypeOverride(String namespace, String identifier, EntityType<?> entityType) {
        this.addEntry(Registries.ENTITY_TYPES, namespace, identifier, () -> entityType);
    }

    public void registerEntityTypeCallback(Consumer<Helper<EntityType<?>>> callback) {
        this.addCallback(Registries.ENTITY_TYPES, callback);
    }

    public void registerBlockEntityType(String identifier, Supplier<BlockEntityType<?>> blockEntityType) {
        this.addEntry(Registries.BLOCK_ENTITY_TYPES, identifier, blockEntityType);
    }

    public void registerBlockEntityType(String identifier, BlockEntityType<?> blockEntityType) {
        this.addEntry(Registries.BLOCK_ENTITY_TYPES, identifier, () -> blockEntityType);
    }

    public void registerBlockEntityTypeOverride(String namespace, String identifier, Supplier<BlockEntityType<?>> blockEntityType) {
        this.addEntry(Registries.BLOCK_ENTITY_TYPES, namespace, identifier, blockEntityType);
    }

    public void registerBlockEntityTypeOverride(String namespace, String identifier, BlockEntityType<?> blockEntityType) {
        this.addEntry(Registries.BLOCK_ENTITY_TYPES, namespace, identifier, () -> blockEntityType);
    }

    public void registerBlockEntityTypeCallback(Consumer<Helper<BlockEntityType<?>>> callback) {
        this.addCallback(Registries.BLOCK_ENTITY_TYPES, callback);
    }

    public void registerParticleType(String identifier, Supplier<ParticleType<?>> particleType) {
        this.addEntry(Registries.PARTICLE_TYPES, identifier, particleType);
    }

    public void registerParticleType(String identifier, ParticleType<?> particleType) {
        this.addEntry(Registries.PARTICLE_TYPES, identifier, () -> particleType);
    }

    public void registerParticleTypeOverride(String namespace, String identifier, Supplier<ParticleType<?>> particleType) {
        this.addEntry(Registries.PARTICLE_TYPES, namespace, identifier, particleType);
    }

    public void registerParticleTypeOverride(String namespace, String identifier, ParticleType<?> particleType) {
        this.addEntry(Registries.PARTICLE_TYPES, namespace, identifier, () -> particleType);
    }

    public void registerParticleTypeCallback(Consumer<Helper<ParticleType<?>>> callback) {
        this.addCallback(Registries.PARTICLE_TYPES, callback);
    }

    public void registerMenuType(String identifier, Supplier<MenuType<?>> menuType) {
        this.addEntry(Registries.MENU_TYPES, identifier, menuType);
    }

    public void registerMenuType(String identifier, MenuType<?> menuType) {
        this.addEntry(Registries.MENU_TYPES, identifier, () -> menuType);
    }

    public void registerMenuTypeOverride(String namespace, String identifier, Supplier<MenuType<?>> menuType) {
        this.addEntry(Registries.MENU_TYPES, namespace, identifier, menuType);
    }

    public void registerMenuTypeOverride(String namespace, String identifier, MenuType<?> menuType) {
        this.addEntry(Registries.MENU_TYPES, namespace, identifier, () -> menuType);
    }

    public void registerMenuTypeCallback(Consumer<Helper<MenuType<?>>> callback) {
        this.addCallback(Registries.MENU_TYPES, callback);
    }

    public void registerPaintingVariant(String identifier, Supplier<PaintingVariant> paintingVariant) {
        this.addEntry(Registries.PAINTING_VARIANTS, identifier, paintingVariant);
    }

    public void registerPaintingVariant(String identifier, PaintingVariant paintingVariant) {
        this.addEntry(Registries.PAINTING_VARIANTS, identifier, () -> paintingVariant);
    }

    public void registerPaintingVariantOverride(String namespace, String identifier, Supplier<PaintingVariant> paintingVariant) {
        this.addEntry(Registries.PAINTING_VARIANTS, namespace, identifier, paintingVariant);
    }

    public void registerPaintingVariantOverride(String namespace, String identifier, PaintingVariant paintingVariant) {
        this.addEntry(Registries.PAINTING_VARIANTS, namespace, identifier, () -> paintingVariant);
    }

    public void registerPaintingVariantCallback(Consumer<Helper<PaintingVariant>> callback) {
        this.addCallback(Registries.PAINTING_VARIANTS, callback);
    }

    public void registerRecipeType(String identifier, Supplier<RecipeType<?>> recipeType) {
        this.addEntry(Registries.RECIPE_TYPES, identifier, recipeType);
    }

    public void registerRecipeType(String identifier, RecipeType<?> recipeType) {
        this.addEntry(Registries.RECIPE_TYPES, identifier, () -> recipeType);
    }

    public void registerRecipeTypeOverride(String namespace, String identifier, Supplier<RecipeType<?>> recipeType) {
        this.addEntry(Registries.RECIPE_TYPES, namespace, identifier, recipeType);
    }

    public void registerRecipeTypeOverride(String namespace, String identifier, RecipeType<?> recipeType) {
        this.addEntry(Registries.RECIPE_TYPES, namespace, identifier, () -> recipeType);
    }

    public void registerRecipeTypeCallback(Consumer<Helper<RecipeType<?>>> callback) {
        this.addCallback(Registries.RECIPE_TYPES, callback);
    }

    public void registerRecipeSerializer(String identifier, Supplier<RecipeSerializer<?>> recipeSerializer) {
        this.addEntry(Registries.RECIPE_SERIALIZERS, identifier, recipeSerializer);
    }

    public void registerRecipeSerializer(String identifier, RecipeSerializer<?> recipeSerializer) {
        this.addEntry(Registries.RECIPE_SERIALIZERS, identifier, () -> recipeSerializer);
    }

    public void registerRecipeSerializerOverride(String namespace, String identifier, Supplier<RecipeSerializer<?>> recipeSerializer) {
        this.addEntry(Registries.RECIPE_SERIALIZERS, namespace, identifier, recipeSerializer);
    }

    public void registerRecipeSerializerOverride(String namespace, String identifier, RecipeSerializer<?> recipeSerializer) {
        this.addEntry(Registries.RECIPE_SERIALIZERS, namespace, identifier, () -> recipeSerializer);
    }

    public void registerRecipeSerializerCallback(Consumer<Helper<RecipeSerializer<?>>> callback) {
        this.addCallback(Registries.RECIPE_SERIALIZERS, callback);
    }

    public void registerAttribute(String identifier, Supplier<Attribute> attribute) {
        this.addEntry(Registries.ATTRIBUTES, identifier, attribute);
    }

    public void registerAttribute(String identifier, Attribute attribute) {
        this.addEntry(Registries.ATTRIBUTES, identifier, () -> attribute);
    }

    public void registerAttributeOverride(String namespace, String identifier, Supplier<Attribute> attribute) {
        this.addEntry(Registries.ATTRIBUTES, namespace, identifier, attribute);
    }

    public void registerAttributeOverride(String namespace, String identifier, Attribute attribute) {
        this.addEntry(Registries.ATTRIBUTES, namespace, identifier, () -> attribute);
    }

    public void registerAttributeCallback(Consumer<Helper<Attribute>> callback) {
        this.addCallback(Registries.ATTRIBUTES, callback);
    }

    public void registerStatType(String identifier, Supplier<StatType<?>> statType) {
        this.addEntry(Registries.STAT_TYPES, identifier, statType);
    }

    public void registerStatType(String identifier, StatType<?> statType) {
        this.addEntry(Registries.STAT_TYPES, identifier, () -> statType);
    }

    public void registerStatTypeOverride(String namespace, String identifier, Supplier<StatType<?>> statType) {
        this.addEntry(Registries.STAT_TYPES, namespace, identifier, statType);
    }

    public void registerStatTypeOverride(String namespace, String identifier, StatType<?> statType) {
        this.addEntry(Registries.STAT_TYPES, namespace, identifier, () -> statType);
    }

    public void registerStatTypeCallback(Consumer<Helper<StatType<?>>> callback) {
        this.addCallback(Registries.STAT_TYPES, callback);
    }

    public void registerConditionSerializer(String identifier, Supplier<IConditionSerializer<?>> recipeSerializer) {
        this.addEntry(Registries.RECIPE_CONDITION_SERIALIZERS, identifier, recipeSerializer);
    }

    public void registerConditionSerializer(String identifier, IConditionSerializer<?> recipeSerializer) {
        this.addEntry(Registries.RECIPE_CONDITION_SERIALIZERS, identifier, () -> recipeSerializer);
    }

    public void registerConditionSerializerOverride(String namespace, String identifier, Supplier<IConditionSerializer<?>> recipeSerializer) {
        this.addEntry(Registries.RECIPE_CONDITION_SERIALIZERS, namespace, identifier, recipeSerializer);
    }

    public void registerConditionSerializerOverride(String namespace, String identifier, IConditionSerializer<?> recipeSerializer) {
        this.addEntry(Registries.RECIPE_CONDITION_SERIALIZERS, namespace, identifier, () -> recipeSerializer);
    }

    public void registerConditionSerializerCallback(Consumer<Helper<IConditionSerializer<?>>> callback) {
        this.addCallback(Registries.RECIPE_CONDITION_SERIALIZERS, callback);
    }

    public void registerResourceConditionSerializer(String identifier, Supplier<ResourceConditionSerializer<?>> conditionSerializer) {
        this.registerConditionSerializer(identifier, () -> ResourceConditionSerializer.createForgeConditionSerializer(new ResourceLocation(this.modid, identifier), (ResourceConditionSerializer)conditionSerializer.get()));
    }

    public void registerResourceConditionSerializer(String identifier, ResourceConditionSerializer<?> conditionSerializer) {
        this.registerConditionSerializer(identifier, () -> ResourceConditionSerializer.createForgeConditionSerializer(new ResourceLocation(this.modid, identifier), conditionSerializer));
    }

    public void registerResourceConditionSerializerOverride(String namespace, String identifier, Supplier<ResourceConditionSerializer<?>> conditionSerializer) {
        this.registerConditionSerializerOverride(namespace, identifier, () -> ResourceConditionSerializer.createForgeConditionSerializer(new ResourceLocation(namespace, identifier), (ResourceConditionSerializer)conditionSerializer.get()));
    }

    public void registerResourceConditionSerializerOverride(String namespace, String identifier, ResourceConditionSerializer<?> conditionSerializer) {
        this.registerConditionSerializerOverride(namespace, identifier, () -> ResourceConditionSerializer.createForgeConditionSerializer(new ResourceLocation(namespace, identifier), conditionSerializer));
    }

    public void registerResourceConditionSerializerCallback(Consumer<Helper<ResourceConditionSerializer<?>>> callback) {
        this.registerConditionSerializerCallback(helper -> callback.accept(new Helper<ResourceConditionSerializer<?>>(null, (Helper)helper){
            final /* synthetic */ Helper val$helper;
            {
                this.val$helper = helper;
                super(registry);
            }

            @Override
            public <X extends ResourceConditionSerializer<?>> X register(String identifier, X object) {
                this.val$helper.register(identifier, ResourceConditionSerializer.createForgeConditionSerializer(new ResourceLocation(RegistrationHandler.this.modid, identifier), object));
                return object;
            }

            @Override
            public <X extends ResourceConditionSerializer<?>> X registerOverride(String namespace, String identifier, X object) {
                this.val$helper.register(namespace, identifier, ResourceConditionSerializer.createForgeConditionSerializer(new ResourceLocation(namespace, identifier), object));
                return object;
            }
        }));
    }

    private <T> void addEntry(Registries.Registry<T> registry, String identifier, Supplier<T> entry) {
        this.addEntry(registry, this.modid, identifier, entry);
    }

    private <T> void addEntry(Registries.Registry<T> registry, String namespace, String identifier, Supplier<T> entry) {
        if (this.encounteredEvents.contains(registry)) {
            throw new IllegalStateException("Cannot register new entries after RegisterEvent has been fired!");
        }
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        if (entry == null) {
            throw new IllegalArgumentException("Entry supplier for '" + namespace + ":" + identifier + "' must not be null!");
        }
        ResourceLocation fullIdentifier = new ResourceLocation(namespace, identifier);
        Map entries = this.entryMap.computeIfAbsent(registry, o -> new HashMap());
        if (entries.containsKey(fullIdentifier)) {
            throw new RuntimeException("Duplicate entry '" + fullIdentifier + "' for registry '" + registry.getRegistryIdentifier() + "'!");
        }
        entries.put(fullIdentifier, entry);
    }

    private <T> void addCallback(Registries.Registry<T> registry, Consumer<Helper<T>> callback) {
        if (this.encounteredEvents.contains(registry)) {
            throw new IllegalStateException("Cannot register callbacks after RegisterEvent has been fired!");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Registration callback must not be null!");
        }
        this.callbacks.computeIfAbsent(registry, o -> new ArrayList()).add(callback);
    }

    private void handleRegisterEvent(RegisterEvent event) {
        Registries.Registry registry;
        Registries.Registry registry2 = registry = event.getForgeRegistry() == null ? Registries.fromUnderlying(event.getVanillaRegistry()) : Registries.fromUnderlying(event.getForgeRegistry());
        if (registry == null) {
            return;
        }
        this.handleRegistry(registry);
        for (Registries.Registry otherRegistry : Registries.REGISTRATION_ORDER_MAP.getOrDefault(registry, Collections.emptyList())) {
            this.handleRegistry(otherRegistry);
        }
    }

    private void handleRegistry(Registries.Registry<?> registry) {
        this.encounteredEvents.add(registry);
        if (this.entryMap.containsKey(registry)) {
            this.registerEntries(registry);
        }
        if (this.callbacks.containsKey(registry)) {
            this.callCallbacks(registry);
        }
    }

    private <T> void registerEntries(Registries.Registry<T> registry) {
        Map<ResourceLocation, Supplier<?>> entries = this.entryMap.get(registry);
        for (Map.Entry<ResourceLocation, Supplier<?>> entry : entries.entrySet()) {
            Object object = entry.getValue().get();
            registry.register(entry.getKey(), object);
        }
    }

    private void callCallbacks(Registries.Registry<?> registry) {
        Helper helper = new Helper(registry);
        List<Consumer<Helper<?>>> callbacks = this.callbacks.get(registry);
        for (Consumer<Helper<?>> callback : callbacks) {
            callback.accept(helper);
        }
    }

    public class Helper<T> {
        private final Registries.Registry<T> registry;

        public Helper(Registries.Registry<T> registry) {
            this.registry = registry;
        }

        public <X extends T> X register(String identifier, X object) {
            this.register(RegistrationHandler.this.modid, identifier, object);
            return object;
        }

        public <X extends T> X registerOverride(String namespace, String identifier, X object) {
            this.register(namespace, identifier, object);
            return object;
        }

        private void register(String namespace, String identifier, T object) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            ResourceLocation fullIdentifier = new ResourceLocation(namespace, identifier);
            Map entries = RegistrationHandler.this.entryMap.computeIfAbsent(this.registry, o -> new HashMap());
            if (entries.containsKey(fullIdentifier)) {
                throw new RuntimeException("Duplicate entry '" + fullIdentifier + "' for registry '" + this.registry.getRegistryIdentifier() + "'!");
            }
            this.registry.register(fullIdentifier, object);
        }
    }
}

