/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.supermartijn642.rechiseled.model.RechiseledModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class RechiseledModelDeserializer {
    public static RechiseledModel deserialize(JsonObject json, JsonDeserializationContext context) {
        boolean shouldConnect = GsonHelper.m_13855_((JsonObject)json, (String)"should_connect", (boolean)false);
        Map<String, Either<Pair<Material, Boolean>, String>> map = RechiseledModelDeserializer.getTextureMap(json);
        List<BlockElement> elements = RechiseledModelDeserializer.deserializeElements(json, context);
        String parentString = GsonHelper.m_13851_((JsonObject)json, (String)"parent", (String)"");
        ResourceLocation parent = parentString.isEmpty() ? null : new ResourceLocation(parentString);
        boolean ambientOcclusion = GsonHelper.m_13855_((JsonObject)json, (String)"ambientocclusion", (boolean)true);
        ItemTransforms cameraTransforms = ItemTransforms.f_111786_;
        if (json.has("display")) {
            JsonObject transform = GsonHelper.m_13930_((JsonObject)json, (String)"display");
            cameraTransforms = (ItemTransforms)context.deserialize((JsonElement)transform, ItemTransforms.class);
        }
        List<ItemOverride> overrides = RechiseledModelDeserializer.getOverrides(context, json);
        BlockModel.GuiLight guiLighting = null;
        if (json.has("gui_light")) {
            guiLighting = BlockModel.GuiLight.m_111527_((String)GsonHelper.m_13906_((JsonObject)json, (String)"gui_light"));
        }
        return new RechiseledModel(shouldConnect, parent, elements, map, ambientOcclusion, guiLighting, cameraTransforms, overrides);
    }

    private static List<BlockElement> deserializeElements(JsonObject json, JsonDeserializationContext context) {
        ArrayList parts = Lists.newArrayList();
        if (json.has("elements")) {
            for (JsonElement element : GsonHelper.m_13933_((JsonObject)json, (String)"elements")) {
                parts.add((BlockElement)context.deserialize(element, BlockElement.class));
            }
        }
        return parts;
    }

    private static List<ItemOverride> getOverrides(JsonDeserializationContext context, JsonObject json) {
        ArrayList overrides = Lists.newArrayList();
        if (json.has("overrides")) {
            for (JsonElement jsonelement : GsonHelper.m_13933_((JsonObject)json, (String)"overrides")) {
                overrides.add((ItemOverride)context.deserialize(jsonelement, ItemOverride.class));
            }
        }
        return overrides;
    }

    private static Map<String, Either<Pair<Material, Boolean>, String>> getTextureMap(JsonObject json) {
        ResourceLocation blockAtlas = TextureAtlas.f_118259_;
        HashMap map = Maps.newHashMap();
        if (json.has("model_textures")) {
            JsonObject textures = GsonHelper.m_13930_((JsonObject)json, (String)"model_textures");
            for (Map.Entry entry : textures.entrySet()) {
                if (((JsonElement)entry.getValue()).isJsonObject()) {
                    map.put((String)entry.getKey(), RechiseledModelDeserializer.parseTextureLocationOrReference(blockAtlas, GsonHelper.m_13906_((JsonObject)((JsonElement)entry.getValue()).getAsJsonObject(), (String)"location"), GsonHelper.m_13855_((JsonObject)((JsonElement)entry.getValue()).getAsJsonObject(), (String)"connecting", (boolean)false)));
                    continue;
                }
                map.put((String)entry.getKey(), RechiseledModelDeserializer.parseTextureLocationOrReference(blockAtlas, ((JsonElement)entry.getValue()).getAsString(), false));
            }
        }
        return map;
    }

    private static Either<Pair<Material, Boolean>, String> parseTextureLocationOrReference(ResourceLocation atlas, String reference, boolean connecting) {
        if (reference.charAt(0) == '#') {
            return Either.right((Object)reference.substring(1));
        }
        ResourceLocation resourcelocation = ResourceLocation.m_135820_((String)reference);
        if (resourcelocation == null) {
            throw new JsonParseException(reference + " is not valid resource location");
        }
        return Either.left((Object)Pair.of((Object)new Material(atlas, resourcelocation), (Object)connecting));
    }
}

