/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.rechiseled.screen.BlockCapture;
import com.supermartijn642.rechiseled.screen.ScreenBlockRenderer;
import com.supermartijn642.rechiseled.screen.ScreenItemRender;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class EntryPreviewWidget
extends Widget {
    private static final int ROTATION_TIME = 10000;
    private final Supplier<Item> item;
    private final Supplier<Integer> previewMode;
    private final Supplier<Integer> guiLeft;
    private final Supplier<Integer> guiTop;
    private float yaw = 0.35f;
    private float pitch = 30.0f;
    private long lastRotationTime;
    private boolean dragging = false;
    private int mouseStartX;
    private int mouseStartY;

    public EntryPreviewWidget(int x, int y, int width, int height, Supplier<Item> item, Supplier<Integer> previewMode, Supplier<Integer> guiLeft, Supplier<Integer> guiTop) {
        super(x, y, width, height);
        this.item = item;
        this.previewMode = previewMode;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.lastRotationTime = System.currentTimeMillis();
    }

    protected Component getNarrationMessage() {
        return null;
    }

    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        long now = System.currentTimeMillis();
        Item item = this.item.get();
        int previewMode = this.previewMode.get();
        if (item != null && previewMode >= 0 && previewMode <= 2) {
            if (this.dragging) {
                this.yaw = (float)((double)this.yaw + (double)(mouseX - this.mouseStartX) / 100.0 * 360.0);
                this.pitch = (float)((double)this.pitch + (double)(mouseY - this.mouseStartY) / 100.0 * 360.0);
                this.mouseStartX = mouseX;
                this.mouseStartY = mouseY;
            } else {
                this.yaw = (float)((double)this.yaw + (double)(now - this.lastRotationTime) / 10000.0 * 360.0);
            }
            if (item instanceof BlockItem) {
                BlockCapture capture;
                Block block = ((BlockItem)item).m_40614_();
                if (previewMode == 0) {
                    capture = new BlockCapture(block);
                } else if (previewMode == 1) {
                    capture = new BlockCapture(block);
                    capture.putBlock(new BlockPos(-1, 0, 0), block);
                    capture.putBlock(new BlockPos(1, 0, 0), block);
                } else {
                    capture = new BlockCapture();
                    for (int i = 0; i < 9; ++i) {
                        capture.putBlock(new BlockPos(i / 3 - 1, i % 3 - 1, 0), block);
                    }
                }
                ScreenBlockRenderer.drawBlock(capture, (double)(this.guiLeft.get() + this.x) + (double)this.width / 2.0, (double)(this.guiTop.get() + this.y) + (double)this.height / 2.0, this.width, this.yaw, this.pitch, false);
            } else {
                ScreenItemRender.drawItem(item, (double)(this.guiLeft.get() + this.x) + (double)this.width / 2.0, (double)(this.guiTop.get() + this.y) + (double)this.height / 2.0, this.width, this.yaw, this.pitch, true);
            }
        }
        this.lastRotationTime = now;
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
        if (mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height) {
            this.dragging = true;
            this.mouseStartX = mouseX;
            this.mouseStartY = mouseY;
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int button) {
        this.dragging = false;
    }
}

