/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.texture;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraftforge.common.data.ExistingFileHelper;

public class TextureMappingTool {
    private static final Field clientResources;

    public static Map<Integer, Integer> createPaletteMap(BufferedImage from, BufferedImage to) {
        if (from.getWidth() != to.getWidth() || from.getHeight() != to.getHeight()) {
            throw new IllegalArgumentException("Old palette image must be the same size as new palette image!");
        }
        HashMap<Integer, Integer> palette = new HashMap<Integer, Integer>();
        for (int x = 0; x < from.getWidth(); ++x) {
            for (int y = 0; y < from.getHeight(); ++y) {
                palette.put(from.getRGB(x, y), to.getRGB(x, y));
            }
        }
        return palette;
    }

    public static void applyPaletteMap(BufferedImage image, Map<Integer, Integer> palette, String name) {
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int color = image.getRGB(x, y);
                if (color == 0) continue;
                if (!palette.containsKey(color)) {
                    throw new IllegalStateException("Palette is missing color '" + new Color(color) + "' for pattern '" + name + "'");
                }
                image.setRGB(x, y, palette.get(color));
            }
        }
    }

    public static List<String> getSuffixes(String name, ExistingFileHelper existingFileHelper) {
        MultiPackResourceManager resourceManager;
        try {
            clientResources.setAccessible(true);
            resourceManager = (MultiPackResourceManager)clientResources.get(existingFileHelper);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
        ArrayList<String> suffixes = new ArrayList<String>();
        resourceManager.m_7536_().filter(pack -> pack.m_5698_(PackType.CLIENT_RESOURCES).size() == 1 && pack.m_5698_(PackType.CLIENT_RESOURCES).contains("rechiseled")).forEach(pack -> pack.m_7466_(PackType.CLIENT_RESOURCES, "rechiseled", "textures/block", Integer.MAX_VALUE, s -> s.startsWith(name) && s.endsWith(".png")).stream().map(s -> {
            int beginOffset = s.m_135815_().indexOf(name) + name.length();
            int end = s.m_135815_().length() - ".png".length();
            return s.m_135815_().substring(beginOffset, end);
        }).forEach(suffixes::add));
        return suffixes;
    }

    static {
        Field clientResources_ = null;
        try {
            clientResources_ = ExistingFileHelper.class.getDeclaredField("clientResources");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        clientResources = clientResources_;
    }
}

