/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef;

import net.montoyo.mcef.api.API;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.mcef.api.IDisplayHandler;
import net.montoyo.mcef.api.IJSQueryHandler;
import net.montoyo.mcef.api.IScheme;
import net.montoyo.mcef.utilities.Log;

public class BaseProxy
implements API {
    private static final int PUNYCODE_TMIN = 1;
    private static final int PUNYCODE_TMAX = 26;
    private static final int PUNYCODE_SKEW = 38;
    private static final int PUNYCODE_DAMP = 700;
    private static final int PUNYCODE_INITIAL_BIAS = 72;
    private static final int PUNYCODE_INITIAL_N = 128;

    public void onPreInit() {
    }

    public void onInit() {
        Log.info("MCEF is running on server. Nothing to do.", new Object[0]);
    }

    @Override
    public IBrowser createBrowser(String url, boolean transparent) {
        Log.warning("A mod called API.createBrowser() from server! Returning null...", new Object[0]);
        return null;
    }

    @Override
    public IBrowser createBrowser(String url) {
        return this.createBrowser(url, false);
    }

    @Override
    public void registerDisplayHandler(IDisplayHandler idh) {
        Log.warning("A mod called API.registerDisplayHandler() from server!", new Object[0]);
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    public void openExampleBrowser(String url) {
        Log.warning("A mod called API.openExampleBrowser() from server! URL: %s", url);
    }

    @Override
    public void registerJSQueryHandler(IJSQueryHandler iqh) {
        Log.warning("A mod called API.registerJSQueryHandler() from server!", new Object[0]);
    }

    @Override
    public String mimeTypeFromExtension(String ext) {
        Log.warning("A mod called API.mimeTypeFromExtension() from server!", new Object[0]);
        return null;
    }

    @Override
    public void registerScheme(String name, Class<? extends IScheme> schemeClass, boolean std, boolean local, boolean displayIsolated, boolean secure, boolean corsEnabled, boolean cspBypassing, boolean fetchEnabled) {
        Log.warning("A mod called API.registerScheme() from server!", new Object[0]);
    }

    @Override
    public boolean isSchemeRegistered(String name) {
        Log.warning("A mod called API.isSchemeRegistered() from server!", new Object[0]);
        return false;
    }

    public void onShutdown() {
    }

    private static int punycodeBiasAdapt(int delta, int numPoints, boolean firstTime) {
        delta = firstTime ? (delta /= 700) : (delta /= 2);
        int k = 0;
        delta += delta / numPoints;
        while (delta > 455) {
            delta /= 35;
            k += 36;
        }
        return k + 36 * delta / (delta + 38);
    }

    private static void punycodeEncodeNumber(StringBuilder dst, int q, int bias) {
        boolean keepGoing = true;
        int k = 36;
        while (keepGoing) {
            int digit;
            int t = k - bias;
            if (t < 1) {
                t = 1;
            } else if (t > 26) {
                t = 26;
            }
            if (q < t) {
                digit = q;
                keepGoing = false;
            } else {
                digit = t + (q - t) % (36 - t);
                q = (q - t) / (36 - t);
            }
            if (digit < 26) {
                dst.append((char)(97 + digit));
            } else {
                dst.append((char)(48 + digit - 26));
            }
            k += 36;
        }
    }

    private static String punycodeEncodeString(int[] input) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < input.length; ++i) {
            if (input[i] >= 128) continue;
            output.append((char)input[i]);
        }
        int n = 128;
        int delta = 0;
        int bias = 72;
        int h = output.length();
        int b = h;
        if (b > 0) {
            output.append('-');
        }
        while (h < input.length) {
            int i;
            int m = Integer.MAX_VALUE;
            for (i = 0; i < input.length; ++i) {
                if (input[i] < n || input[i] >= m) continue;
                m = input[i];
            }
            delta += (m - n) * (h + 1);
            n = m;
            for (i = 0; i < input.length; ++i) {
                int c = input[i];
                if (c < n) {
                    ++delta;
                }
                if (c != n) continue;
                BaseProxy.punycodeEncodeNumber(output, delta, bias);
                bias = BaseProxy.punycodeBiasAdapt(delta, h + 1, h == b);
                delta = 0;
                ++h;
            }
            ++delta;
            ++n;
        }
        return "xn--" + output.toString();
    }

    @Override
    public String punycode(String url) {
        int protoEnd = url.indexOf("://");
        protoEnd = protoEnd < 0 ? 0 : (protoEnd += 3);
        int hostEnd = url.indexOf(47, protoEnd);
        if (hostEnd < 0) {
            hostEnd = url.length();
        }
        String hostname = url.substring(protoEnd, hostEnd);
        boolean doTransform = false;
        for (int i = 0; i < hostname.length(); ++i) {
            if (hostname.charAt(i) < '\u0080') continue;
            doTransform = true;
            break;
        }
        if (!doTransform) {
            return url;
        }
        String[] parts = hostname.split("\\.");
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append(url, 0, protoEnd);
        for (String p : parts) {
            doTransform = false;
            for (int i = 0; i < p.length(); ++i) {
                if (p.charAt(i) < '\u0080') continue;
                doTransform = true;
                break;
            }
            if (first) {
                first = false;
            } else {
                sb.append('.');
            }
            if (doTransform) {
                sb.append(BaseProxy.punycodeEncodeString(p.codePoints().toArray()));
                continue;
            }
            sb.append(p);
        }
        sb.append(url, hostEnd, url.length());
        return sb.toString();
    }
}

